@extends('frontend.theme_2.app')

@section('title', __('service_details') . ' || ' . $companyName)

@section('content')
<div class="container">
    <div class="simple-breadcrumb card my-4">
        <div class="card-body d-flex align-items-center gap-2 flex-wrap">
            <a href="{{url('/')}}" class="text-dark">{{ __('Home') }}</a>
            <i class="isax isax-arrow-right-3"></i>
            <a href="/services" class="text-dark">{{ __('service_list') }}</a>
            <i class="isax isax-arrow-right-3"></i>
            <a href="javascript:void(0);" class="text-body">{{ __('service_details') }}</a>
        </div>
    </div>
</div>
<div class="page-wrapper">
    <!-- Start Content -->
    @include('frontend.loader.content_loader')
    <div class="content pt-3 service-detail-container" style="display: none;">
        <div class="container">
            <input type="hidden" id="product_id" name="product_id" value="{{ $products->id ?? '' }}">
            <input type="hidden" id="auth_id" name="auth_id" value="{{ Auth::id() ?? '' }}">
            <!-- start row -->
            <div class="row">
                <div class="col-lg-8">
                    <div class="product-wrap service-wrap card mb-4 rounded shadow-none border-0">
                        <div class="card-body rounded pt-0 pb-0">
                            <div class="slider-wrap mobile-slider">
                                <!-- Large Image -->
                                <div class="slider-for nav-center" id="large-img">
                                </div>
                            </div>
                        </div>
                        <!-- Thumbnails -->
                        <div class="slider-nav nav-center mt-3" id="small-img">
                        </div>
                    </div>
                    <!-- start item-->
                    <div class="card mb-4">
                        <div class="card-body">
                            <!-- start row -->
                            <div class="row row-gap-3 align-items-center">
                                <div class="col-lg-10 details-left">
                                    <h3 class="mb-4" id="main_header"></h3>
                                    <div class="d-flex align-items-center fs-14 mb-0 text-body flex-wrap gap-2">
                                        <p class="mb-0 badge bg-soft-purple text-purple" id="shop"></p>
                                        <small class="text-gray-900">|</small>
                                        <div class="d-flex align-items-center gap-1">
                                            <div id="star_container" class="d-flex align-items-center"></div>
                                            <p class="fs-14 mb-0 text-body ms-2">
                                                <span id="reviews_count"></span>
                                            </p>
                                        </div>
                                        <small>|</small>
                                        <p class="mb-0"> {{ __('no_of_bookings') }} : <span class="text-body" id="booking_count"> </span></p>
                                        <small>|</small>
                                        <p class="mb-0 d-flex align-items-center gap-1"><i class="isax isax-location"></i> <span id="location"></span></p>
                                    </div>
                                </div>
                                <div class="col-lg-2">
                                    <div class="d-flex align-items-center justify-content-start justify-content-lg-end gap-2 mb-4 service-icons">
                                        <a href="javascript:void(0);" class="btn-icon flex-shrink-0 favourite" id="add_wishlist" data-type="services">
                                            <i class="isax isax-heart"></i>
                                        </a>
                                        <a href="javascript:void(0);" class="btn-icon flex-shrink-0" id="trending" data-bs-toggle="modal" data-bs-target="#shareModal">
                                            <i class="isax isax-share text-dark"></i>
                                        </a>
                                    </div>
                                    <div class="text-lg-end">
                                        <p class="fs-14 mb-1">{{ __('start_from') }}</p>
                                        <h5 class="mb-0" id="amount"></h5>
                                    </div>
                                </div>
                            </div>
                            <!-- end row -->
                        </div>
                    </div>

                    <!-- start tab -->
                    <ul class="nav nav-tabs nav-bordered mb-4">
                        <li class="nav-item">
                            <a href="#overview" data-bs-toggle="tab" aria-expanded="false" class="nav-link active">
                                <span>{{ __('overview') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#services" data-bs-toggle="tab" aria-expanded="true" class="nav-link">
                                <span>{{ __('services') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#gallery" data-bs-toggle="tab" aria-expanded="false" class="nav-link">
                                <span>{{ __('gallery') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#reviews" data-bs-toggle="tab" aria-expanded="false" class="nav-link">
                                <span>{{ __('Reviews') }}</span>
                            </a>
                        </li>
                    </ul>
                    <!-- end tab -->

                    <div class="tab-content">
                        <!-- !st tab -->
                        <div class="tab-pane active" id="overview">
                            <div>
                                <div class="overview_details">
                                </div>
                                <!-- Over view item end -->
                                <!-- iclued item end-->
                            </div>
                        </div>
                        <!-- 2nd tab -->
                        <div class="tab-pane" id="services">
                            <div>
                                <h5 class="mb-4">{{ __('additional_services') }} <span id="additional_service_count"></span></h5>
                                <div class="row row-gap-3 add_services_container">
                                </div>
                            </div>
                        </div>
                        <!-- 3th tab -->
                        <div class="tab-pane" id="gallery">
                            <div>
                                <div class="section-header mb-4">
                                    <h5 class="title fs-20 mb-0">{{ __('images') }}</h5>
                                </div>
                                <div class="row row-gap-3 border-bottom mb-4 pb-4 gallery_images">
                                </div>
                                <div>
                                    <div class="section-header mb-4">
                                        <h5 class="title fs-20 mb-0">{{ __('video') }}</h5>
                                    </div>
                                    <div class="video-custom-icon position-relative video-container">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- 4rd tab -->
                        <div class="tab-pane" id="reviews">
                            <!-- start row -->
                            <div class="section-header mb-4">
                                <h5 class="title fs-20 mb-0"><span class="total_reviews"></span> {{ $products->source_name ?  __('for') . ' ' . $products->source_name : ''   }}</h5>
                            </div>
                            <div class="row gy-4 mb-4">
                                <div class="col-lg-6 d-flex">
                                    <div class="p-4 bg-light rounded text-center d-flex align-items-center justify-content-center flex-column flex-fill border">
                                        <h6 class="mb-4 fs-16 fw-medium">{{ __('Customer Reviews & Ratings') }}</h6>
                                        <div class="d-flex align-items-center justify-content-center gap-1 mb-2 star_icons">
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                        </div>
                                        <div class="mb-3">
                                            <h2 class="mb-0"><span class="average_ratings">0.0</span> / 5.0</h2>
                                        </div>
                                        <p class="mb-0 fs-14">{{ __('basedon') }} <span class="total_reviews">0 {{ __('review') }}</span></p>
                                    </div>
                                </div> <!-- end col -->

                                <div class="col-lg-6 d-flex">
                                    <div class="card shadow-none review-progress flex-fill mb-0">
                                        <div class="card-body d-flex flex-column justify-content-center">

                                            <!-- Progress 1 -->
                                            <div class="progress-lvl mb-2">
                                                <p class="fw-normal text-body text-start">5 {{ __('Star Ratings') }}</p>
                                                <div class="progress">
                                                    <div class="progress-bar bg-warning five-star" id="5_star_progress" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>
                                                <p class="fw-normal text-body text-end" id="5_star_count">0</p>
                                            </div>

                                            <!-- Progress 2 -->
                                            <div class="progress-lvl mb-2">
                                                <p class="fw-normal text-body">4 {{ __('Star Ratings') }}</p>
                                                <div class="progress">
                                                    <div class="progress-bar bg-warning" id="4_star_progress" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>
                                                <p class="fw-normal text-body text-end" id="4_star_count">0</p>
                                            </div>

                                            <!-- Progress 3 -->
                                            <div class="progress-lvl mb-2">
                                                <p class="fw-normal text-body text-start">3 {{ __('Star Ratings') }}</p>
                                                <div class="progress">
                                                    <div class="progress-bar bg-warning" id="3_star_progress" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>
                                                <p class="fw-normal text-body text-end" id="3_star_count">0</p>
                                            </div>

                                            <!-- Progress 4 -->
                                            <div class="progress-lvl mb-2">
                                                <p class="fw-normal text-body text-start">2 {{ __('Star Ratings') }}</p>
                                                <div class="progress">
                                                    <div class="progress-bar bg-warning" id="2_star_progress" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>
                                                <p class="fw-normal text-body text-end" id="2_star_count">0</p>
                                            </div>

                                            <!-- Progress 5 -->
                                            <div class="progress-lvl mb-0">
                                                <p class="fw-normal mb-0 text-body text-start">1 {{ __('Star Ratings') }}</p>
                                                <div class="progress">
                                                    <div class="progress-bar bg-warning" id="1_star_progress" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>
                                                <p class="fw-normal mb-0 text-body text-end" id="1_star_count">0</p>
                                            </div>
                                        </div> <!-- end card -->
                                    </div> <!-- end col -->
                                </div>
                            </div>
                            <!-- end row -->
                            <!-- start review item-two -->
                            <div id="review_list_main_container">
                                <div id="review_list_container" data-is_allow_reply="{{ isAllowReply($products->id, 'service', Auth::user()->id ?? '') }}">
                                </div>
                                <div class="d-flex align-items-center justify-content-center mt-3 mb-3">
                                    <button type="button" class="btn btn-dark d-inline-flex align-items-center load-more-reviews-btn d-none"><i class="isax isax-rotate-left me-1"></i>{{ __('load_more') }}</button>
                                </div>
                            </div>
                            @if (Auth::check() && Auth::user()->user_type == 3)
                                @if (!reviewExists($product->id ?? '') )
                                    <div class="card">
                                        <div class="card-body">
                                            <form id="reviewForm" autocomplete="off">
                                                <h5 class="mb-3">{{ __('Write a Review') }}</h5>
                                                <div class="row">
                                                    <div class="col-lg-12">
                                                        <div class="mb-3">
                                                            <label class="form-label">{{ __('your_ratings') }}</label>
                                                            <div class="rating star-box ratings_stars">
                                                                <i class="fas fa-star"></i>
                                                                <i class="fas fa-star"></i>
                                                                <i class="fas fa-star"></i>
                                                                <i class="fas fa-star"></i>
                                                                <i class="fas fa-star"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="review" class="form-label">{{ __('review') }}</label>
                                                    <textarea class="form-control" rows="4" name="review" id="review"></textarea>
                                                    <span class="text-danger error-text" id="review_error"></span>
                                                </div>
                                                <button type="submit" class="btn btn-dark submit-review">{{ __('submit') }}</button>
                                            </form>
                                        </div>
                                    </div>
                                @endif
                            @endif
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <!-- Item-->
                    <div class="card ">
                        <div class="card-body">
                            <div>
                                <h5 class="mb-3 pb-3 border-bottom">{{ __('book_your_service') }}</h5>
                            </div>
                            <div class="d-flex align-items-center justify-content-center flex-column gap-2">
                                <input type="hidden" id="product_slug" value="{{ $products->slug }}">
                                @if (Auth::check() && Auth::user()->user_type == 3)
                                    <a href="#" id="bookServiceButton"
                                        class="btn btn-secondary w-100 book-btn d-flex align-items-center justify-content-center gap-2">
                                        <i class="isax isax-calendar-edit"></i> {{ __('book_now') }}
                                    </a>
                                @elseif (Auth::check() && Auth::user()->user_type == 2 && $products->user_id == Auth::user()->id)
                                    <a href="{{ route('provider.service') }}"
                                        class="btn btn-secondary w-100 d-flex align-items-center justify-content-center gap-2">
                                        {{ __('My Service') }}
                                    </a>
                                @elseif (Auth::check() && Auth::user()->user_type == 2 && $products->user_id != Auth::user()->id)
                                    <a href="{{ url('servicedetail/' . $products->slug) }}"
                                        class="btn btn-secondary w-100 d-flex align-items-center justify-content-center gap-2">
                                        <i class="isax isax-calendar-edit"></i> {{ __('book_now') }}
                                    </a>
                                @else
                                    <a href="{{ url('user/login') }}"
                                        class="btn btn-secondary w-100 d-flex align-items-center justify-content-center gap-2">
                                        <i class="isax isax-calendar-edit"></i> {{ __('book_now') }}
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="card service-provider-card">
                        <div class="card-body">
                            <div>
                                <div class="mb-3 pb-3 border-bottom d-flex align-items-center justify-content-between flex-wrap gap-2">
                                    <h5 class="mb-0">{{ __('service_provider') }}</h5>
                                </div>

                                <div class="mb-3 pb-3 border-bottom d-flex align-items-center gap-2 d-flex align-items-center justify-content-between gap-2 flex-wrap">
                                    <div class="d-flex align-items-center gap-2">
                                        <div class="avatar avatar-xl">
                                            <img src="" alt="user" class="img-fluid rounded-circle" id="provider_avatar">
                                        </div>
                                        <div>
                                            <h6 class="mb-1" id="provider_name"></h6>
                                            <p class="mb-0 d-flex align-items-center gap-1"><i class="fa-solid fa-star text-warning"></i><span id="provider_rating"></span></p>
                                        </div>
                                    </div>
                                    <span class="badge bg-success"><i class="isax isax-shield-tick"></i> {{ __('verified') }}</span>
                                </div>

                                <div class="d-flex align-items-center gap-2 mb-3">
                                    <div>
                                        <h6 class="mb-1 fs-16">Email</h6>
                                        <p class="mb-0" id="provider_email_text"></p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center gap-2 mb-3">
                                    <div>
                                        <h6 class="mb-1 fs-16">{{ __('phone') }}</h6>
                                        <p class="mb-0" id="provider_mobile"></p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center gap-2 mb-3">
                                    <div>
                                        <h6 class="mb-1 fs-16">{{ __('address') }}</h6>
                                        <p class="mb-0" id="provider_address"></p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center gap-2 mb-3 pb-3 border-bottom">
                                    <div>
                                        <h6 class="mb-1 fs-16">{{ __('member_since') }}</h6>
                                        <p class="mb-0" id="member_since"></p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center gap-3 mb-3 pb-3 border-bottom social-icon">

                                </div>
                                @if (!Auth::check() || Auth::user()->user_type != 2 || $products->user_id != Auth::user()->id)
                                    <a href="#" data-bs-toggle="modal" data-bs-target="#add_enquiry"
                                        class="btn btn-secondary w-100 d-flex align-items-center justify-content-center">
                                        {{ __('enquire_vendor') }}
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="card mb-0">
                        <div class="card-body">
                            <div>
                                <h5 class="mb-3 pb-3 border-bottom">{{ __('location') }}</h5>
                                <div class="custom-map position-relative custom-padding w-100">
                                    <iframe class="w-100 rounded" src="" class="border-0" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade" title="Map"></iframe>
                                    <a href="javascript:void(0);" class="btn btn-sm btn-light position-absolute">{{ __('view_location') }}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end row -->

            <!-- start slider -->
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="d-flex align-items-center justify-content-between mb-4 mt-5 pt-4 border-top">
                            <h4 class="mb-0">{{ __('related_services') }}</h4>
                            <div class="d-flex gap-2">
                                <button class="btn btn-outline-secondary btn-sm rounded-circle" id="prevBtn">
                                    <i class="fa-solid fa-chevron-left"></i>
                                </button>
                                <button class="btn btn-outline-secondary btn-sm rounded-circle" id="nextBtn">
                                    <i class="fa-solid fa-chevron-right"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row" id="related_services_container">
                    <!-- Services will be dynamically inserted here -->
                </div>
            </div>
            <!-- end slider -->
        </div>
    </div>
    <!-- End Content -->
</div>

<!-- Reply Review Modal -->
<div id="reply_review_modal" class="modal fade">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form id="replyReviewForm" autocomplete="off">
                <div class="modal-header">
                    <h6 class="modal-title fw-bold">{{ __('add_reply') }}</h6>
                    <button type="button" class="btn-close btn-close-modal custom-btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="isax isax-close-circle"></i></button>
                </div>
                <div class="modal-body">
                    <div class="mb-0">
                        <input type="hidden" id="review_id" name="review_id">
                        <label class="form-label">{{ __('your_reply') }}<span class="text-danger ms-1">*</span></label>
                        <textarea class="form-control fs-14" name="reply_message" id="reply_message" rows="3"></textarea>
                        <span class="text-danger error-text" id="reply_message_error"></span>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="d-flex align-items-center justify-content-end">
                        <button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                        <button type="submit" class="btn btn-secondary send-reply">{{ __('submit') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- End Reply Review Modal -->

<div class="modal fade" id="add_enquiry">
    <div class="modal-dialog modal-dialog-centered  modal-lg">
        <div class="modal-content">
            <div class="modal-header d-flex align-items-center justify-content-between border-bottom">
                <h4 class="modal-title">{{ __('add_enquiry')}}</h4>
                <a href="javascript:void(0);" data-bs-dismiss="modal" aria-label="Close"><i class="ti ti-circle-x-filled fs-20"></i>x</a>
            </div>
            <form id="enquiryForm">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <input type="hidden" name="provider_email" id="provider_email" class="form-control provider_email">

                            <div class="mb-3">
                                <label class="form-label">{{ __('Name')}}</label><span class="text-danger"> *</span>
                                <input type="text" name="name" id="name" class="form-control validate-input" placeholder="{{ __('enter_name') }}">
                                <span class="text-danger error-text" id="name_error"></span>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">{{ __('Email')}}</label><span class="text-danger"> *</span>
                                <input type="email" name="email" id="email" class="form-control validate-input" placeholder="{{ __('enter_email') }}">
                                <span class="text-danger error-text" id="email_error"></span>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">{{ __('Phone Number')}}</label><span class="text-danger"> *</span>
                                <input type="number" name="phone_number" id="phone_number" class="form-control validate-input" placeholder="{{ __('enter_phone') }}">
                                <span class="text-danger error-text" id="phone_number_error"></span>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">{{ __('Message') }}</label><span class="text-danger"> *</span>
                                <textarea name="message" id="message" class="form-control validate-input" rows="4" placeholder="{{ __('enter_message') }}"></textarea>
                                <span class="text-danger error-text" id="message_error"></span>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="#" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('Cancel')}}</a>
                    <button type="submit" class="btn btn-primary add_enquiry_btn">{{ __('Save')}}</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="shareModal" tabindex="-1" aria-labelledby="shareModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 rounded-4">
            <div class="modal-header">
                <h5 class="modal-title" id="shareModalLabel">{{ __('share_now') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                @if (!empty($socialMediaShares) && count($socialMediaShares))
                    <div class="d-flex flex-wrap gap-2 justify-content-center">
                        @foreach ($socialMediaShares as $share)
                            @php
                                $currentUrl = urlencode(url()->current());
                                $platform = strtolower($share->platform_name);

                                switch ($platform) {
                                    case 'facebook':
                                        $targetUrl = "https://www.facebook.com/sharer/sharer.php?u=$currentUrl";
                                        break;
                                    case 'twitter':
                                        $targetUrl = "https://twitter.com/intent/tweet?url=$currentUrl";
                                        break;
                                    case 'linkedin':
                                        $targetUrl = "https://www.linkedin.com/sharing/share-offsite/?url=$currentUrl";
                                        break;
                                    case 'whatsapp':
                                        $targetUrl = "https://api.whatsapp.com/send?text=$currentUrl";
                                        break;
                                    case 'telegram':
                                        $targetUrl = "https://t.me/share/url?url=$currentUrl";
                                        break;
                                    default:
                                        $targetUrl = $share->url ?? "#";
                                }
                            @endphp

                            <a href="{{ $targetUrl }}" target="_blank" class="rounded-circle d-flex align-items-center justify-content-center"
                            title="Share on {{ ucfirst($platform) }}"
                            style="width: 40px; height: 40px; background-color: #3b5998;">
                                <i class="fab {{ $share->icon }} text-white" style="font-size: 18px;"></i>
                            </a>
                        @endforeach
                    </div>
                @else
                    <p class="text-center text-muted">{{ __('No Service Links Available') }}</p>
                @endif
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script src="{{ asset('frontend/assets/js/custom/servicedetail.min.js') }}"></script>
@endpush