@extends('frontend.theme_2.app')

@section('title', __('service_list') . ' || ' . $companyName)
@push('styles')
<!-- Rangeslider CSS -->
<link rel="stylesheet" href="assets/plugins/ion-rangeslider/css/ion.rangeSlider.min.css">
@endpush
@section('content')
<!-- Start Breadscrumb -->
@include('frontend.pages.banner')
<!-- End Breadscrumb -->
<div class="content">
    <input type="hidden" name="user_id" value="{{ $authId }}" id="user_id">
    <div class="container">
        <!-- Start Sub Head -->
        <div class="sub-head-item border-bottom border-color d-flex align-items-center justify-content-between flex-wrap gap-2 pb-4 mb-4">
            <p class="sub-head mb-0" id="total_service"></p>
            <div class="filter-item d-flex align-items-center justify-content-between flex-wrap gap-3">
                <div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
                    <a href="javascript:void(0);" class="btn btn-icon active viewType " id="gridView" aria-label="Grid view" data-view="grid">
                        <i class="isax isax-grid-6" aria-hidden="true"></i>
                    </a>
                    <a href="javascript:void(0);" class="btn btn-icon border border-color viewType " id="listView" aria-label="List view" data-view="list">
                        <i class="isax isax-menu-14" aria-hidden="true"></i>
                    </a>
                </div>
                <div class="dropdown d-flex align-items-center gap-2">
                    <p class="fs-14 fw-medium mb-0">{{ __('sort_by') }} : </p>
                    <a href="javascript:void(0);" class="dropdown-toggle selected-value btn border border-color d-inline-flex align-items-center text-dark fw-normal" data-bs-toggle="dropdown" aria-expanded="false">
                        {{ __('newest') }}
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" id="sort_by">
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1" data-value="new">{{ __('newest') }}</a>
                        </li>
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1" data-value="old">{{ __('oldest') }}</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- end Sub Head -->

        <!-- start row -->
        <div class="row row-gap-4 justify-content-center">

            <!-- Filter -->
            @include('frontend.pages.services.filter')
            <!-- Filter -->
            <input type="hidden" name="language_id" value="{{$data['language_id']}}" id="language_id">

            <div id="service-container" class="col-lg-9">
                   <div class="listCardDiv d-none">
                    <!-- start row -->
                    <div class="row row-gap-4 justify-content-center">
                    </div>
                    <!-- end row -->
                    <div class="text-center mt-5" id="load-more-container">
                        <a href="javascript:void(0);" class="btn btn-dark d-inline-flex align-items-center gap-2" id="load-more"><i class="isax isax-rotate-left"></i>{{ __('loadmore') }}</a>
                    </div>
                </div>
                <!-- Loader Start -->
                @include('frontend.loader.content_loader')
                <!-- Loader End -->
            </div>
        </div>
    </div>
    @include('frontend.toast')
</div>
@endsection

@push('scripts')
<script src="{{ asset('frontend/assets/js/custom/services.min.js') }}"></script>
<!-- Rangeslider JS -->
<script src="assets/plugins/ion-rangeslider/js/custom-rangeslider.js"></script>
<script src="assets/plugins/ion-rangeslider/js/ion.rangeSlider.min.js"></script>
@endpush
