<div class="col-lg-3 row-gap-3">
    <div class="product-sidebar card mb-0">
        <div class="product-sidebar-item card-body">
            <h5 class="pb-3 mb-3 border-bottom d-flex align-items-center justify-content-between">{{ __('filter') }}
                <span class="text-danger fs-16 fw-normal show-cursor-pointer reset-filter">{{ __('reset') }}</span>
            </h5>
            <div class="filter-items">
                <div class="filter-body">
                    @php
                        $maxLimit = 5;
                    @endphp
                    <!-- Highlights Items -->
                    <div class="filter-set mb-4 pb-4 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#highlights" aria-expanded="false" role="button">
                                <h6 class="mb-0 d-flex align-items-center">{{ __('highlights') }}</h6>
                                <i class="isax isax-arrow-down-1"></i>
                            </div>
                        </div>
                        <div id="highlights" class="card-collapse collapse show mt-3">
                            <div>
                                @if(!empty($highlighted) && count($highlighted) > 0)
                                    @foreach($highlighted as $highlighted_index => $highlight)
                                        <div class="form-check d-flex align-items-center ps-0 mb-2">
                                            <input class="form-check-input ms-0 mt-0 highlighted" name="highlighted" type="checkbox" value="{{ $highlighted_index }}">
                                            <label class="form-check-label w-100 d-flex align-items-center justify-content-between ms-2" >
                                                {{ $highlight['title'] }} <span>({{ $highlight['count'] }})</span>
                                            </label>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Shops Items -->
                    <div class="filter-set mb-4 pb-4 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#shops" aria-expanded="false" role="button">
                                <h6 class="mb-0 d-flex align-items-center">{{ __('shops') }}</h6>
                                <i class="isax isax-arrow-down-1"></i>
                            </div>
                        </div>
                        <div id="shops" class="card-collapse collapse show mt-3">
                            @if(!empty($shops) && count($shops) > 0)
                                @foreach($shops as $shop)

                                    @if ($loop->iteration <= $maxLimit)
                                        <div class="form-check d-flex align-items-center ps-0 mb-2">
                                            <input class="form-check-input ms-0 mt-0 shops" name="shops[]" type="checkbox" value="{{ $shop->id }}" id="shop_{{ $shop->id }}">
                                            <label class="form-check-label w-100 d-flex align-items-center justify-content-between ms-2" for="shop_{{ $shop->id }}">
                                                {{ $shop->shop_name }} <span>({{ $shop->products_count }})</span>
                                            </label>
                                        </div>
                                    @elseif($loop->iteration == $maxLimit + 1)
                                        <div class="more-menu-item2 mt-2">
                                            <div class="form-check d-flex align-items-center ps-0 mb-2">
                                                <input class="form-check-input ms-0 mt-0 shops" name="shops[]" type="checkbox" value="{{ $shop->id }}" id="shop_{{ $shop->id }}">
                                                <label class="form-check-label w-100 d-flex align-items-center justify-content-between ms-2" for="shop_{{ $shop->id }}">
                                                    {{ $shop->shop_name }} <span>({{ $shop->products_count }})</span>
                                                </label>
                                            </div>
                                    @else
                                        <div class="form-check d-flex align-items-center ps-0 mb-2">
                                            <input class="form-check-input ms-0 mt-0 shops" name="shops[]" type="checkbox" value="{{ $shop->id }}" id="shop_{{ $shop->id }}">
                                            <label class="form-check-label w-100 d-flex align-items-center justify-content-between ms-2" for="shop_{{ $shop->id }}">
                                                {{ $shop->shop_name }} <span>({{ $shop->products_count }})</span>
                                            </label>
                                        </div>
                                    @endif

                                    @if($loop->last && $loop->iteration > $maxLimit)
                                        </div>
                                        <div class="view-all d-inline-flex align-items-center mt-2">
                                            <a href="javascript:void(0);" class="view-all-item2-button text-secondary">
                                                {{ __('show_more') }}
                                            </a>
                                        </div>
                                    @endif
                                @endforeach
                            @else
                                <p class="text-muted">{{ __('no_shops_found') }}</p>
                            @endif
                        </div>
                    </div>

                    <!-- Vendor Items -->
                    <div class="filter-set mb-4 pb-4 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#vendor" aria-expanded="false" role="button">
                                <h6 class="mb-0 d-flex align-items-center">{{ __('vendor') }}</h6>
                                <i class="isax isax-arrow-down-1"></i>
                            </div>
                        </div>
                        <div id="vendor" class="card-collapse collapse show mt-3">
                            <div>
                                @if(!empty($vendors_locations) && count($vendors_locations) > 0)
                                    @foreach($vendors_locations as $vendor_index => $vendor)
                                        @if($vendor_index >= 5)
                                            <div class="more-menu5 mt-2">
                                        @endif
                                            <div class="form-check d-flex align-items-center ps-0 mb-2">
                                                <input class="form-check-input ms-0 mt-0 vendor" name="vendor" type="checkbox" id="{{$vendor->user_id}}"  value="{{$vendor->user_id}}">
                                                <label class="form-check-label w-100 d-flex align-items-center justify-content-between ms-2" for="{{$vendor->user_id}}">
                                                    {{$vendor->first_name .' '. $vendor->last_name}} <span>({{$vendor->product_count}})</span>
                                                </label>
                                            </div>
                                        @if($vendor_index >= 5)
                                            </div>
                                        @endif
                                    @endforeach
                                @endif
                                @if(count($vendors_locations) > 5)
                                <div class="view-all d-inline-flex align-items-center mt-3">
                                    <a href="javascript:void(0);" class="viewall4-button text-secondary">{{ __('see_more') }}</a>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Categories Items -->
                    <div class="filter-set mb-4 pb-4 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#style" aria-expanded="false" role="button">
                                <h6 class="mb-0 d-flex align-items-center">{{ __('categories') }}</h6>
                                <i class="isax isax-arrow-down-1"></i>
                            </div>
                        </div>
                        <div id="style" class="card-collapse collapse show mt-3">
                            <div>
                                @if(!empty($categories) && count($categories) > 0)
                                    @foreach($categories as $index => $category)
                                        @if ($loop->iteration <= $maxLimit)
                                            <div class="form-check d-flex align-items-center ps-0 mb-2">
                                                <input class="form-check-input ms-0 mt-0 category" name="category" id="category_{{ $category->id ?? ''}}" type="checkbox" value="{{ $category->id ?? ''}}" data-slug="{{ $category->slug ?? '' }}">
                                                <label for="category_{{ $category->id ?? ''}}" class="form-check-label ms-2 d-flex align-items-center justify-content-between w-100">
                                                    {{ $category->name ?? ""}} <span>({{ $category->products_count ?? 0}})</span>
                                                </label>
                                            </div>
                                        @elseif($loop->iteration == $maxLimit + 1)
                                            <div class="more-menu-item3 mt-2">
                                                <div class="form-check d-flex align-items-center ps-0 mb-2">
                                                    <input class="form-check-input ms-0 mt-0 category" name="category" id="category_{{ $category->id ?? ''}}" type="checkbox" value="{{ $category->id ?? ''}}">
                                                    <label for="category_{{ $category->id ?? ''}}" class="form-check-label ms-2 d-flex align-items-center justify-content-between w-100">
                                                        {{ $category->name ?? ""}} <span>({{ $category->products_count ?? 0}})</span>
                                                    </label>
                                                </div>
                                        @else
                                            <div class="form-check d-flex align-items-center ps-0 mb-2">
                                                <input class="form-check-input ms-0 mt-0 category" name="category" id="category_{{ $category->id ?? ''}}" type="checkbox" value="{{ $category->id ?? ''}}">
                                                <label for="category_{{ $category->id ?? ''}}" class="form-check-label ms-2 d-flex align-items-center justify-content-between w-100">
                                                    {{ $category->name ?? ""}} <span>({{ $category->products_count ?? 0}})</span>
                                                </label>
                                            </div>
                                        @endif

                                        @if($loop->last && $loop->iteration > $maxLimit)
                                            </div>
                                            <div class="view-all d-inline-flex align-items-center mt-2">
                                                <a href="javascript:void(0);" class="view-all-item3-button text-secondary">
                                                    {{ __('show_more') }}
                                                </a>
                                            </div>
                                        @endif
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- location Items -->
                    <div class="filter-set mb-4 pb-4 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#location" aria-expanded="false" role="button">
                                <h6 class="mb-0 d-flex align-items-center">{{ __('location') }}</h6>
                                <i class="isax isax-arrow-down-1"></i>
                            </div>
                        </div>
                        <div id="location" class="card-collapse collapse show mt-3">
                            <div>
                                @if(!empty($vendors_locations) && count($vendors_locations) > 0)
                                    @foreach($vendors_locations as $location_index => $location)
                                        @if($location_index >= 5)
                                            <div class="more-menu5 mt-2">
                                        @endif
                                        <div class="form-check d-flex align-items-center ps-0 mb-2">
                                            <input class="form-check-input ms-0 mt-0 filter_location" name="filter_location" type="checkbox" value="{{ $location->id ?? ''}}">
                                            <label class="form-check-label ms-2 d-flex align-items-center justify-content-between w-100">
                                               {{ $location->name}} <span>({{$location->product_count}})</span>
                                            </label>
                                        </div>
                                        @if($location_index >= 5)
                                            </div>
                                        @endif
                                    @endforeach
                                @endif
                                @if(count($vendors_locations) > 5)
                                <div class="view-all d-inline-flex align-items-center mt-3">
                                    <a href="javascript:void(0);" class="viewall5-button text-secondary">{{ __('see_more') }}</a>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Price Items -->
                    <div class="filter-set mb-4 pb-4 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#price-list" aria-expanded="false" role="button">
                                <h6 class="mb-0 d-flex align-items-center">{{ __('price') }}</h6>
                                <i class="isax isax-arrow-down-1"></i>
                            </div>
                        </div>
                        <div id="price-list" class="card-collapse collapse show mt-3">
                            <div>
                                <div id="price" class="card-collapse collapse show mt-4">
                                    <div>
                                        <div class="filter-range">
                                            <input type="text" id="range_03" aria-label="Price Range" class="price_range">
                                            <p class="mb-0 text-body fs-14">{{ __('price') }} : <span class="text-dark">{{$data['currency_code']}}200 - {{$data['currency_code']}}5695</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Reviews Items -->
                    <div class="filter-set mb-4 pb-4 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#reviews" aria-expanded="false" role="button">
                                <h6 class="mb-0 d-flex align-items-center">{{ __('reviews') }}</h6>
                                <i class="isax isax-arrow-down-1"></i>
                            </div>
                        </div>
                        <div id="reviews" class="card-collapse collapse show mt-3">
                            <div>
                                @for ($i = 5; $i >= 1; $i--)
                                    <div class="form-check d-flex align-items-center ps-0 mb-2">
                                        <input class="form-check-input ms-0 mt-0 reviews" name="reviews" type="checkbox" id="check_{{ 45 + $i }}" value="{{ $i }}">
                                        <label class="form-check-label ms-2 d-flex align-items-center flex-xl-nowrap flex-wrap gap-2" for="check_{{ 45 + $i }}">
                                            <span class="review-star mb-0 d-flex align-items-center gap-1">
                                                @for ($j = 1; $j <= 5; $j++)
                                                    @if ($j <= $i)
                                                        <i class="fa-solid fa-star text-warning"></i>
                                                    @else
                                                        <i class="fa-regular fa-star text-warning"></i>
                                                    @endif
                                                @endfor
                                            </span>
                                            <span class="ms-2 mb-0"> {{ $i }} {{ __('star') }} </span>
                                        </label>
                                    </div>
                                @endfor
                            </div>

                        </div>
                    </div>
                </div>
                <div class="filter-footer d-flex flex-xl-nowrap flex-wrap align-items-center justify-content-between gap-2">
                    <a href="javascript:void(0);" class="btn btn-light w-100 reset-filter">{{ __('reset') }}</a>
                    <a href="javascript:void(0);" class="btn btn-secondary w-100" id="filterbtn">{{ __('apply') }} </a>
                </div>
            </div>
        </div>
    </div>
</div>