@extends('frontend.theme_2.app')

@section('title', __('product_details') . ' || ' . $companyName)

@section('content')

<div class="container">
    <div class="simple-breadcrumb card my-4">
        <div class="card-body d-flex align-items-center gap-2 flex-wrap">
            <a href="{{ url('/') }}" class="text-dark">{{ __('home') }}</a>
            <i class="isax isax-arrow-right-3"></i>
            <a href="{{url('/products')}}" class="text-dark">{{ __('products') }}</a>
            <i class="isax isax-arrow-right-3"></i>
            <a href="javascript:void(0);" class="text-dark" id="selected_product_name"></a>
        </div>
    </div>
</div>
<div class="page-wrapper">
    <!-- Start Content -->
    @include('frontend.loader.content_loader')
    <div class="content pt-0">
        <input type="hidden" id="currency" name="currency">
        <input type="hidden" id="product_id" name="product_id" value="{{ $product->id ?? '' }}">
        <input type="hidden" id="auth_id" name="auth_id" value="{{ Auth::id() ?? '' }}">

        <div class="container product-detail-container d-none">
            <!-- start row -->
            <div class="row">
                <div class="col-lg-6">
                    <div class="product-wrap card mb-4 rounded shadow-none border-0">
                        <div class="card-body bg-light rounded">
                            <div class="slider-wrap mobile-slider">
                                <!-- Large Image -->
                                <div class="slider-for nav-center" id="large-img">
                                </div>
                            </div>
                        </div>
                        <!-- Thumbnails -->
                        <div class="slider-nav nav-center mt-3" id="small-img">
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="product-wrap ps-xl-5">
                        <h6 class="mb-3 badge badge-md bg-dark" id="category_name"></h6>
                        <h3 class="mb-3" id="product_name"></h3>
                        <div class="d-flex align-items-center gap-2 mb-3" id="star_container">
                        </div>
                        <div class="mb-4">
                            <p class="mb-2 fw-normal" id="product_description"></p>
                            <div class="my-3 d-flex align-items-center gap-2">
                                <h3 class="mb-0" id="amount"></h3>
                                <h3 class="text-decoration-line-through mb-0 text-body" id="original_amount"></h3>
                                <p class="text-danger fs-13 fw-medium mb-0" id="save_amount"></p>
                            </div>
                            <span class="badge badge-soft-success"> <span id="in_stock">0</span></span>
                        </div>
                        <div class="product-mobile-list mb-4">
                            <p class="fs-14 fw-bold mb-2 text-dark d-flex align-items-center color_data">{{ __('color') }} : <span class="text-body fw-normal" id="product_color"></span></p>
                            <div class="d-flex align-items-center gap-2 flex-wrap" id="product_color_images">
                            </div>
                        </div>
                        <div class="mb-4 add_services_container">
                        </div>
                        <div class="mb-4">
                            <div class="row row-gap-2 ps-xl-2">
                                @if (!Auth::check() || (Auth::check() && Auth::user()->user_type == 3))
                                <div class="col-xl-2 col-lg-3 col-md-2 col-sm-4 px-xl-0 cart-wrap" id="cart-wrap">
                                    <div class="quantity-control bg-light d-flex align-items-center justify-content-between border rounded gap-2 w-100">
                                        <a href="javascript:void(0);" class="minus-btn">-</a>
                                        <input type="text" id="quantity-input" class="quantity-input" value="1" aria-label="Quantity">
                                        <a href="javascript:void(0);" class="add-btn">+</a>
                                    </div>
                                </div>
                                <div class="col-xl-7 col-lg-5 col-md-6 col-sm-4 col-6">
                                    @if ($inCart)
                                    <a href="{{ route('user.cart.view') }}" class="btn btn-dark d-flex align-items-center justify-content-center gap-2 w-100">
                                        <i class="isax isax-shopping-bag"></i>{{ __('go_to_cart') }}
                                    </a>
                                    @else
                                    <a href="javascript:void(0);" id="add-to-cart-btn" class="btn btn-dark d-flex align-items-center justify-content-center gap-2 w-100">
                                        <i class="isax isax-shopping-bag"></i>{{ __('add_to_cart') }}
                                    </a>
                                    @endif
                                </div>
                                <div class="col-xl-3 col-lg-4 col-md-4 col-sm-4 col-6 px-xl-0">
                                    @if ($inCart)
                                    <a href="{{ route('user.cart.view') }}" class="btn btn-secondary d-flex align-items-center gap-2 justify-content-center w-100">
                                        <i class="isax isax-shopping-cart"></i>{{ __('buy_now') }}
                                    </a>
                                    @else
                                    <a href="javascript:void(0);" id="buy-now-btn" class="btn btn-secondary d-flex align-items-center gap-2 justify-content-center w-100">
                                        <i class="isax isax-shopping-cart"></i>{{ __('buy_now') }}
                                    </a>
                                    @endif
                                </div>
                                @elseif (Auth::check() && Auth::user()->user_type == 2)
                                <div class="">
                                    <a href="{{ route('provider.product') }}" id="my_product_btn" class="btn btn-secondary d-flex align-items-center gap-2 justify-content-center w-100">
                                        <i class="isax isax-shopping-cart"></i>{{ __('my_product') }}
                                    </a>
                                </div>
                                @endif
                            </div>
                        </div>
                        <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap mt-4 pt-4 border-top">
                            <div class="d-flex align-items-center gap-3">
                                <a href="avascript:void(0);" class="fs-14 fw-medium d-flex align-items-center gap-2 favourite" id="add_wishlist" data-type="products">
                                    <i class="isax fs-14"></i>{{ __('add_to_wishlist') }}
                                </a>
                            </div>
                            <div class="d-flex align-items-center gap-3">
                                <div class="d-flex align-items-center gap-2 social-icons">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end row -->

            <!-- start tab -->
            <ul class="nav nav-tabs nav-bordered mb-4 mt-5">
                <li class="nav-item">
                    <a href="#overview" data-bs-toggle="tab" aria-expanded="false" class="nav-link active">
                        <span>{{ __('overview') }}</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="#specification" data-bs-toggle="tab" aria-expanded="true" class="nav-link">
                        <span>{{ __('specification') }}</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="#reviews" data-bs-toggle="tab" aria-expanded="false" class="nav-link">
                        <span>{{ __('Reviews') }} (<span class="total_reviews_count">0</span>)</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="#shipping" data-bs-toggle="tab" aria-expanded="false" class="nav-link">
                        <span>{{ __('shipping_and_delivery') }}</span>
                    </a>
                </li>
            </ul>
            <!-- end tab -->

            <div class="tab-content">
                <!-- 1st tab -->
                <div class="tab-pane active" id="overview">
                    <div class="card mb-0">
                        <div class="card-body">
                            <!-- start row -->
                            <div class="row row-gap-4">
                                <div class="col-12">
                                    <div class="overview_details">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- 2nd tab -->
                <div class="tab-pane" id="specification">
                    <div class="table-responsive">
                        <table class="border w-100 table-nowrap" id="specification_table">
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- 3rd tab -->
                <div class="tab-pane" id="reviews">
                    <div class="card">
                        <div class="card-body">
                            <!-- start row -->
                            <div class="section-header mb-4">
                                <h5 class="title fs-20 mb-0"><span class="total_reviews"></span> {{ $product->source_name ?  __('for') . ' ' . $product->source_name : ''   }}</h5>
                            </div>
                            <div class="row gy-4">
                                <div class="col-lg-6 d-flex">
                                    <div class="p-4 bg-light rounded text-center d-flex align-items-center justify-content-center flex-column flex-fill border">
                                        <h6 class="mb-4 fs-16 fw-medium">{{ __('Customer Reviews & Ratings') }}</h6>
                                        <div class="d-flex align-items-center justify-content-center gap-1 mb-2 star_icons">
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                        </div>
                                        <div class="mb-3">
                                            <h2 class="mb-0"><span class="average_ratings">0.0</span> / 5.0</h2>
                                        </div>
                                        <p class="mb-0 fs-14">{{ __('basedon') }} <span class="total_reviews">0 {{ __('review') }}</span></p>
                                    </div>
                                </div> <!-- end col -->

                                <div class="col-lg-6 d-flex">
                                    <div class="card shadow-none review-progress flex-fill mb-0">
                                        <div class="card-body d-flex flex-column justify-content-center">

                                            <!-- Progress 1 -->
                                            <div class="progress-lvl mb-2">
                                                <p class="fw-normal text-body text-start">5 {{ __('Star Ratings') }}</p>
                                                <div class="progress">
                                                    <div class="progress-bar bg-warning five-star" id="5_star_progress" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>
                                                <p class="fw-normal text-body text-end" id="5_star_count">0</p>
                                            </div>

                                            <!-- Progress 2 -->
                                            <div class="progress-lvl mb-2">
                                                <p class="fw-normal text-body">4 {{ __('Star Ratings') }}</p>
                                                <div class="progress">
                                                    <div class="progress-bar bg-warning" id="4_star_progress" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>
                                                <p class="fw-normal text-body text-end" id="4_star_count">0</p>
                                            </div>

                                            <!-- Progress 3 -->
                                            <div class="progress-lvl mb-2">
                                                <p class="fw-normal text-body text-start">3 {{ __('Star Ratings') }}</p>
                                                <div class="progress">
                                                    <div class="progress-bar bg-warning" id="3_star_progress" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>
                                                <p class="fw-normal text-body text-end" id="3_star_count">0</p>
                                            </div>

                                            <!-- Progress 4 -->
                                            <div class="progress-lvl mb-2">
                                                <p class="fw-normal text-body text-start">2 {{ __('Star Ratings') }}</p>
                                                <div class="progress">
                                                    <div class="progress-bar bg-warning" id="2_star_progress" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>
                                                <p class="fw-normal text-body text-end" id="2_star_count">0</p>
                                            </div>

                                            <!-- Progress 5 -->
                                            <div class="progress-lvl mb-0">
                                                <p class="fw-normal mb-0 text-body text-start">1 {{ __('Star Ratings') }}</p>
                                                <div class="progress">
                                                    <div class="progress-bar bg-warning" id="1_star_progress" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>
                                                <p class="fw-normal mb-0 text-body text-end" id="1_star_count">0</p>
                                            </div>
                                        </div> <!-- end card -->
                                    </div> <!-- end col -->
                                </div>
                            </div>
                            <!-- end row -->
                            <!-- start review item-two -->
                            <div id="review_list_main_container">
                                <div id="review_list_container" data-is_allow_reply="{{ isAllowReply($product->id, 'product', Auth::user()->id ?? '') }}">
                                </div>
                                <div class="d-flex align-items-center justify-content-center mt-3 border-top pt-3">
                                    <button type="button" class="btn btn-dark d-inline-flex align-items-center load-more-reviews-btn d-none"><i class="isax isax-rotate-left me-1"></i>{{ __('load_more') }}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    @if (Auth::check() && Auth::user()->user_type == 3)
                        @if (!reviewExists($product->id ?? '') )
                            <div class="card">
                                <div class="card-body">
                                    <form id="reviewForm" autocomplete="off">
                                        <h5 class="mb-3">{{ __('Write a Review') }}</h5>
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                    <label class="form-label">{{ __('your_ratings') }}</label>
                                                    <div class="rating star-box ratings_stars">
                                                        <i class="fas fa-star"></i>
                                                        <i class="fas fa-star"></i>
                                                        <i class="fas fa-star"></i>
                                                        <i class="fas fa-star"></i>
                                                        <i class="fas fa-star"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mb-3">
                                            <label for="review" class="form-label">{{ __('review') }}</label>
                                            <textarea class="form-control" rows="4" name="review" id="review"></textarea>
                                            <span class="text-danger error-text" id="review_error"></span>
                                        </div>
                                        <button type="submit" class="btn btn-dark submit-review">{{ __('submit') }}</button>
                                    </form>
                                </div>
                            </div>
                        @endif
                    @endif
                </div>
                <!-- 4th tab -->
                <div class="tab-pane" id="shipping">
                    <div class="card">
                        <div class="card-body shipping-info">
                            <div class="mb-4">
                                <h5 class="mb-2">{{ __('for_international_shipping') }}</h5>
                                <p class="mb-0 text-body" id="international_shipping">-</p>
                            </div>
                            <div class="mb-0">
                                <h5 class="mb-2">{{ __('for_domestic_shipping') }}</h5>
                                <p class="mb-0 text-body" id="domestic_shipping">-</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="mt-5 pt-4 border-top position-relative">
                <h5 class="mb-4">{{ __('related_products') }}</h5>
                <div class="product-slider" id="related_products_container">
                </div>
            </div>
        </div>
    </div>
    <!-- End Content -->
</div>

<!-- Reply Review Modal -->
<div id="reply_review_modal" class="modal fade">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form id="replyReviewForm" autocomplete="off">
                <div class="modal-header">
                    <h6 class="modal-title fw-bold">{{ __('add_reply') }}</h6>
                    <button type="button" class="btn-close btn-close-modal custom-btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="isax isax-close-circle"></i></button>
                </div>
                <div class="modal-body">
                    <div class="mb-0">
                        <input type="hidden" id="review_id" name="review_id">
                        <label class="form-label">{{ __('your_reply') }}<span class="text-danger ms-1">*</span></label>
                        <textarea class="form-control fs-14" name="reply_message" id="reply_message" rows="3"></textarea>
                        <span class="text-danger error-text" id="reply_message_error"></span>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="d-flex align-items-center justify-content-end">
                        <button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                        <button type="submit" class="btn btn-secondary send-reply">{{ __('submit') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- End Reply Review Modal -->

@endsection

@push('scripts')
<script src="{{ asset('frontend/assets/js/custom/productdetail.min.js') }}"></script>
@endpush
