@extends('frontend.theme_2.app')

@section('title', __('products') . ' || ' . $companyName)
@push('styles')
<!-- Rangeslider CSS -->
<link rel="stylesheet" href="assets/plugins/ion-rangeslider/css/ion.rangeSlider.min.css">
@endpush

@section('content')

    <!-- Start Breadscrumb -->
    @include('frontend.pages.banner')
    <!-- End Breadscrumb -->
    <div class="content">
        <div class="container">
        <input type="hidden" name="user_id"  value="{{ $authId }}" id="user_id">

            <!-- Start Sub Head -->
            <div class="sub-head-item border-bottom border-color d-flex align-items-center justify-content-between flex-wrap gap-2 pb-4 mb-4">
                <p class="sub-head mb-0" id="total_product"></p>
                <div class="filter-item d-flex align-items-center justify-content-between flex-wrap gap-3">
                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
                        <a href="javascript:void(0);" class="btn btn-icon active viewType " id="gridView" aria-label="Grid view" data-view="grid">
                            <i class="isax isax-grid-6" aria-hidden="true"></i>
                        </a>
                        <a href="javascript:void(0);" class="btn btn-icon border border-color viewType " id="listView" aria-label="List view" data-view="list">
                            <i class="isax isax-menu-14" aria-hidden="true"></i>
                        </a>
                    </div>
                    <div class="dropdown d-flex align-items-center gap-2">
                        <p class="fs-14 fw-medium mb-0">{{ __('sort_by') }} : </p>
                        <a href="javascript:void(0);" class="dropdown-toggle selected-value btn border border-color d-inline-flex align-items-center text-dark fw-normal" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('newest') }}
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end" id="sort_by">
                            <li>
                                <a href="javascript:void(0);" class="dropdown-item rounded-1" data-value="new">{{ __('newest') }}</a>
                            </li>
                            <li>
                                <a href="javascript:void(0);" class="dropdown-item rounded-1" data-value="old">{{ __('oldest') }}</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <!-- end Sub Head -->

            <!-- start row -->
            <div class="row row-gap-3">

                <!-- Filter -->
                @include('frontend.pages.products.filter')
                <!-- Filter -->
                <div class="col-lg-9">
                    <input type="hidden" name="language_id" value="{{$data['language_id']}}" id="language_id">
                    <!-- start row -->
                    <div class="d-flex align-items-center justify-content-between gap-2 mb-3 flex-wrap d-none">
                        <div class="d-flex align-items-center gap-2 flex-wrap categories-list-header">
                            <span class="badge badge-md badge-soft-dark d-flex align-items-center gap-2 text-dark">Growth Tech<i class="isax isax-close-circle"></i></span>
                            <span class="badge badge-md badge-soft-dark d-flex align-items-center gap-2 text-dark">Electronics & Gadgets<i class="isax isax-close-circle"></i></span>
                            <span class="badge badge-md badge-soft-dark d-flex align-items-center gap-2 text-dark">Large<i class="isax isax-close-circle"></i></span>
                            <span class="badge badge-md badge-soft-dark d-flex align-items-center gap-2 text-dark">Blue<i class="isax isax-close-circle"></i></span>
                        </div>
                        <a href="javascript:void(0);" class="btn btn-sm btn-dark">Clear All</a>
                    </div>
                    <div class="row row-gap-4">
                        @include('frontend.loader.content_loader')
                    </div>
                    <div class="listCardDiv">
                    </div>
                    <div class="text-center mt-5" id="load-more-container">
                        <a href="javascript:void(0);" class="btn btn-dark d-inline-flex align-items-center gap-2 d-none" id="load-more"><i class="isax isax-rotate-left"></i>{{ __('loadmore') }}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('plugins')
    <!-- Rangeslider JS -->
    <script src="assets/plugins/ion-rangeslider/js/ion.rangeSlider.min.js"></script>
@endpush
@push('scripts')
    <script src="{{ asset('frontend/assets/js/custom/products.min.js') }}"></script>
@endpush