<div class="col-lg-3">
    <div class="product-sidebar card mb-0">
        <div class="product-sidebar-item card-body">
            <h5 class="pb-3 mb-3 border-bottom d-flex align-items-center justify-content-between">
                {{ __('filter') }}
                <span class="text-danger fs-16 fw-normal show-cursor-pointer">{{ __('reset') }}</span>
            </h5>
            <div class="filter-items">
                <div class="filter-body">

                    <div class="filter-set mb-4 pb-4 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#highlights" aria-expanded="false" role="button">
                                <h6 class="mb-0 d-flex align-items-center">{{ __('highlights') }}</h6>
                                <i class="isax isax-arrow-down-1"></i>
                            </div>
                        </div>
                        @php
                            $maxLimit = 5;
                        @endphp
                        <div id="highlights" class="card-collapse collapse show mt-3">
                            @if(!empty($highlighted) && count($highlighted) > 0)
                                @foreach($highlighted as $highlighted_index => $highlight)
                                    {{-- First two items --}}
                                    @if($loop->iteration <= $maxLimit)
                                        <div class="form-check d-flex align-items-center ps-0 mb-2">
                                            <input class="form-check-input ms-0 mt-0 highlighted" id="highlight_{{ $highlighted_index }}"
                                                name="highlighted"
                                                type="checkbox"
                                                value="{{ $highlighted_index }}">
                                            <label for="highlight_{{ $highlighted_index }}" class="form-check-label w-100 d-flex align-items-center justify-content-between ms-2">
                                                {{ $highlight['title'] }} <span>({{ $highlight['count'] }})</span>
                                            </label>
                                        </div>
                                    @elseif($loop->iteration == $maxLimit + 1)
                                        {{-- Open "more" wrapper at 3rd item --}}
                                        <div class="more-menu-item1 mt-2">
                                            <div class="form-check d-flex align-items-center ps-0 mb-2">
                                                <input class="form-check-input ms-0 mt-0 highlighted" id="highlight_{{ $highlighted_index }}"
                                                    name="highlighted"
                                                    type="checkbox"
                                                    value="{{ $highlighted_index }}">
                                                <label for="highlight_{{ $highlighted_index }}" class="form-check-label w-100 d-flex align-items-center justify-content-between ms-2">
                                                    {{ $highlight['title'] }} <span>({{ $highlight['count'] }})</span>
                                                </label>
                                            </div>
                                    @else
                                        {{-- Remaining items stay inside "more" --}}
                                        <div class="form-check d-flex align-items-center ps-0 mb-2">
                                            <input class="form-check-input ms-0 mt-0 highlighted" id="highlight_{{ $highlighted_index }}"
                                                name="highlighted"
                                                type="checkbox"
                                                value="{{ $highlighted_index }}">
                                            <label for="highlight_{{ $highlighted_index }}" class="form-check-label w-100 d-flex align-items-center justify-content-between ms-2">
                                                {{ $highlight['title'] }} <span>({{ $highlight['count'] }})</span>
                                            </label>
                                        </div>
                                    @endif

                                    {{-- Close "more" wrapper on last iteration --}}
                                    @if($loop->last && $loop->iteration > $maxLimit)
                                        </div>
                                        <div class="view-all d-inline-flex align-items-center mt-2">
                                            <a href="javascript:void(0);" class="view-all-item1-button text-secondary">
                                                {{ __('show_more') }}
                                            </a>
                                        </div>
                                    @endif
                                @endforeach
                            @else
                                <p class="text-muted">{{ __('no_highlights_found') }}</p>
                            @endif
                        </div>
                    </div>

                    <div class="filter-set mb-4 pb-4 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#shops" aria-expanded="false" role="button">
                                <h6 class="mb-0 d-flex align-items-center">{{ __('shops') }}</h6>
                                <i class="isax isax-arrow-down-1"></i>
                            </div>
                        </div>
                        <div id="shops" class="card-collapse collapse show mt-3">
                            @if(!empty($shops) && count($shops) > 0)
                                @foreach($shops as $shop)

                                    @if ($loop->iteration <= $maxLimit)
                                        <div class="form-check d-flex align-items-center ps-0 mb-2">
                                            <input class="form-check-input ms-0 mt-0 shops" name="shops[]" type="checkbox" value="{{ $shop->id }}" id="shop_{{ $shop->id }}">
                                            <label class="form-check-label w-100 d-flex align-items-center justify-content-between ms-2" for="shop_{{ $shop->id }}">
                                                {{ $shop->shop_name }} <span>({{ $shop->products_count }})</span>
                                            </label>
                                        </div>
                                    @elseif($loop->iteration == $maxLimit + 1)
                                        <div class="more-menu-item2 mt-2">
                                            <div class="form-check d-flex align-items-center ps-0 mb-2">
                                                <input class="form-check-input ms-0 mt-0 shops" name="shops[]" type="checkbox" value="{{ $shop->id }}" id="shop_{{ $shop->id }}">
                                                <label class="form-check-label w-100 d-flex align-items-center justify-content-between ms-2" for="shop_{{ $shop->id }}">
                                                    {{ $shop->shop_name }} <span>({{ $shop->products_count }})</span>
                                                </label>
                                            </div>
                                    @else
                                        <div class="form-check d-flex align-items-center ps-0 mb-2">
                                            <input class="form-check-input ms-0 mt-0 shops" name="shops[]" type="checkbox" value="{{ $shop->id }}" id="shop_{{ $shop->id }}">
                                            <label class="form-check-label w-100 d-flex align-items-center justify-content-between ms-2" for="shop_{{ $shop->id }}">
                                                {{ $shop->shop_name }} <span>({{ $shop->products_count }})</span>
                                            </label>
                                        </div>
                                    @endif

                                    @if($loop->last && $loop->iteration > $maxLimit)
                                        </div>
                                        <div class="view-all d-inline-flex align-items-center mt-2">
                                            <a href="javascript:void(0);" class="view-all-item2-button text-secondary">
                                                {{ __('show_more') }}
                                            </a>
                                        </div>
                                    @endif
                                @endforeach
                            @else
                                <p class="text-muted">{{ __('no_shops_found') }}</p>
                            @endif
                        </div>
                    </div>

                    <div class="filter-set mb-4 pb-4 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#style" aria-expanded="false" role="button">
                                <h6 class="mb-0 d-flex align-items-center">{{ __('categories') }}</h6>
                                <i class="isax isax-arrow-down-1"></i>
                            </div>
                        </div>
                        <div id="style" class="card-collapse collapse show mt-3">
                            <div>
                                @if(!empty($categories) && count($categories) > 0)
                                    @foreach($categories as $index => $category)
                                        @if ($loop->iteration <= $maxLimit)
                                            <div class="form-check d-flex align-items-center ps-0 mb-2">
                                                <input class="form-check-input ms-0 mt-0 category" name="category" id="category_{{ $category->id ?? ''}}" type="checkbox" value="{{ $category->id ?? ''}}" data-slug="{{ $category->slug ?? '' }}">
                                                <label for="category_{{ $category->id ?? ''}}" class="form-check-label ms-2 d-flex align-items-center justify-content-between w-100">
                                                    {{ $category->name ?? ""}} <span>({{ $category->products_count ?? 0}})</span>
                                                </label>
                                            </div>
                                        @elseif($loop->iteration == $maxLimit + 1)
                                            <div class="more-menu-item3 mt-2">
                                                <div class="form-check d-flex align-items-center ps-0 mb-2">
                                                    <input class="form-check-input ms-0 mt-0 category" name="category" id="category_{{ $category->id ?? ''}}" type="checkbox" value="{{ $category->id ?? ''}}">
                                                    <label for="category_{{ $category->id ?? ''}}" class="form-check-label ms-2 d-flex align-items-center justify-content-between w-100">
                                                        {{ $category->name ?? ""}} <span>({{ $category->products_count ?? 0}})</span>
                                                    </label>
                                                </div>
                                        @else
                                            <div class="form-check d-flex align-items-center ps-0 mb-2">
                                                <input class="form-check-input ms-0 mt-0 category" name="category" id="category_{{ $category->id ?? ''}}" type="checkbox" value="{{ $category->id ?? ''}}">
                                                <label for="category_{{ $category->id ?? ''}}" class="form-check-label ms-2 d-flex align-items-center justify-content-between w-100">
                                                    {{ $category->name ?? ""}} <span>({{ $category->products_count ?? 0}})</span>
                                                </label>
                                            </div>
                                        @endif

                                        @if($loop->last && $loop->iteration > $maxLimit)
                                            </div>
                                            <div class="view-all d-inline-flex align-items-center mt-2">
                                                <a href="javascript:void(0);" class="view-all-item3-button text-secondary">
                                                    {{ __('show_more') }}
                                                </a>
                                            </div>
                                        @endif
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="filter-set mb-4 pb-4 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#color" aria-expanded="false" role="button">
                                <h6 class="mb-0 d-flex align-items-center">{{ __('color') }}</h6>
                                <i class="isax isax-arrow-down-1"></i>
                            </div>
                        </div>
                        <div id="color" class="card-collapse collapse show mt-3">
                            <div class="color-picker flex-wrap">
                                @if(!empty($colors) && count($colors) > 0)
                                    @foreach($colors as $color_code)
                                    <label>
                                        <input type="radio" name="color" value="{{ $color_code }}">
                                        <span class="color" style="background-color: {{ $color_code }};"></span>
                                    </label>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="filter-set mb-4 pb-4 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#price-list" aria-expanded="false" role="button">
                                <h6 class="mb-0 d-flex align-items-center">{{ __('price') }}</h6>
                                <i class="isax isax-arrow-down-1"></i>
                            </div>
                        </div>
                        <div id="price-list" class="card-collapse collapse show mt-3">
                            <div>
                                <div id="price" class="card-collapse collapse show mt-4">
                                    <div>
                                        <div class="filter-range">
                                            <input type="text" id="product_range_price" aria-label="Price Range" class="price_range" data-max_price="{{ $maxPrice ?? 10000 }}">
                                            <p class="mb-0 text-body fs-14">{{ __('price') }} : <span class="text-dark price_range_value">{{$data['currency_code']}}0 - {{$data['currency_code']}}{{ $maxPrice ?? 10000 }}</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="filter-set mb-4 pb-4 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#reviews" aria-expanded="false" role="button">
                                <h6 class="mb-0 d-flex align-items-center">{{ __('Reviews') }}</h6>
                                <i class="isax isax-arrow-down-1"></i>
                            </div>
                        </div>
                        <div id="reviews" class="card-collapse collapse show mt-3">
                            <div>
                                @for ($i = 5; $i >= 1; $i--)
                                    <div class="form-check d-flex align-items-center ps-0 mb-2">
                                        <input class="form-check-input ms-0 mt-0 reviews" name="reviews" type="checkbox" id="check_{{ 45 + $i }}" value="{{ $i }}">
                                        <label class="form-check-label ms-2 d-flex align-items-center flex-xl-nowrap flex-wrap gap-2" for="check_{{ 45 + $i }}">
                                            <span class="review-star mb-0 d-flex align-items-center gap-1">
                                                @for ($j = 1; $j <= 5; $j++)
                                                    @if ($j <= $i)
                                                        <i class="fa-solid fa-star text-warning"></i>
                                                    @else
                                                        <i class="fa-regular fa-star text-warning"></i>
                                                    @endif
                                                @endfor
                                            </span>
                                            <span class="ms-2 mb-0"> {{ $i }} {{ __('star') }} </span>
                                        </label>
                                    </div>
                                @endfor
                            </div>
                        </div>
                    </div>
                </div>
                <div class="filter-footer d-flex flex-xl-nowrap flex-wrap align-items-center justify-content-between gap-2">
                    <a href="javascript:void(0);" class="btn btn-light w-100 reset-filter">{{ __('reset') }}</a>
                    <a href="javascript:void(0);" class="btn btn-secondary w-100" id="filterbtn">{{ __('apply') }} </a>
                </div>
            </div>
        </div>
    </div>
</div>