@extends('frontend.theme_2.app')

@section('title', 'Customer Dashboard')

@push('styles')

<link rel="stylesheet" href=" {{ asset('frontend/assets/plugins/daterangepicker/daterangepicker.css') }}">
<link rel="stylesheet" href=" {{ asset('frontend/assets/plugins/datatables/datatables.min.css') }}">
@endpush

@section('content')

	<div class="page-wrapper">

            <!-- Start Breadscrumb -->
            @include('frontend.pages.banner')
            <!-- End Breadscrumb -->

            <div class="content">
                <div class="container">

					<!-- start row -->
					<div class="row">

						@include('frontend.pages.customer.sidemenu')

						<div class="col-xl-9 col-lg-8">
							<div>
								<h4 class="mb-0">{{__('wishlist')}} </h4>
							</div>
							<hr>
							<div class="d-flex justify-content-between mb-4">
								<ul class="nav nav-tabs nav-solid-primary mb-3 wishlist-tab">
									<li class="nav-item"><a class="nav-link active" href="#solid-tab2" data-bs-toggle="tab">{{__('products')}}</a></li>
									<li class="nav-item"><a class="nav-link" href="#solid-tab3" data-bs-toggle="tab">{{__('Services')}}</a></li>
								</ul>
								<div>
									<a href="javascript:void(0);" class="btn btn-danger d-inline-flex align-items-center remove-all d-none" data-bs-toggle="modal" data-bs-target="#remove_all"><i class="isax isax-trash me-1"></i>{{__('remove_all')}}</a>
								</div>
							</div>
							<div class="spinner-loader d-none"></div>
							<div class="tab-content">
								<input type="hidden" value="" id="all_ids" name="all_ids">
								<div class="tab-pane show active" id="solid-tab2">
							        <h5 class="row row-gap-4 text-center py-5" id="wishlist-content-products">
							            <!-- Products loaded via AJAX -->
									</h5>
							        <div class="text-center mt-5">
							            <button class="btn btn-dark load-more d-none" data-type="products" data-page="1" id="products-load-more">
							                <i class="isax isax-rotate-left"></i> {{__('load_more')}}
							            </button>
							        </div>
							    </div>

							    <div class="tab-pane" id="solid-tab3">
							        <h5 class="row row-gap-4 text-center py-5" id="wishlist-content-services"></h5>
							        <div class="text-center mt-5">
							            <button class="btn btn-dark load-more d-none" data-type="services" data-page="1" id="services-load-more">
							                <i class="isax isax-rotate-left"></i> {{__('load_more')}}
							            </button>
							        </div>
							    </div>
							</div>

						</div>

					</div>
					<!-- end row -->
					<!-- Start Remove All Branch -->
					<div id="remove_all" class="modal fade">
						<div class="modal-dialog modal-dialog-centered modal-sm">
							<div class="modal-content">
								<form action="javascript:void(0);">
									<div class="modal-body">
										<div class="d-flex align-items-center justify-content-center">
											<span class="delete-icon rounded-circle mb-3"><i class="isax isax-trash fs-16"></i></span>
										</div>
										<div class="text-center">
											<h6 class="mb-1">{{__('are_you_sure')}}</h6>
											<p class="mb-3">{{__('confirm_message')}}</p>
										</div>
										<div class="d-flex align-items-center justify-content-center">
											<button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">{{__('cancel')}}</button>
											<button type="submit" class="btn btn-danger" id="clearWishlist">{{__('remove')}}</button>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
					<!-- End Delete Branch -->

                </div>
            </div>

        </div>

@endsection
@push('scripts')
	<script type="text/javascript" src="{{ asset('frontend/assets/js/custom/wishlist.js') }}"></script>
@endpush