@if($data['type'] == 'shops')
    @foreach($wishlists as $shop)
        @php
            $image = $shop->shop?->shop_logo ? asset('storage/' . $shop->shop?->shop_logo) : asset('img/default-image.png');
            $rating = round($shop->avg_rating, 1);
            $reviewsCount = $shop->reviews_count ?? 0;

            $fullStars = floor($rating);
            $halfStar = ($rating - $fullStars) >= 0.5 ? 1 : 0;
            $emptyStars = 5 - ($fullStars + $halfStar);
        @endphp
        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-12 d-flex">
            <div class="card position-relative mb-0 flex-fill">
                <div class="wishlist-favourite d-flex flex-column align-items-center justify-content-center gap-2">
                    <a href="javascript:void(0);" class="btn btn1 btn-icon btn-white favourite" id="remove-wishlist" data-product-id="{{$shop->shop->id ?? ''}}" data-type="shops"><i class="isax isax-heart5 text-danger"></i></a>
                </div>
                <div class="card-body text-center">
                    <div class="text-center position-relative z-1">
                        <div class="avatar avatar-xxxl mb-4">
                            <img src="{{ $image }}" class="img-fluid w-100 rounded-circle" alt="shop">
                        </div>
                    </div>
                    <div class="d-flex align-items-center justify-content-center fs-14 mb-3">
                        @for ($i = 0; $i < $fullStars; $i++)
                            <i class="fa-solid fa-star text-warning"></i>
                        @endfor
                        @if ($halfStar)
                            <i class="fa-solid fa-star-half-stroke text-warning"></i>
                        @endif
                        @for ($i = 0; $i < $emptyStars; $i++)
                            <i class="fa-regular fa-star text-warning"></i>
                        @endfor
                    </div>
                    <p class="fs-14 text-body mb-0">{{ $shop->avg_rating }}</p>

                    <h5 class="d-flex align-items-center justify-content-center gap-2 mb-2 text-center"> <a href="{{ route('frontend.shops.show', $shop->shop->slug) }}">{{ $shop->shop->shop_name ?? '' }}<i class="isax isax-tick-circle5 text-success fs-16 me-1"></i></a></h5>
                    <p class="d-flex align-items-center justify-content-center gap-2 fs-14 text-body pb-3 mb-3 border-bottom text-center"><i class="isax isax-location text-dark"></i> {{ $shop->shop->cityRelation->name ?? '' }}, {{ $shop->shop->countryRelation->name ?? '' }}</p>
                    <div class="d-flex justify-content-center gap-5">
                        <h6 class="mb-0 d-flex justify-content-center flex-column gap-2">{{ $shop->shop->services_list ? $shop->shop->products_list->count() : 0 }}<span class="fw-normal text-body fs-14">{{__('Services')}}</span> </h6>
                        <h6 class="mb-0 d-flex justify-content-center flex-column gap-2">{{ $shop->shop->products_list ? $shop->shop->products_list->count() : 0 }}<span class="fw-normal text-body fs-14">{{__('products')}}</span> </h6>
                    </div>
                    <img src="{{ $image }}" alt="" class="img-fluid w-100 position-absolute top-0 start-0">
                </div>
            </div>
        </div>
    @endforeach
@elseif($data['type'] == 'products')
    @foreach($wishlists as $product)
        @php
            $image = isset($product->product->meta) && $product->product->meta[0] && $product->product->meta[0]->source_Values ? asset('storage/' . $product->product->meta[0]->source_Values) : asset('img/default-image.png');

            $profile_image = $product->user_profile_image ? url('storage/profile/' . $product->user_profile_image) : asset('img/default-image.png');

            $rating = round($product->avg_rating, 1);
            $reviewsCount = $product->reviews_count ?? 0;

            $fullStars = floor($rating);
            $halfStar = ($rating - $fullStars) >= 0.5 ? 1 : 0;
            $emptyStars = 5 - ($fullStars + $halfStar);
        @endphp
        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-12 d-flex">
            <div class="product-item mb-0 flex-fill">
                <div class="product-img position-relative">
                    <a href="{{ route('productdetail', $product->product->slug) }}">
                        <img src="{{ $image }}" class="img-fluid w-100" alt="product">
                    </a>
                    @if($product->popular && $product->popular == 1)
                        <div class="product-status" >
                            <span class="badge bg-danger badge-sm rounded d-flex align-items-center justify-content-center gap-1 position-absolute top-0 left-0"><i class="isax isax-flash-1"></i> {{__('trending')}} </span>
                        </div>
                    @elseif($product->featured && $product->featured == 1)
                        <div class="product-status">
                            <span class="badge bg-purple badge-sm rounded d-flex align-items-center justify-content-center gap-1 position-absolute top-0 left-0"> <i class="isax isax-status-up"></i> {{__('best_seller')}}</span>
                        </div>
                    @endif
                    <div class="avatar user-avatar position-absolute bottom-0 left-0">
                        <img src="{{ $profile_image }}" alt="br and-img-01" class="rounded-circle">
                    </div>
                    <div class="wishlist-favourite d-flex flex-column align-items-center justify-content-center gap-2" data-product-id="{{$product->product->id ?? ''}}" data-type="products">
                        <a href="javascript:void(0);" class="btn btn1 btn-icon btn-white favourite" data-type="products" data-product-id="{{$product->product->id ?? ''}}" id="remove-wishlist-product"><i class="isax isax-heart5 text-danger"></i></a>
                    </div>
                </div>
                <div class="product-content">
                    <div class="product-info mb-3">
                        <div class="d-flex align-items-center flex-wrap gap-2 mb-2">
                            <div class="d-flex align-items-center  fs-14">
                                @for ($i = 0; $i < $fullStars; $i++)
                                    <i class="fa-solid fa-star text-warning"></i>
                                @endfor
                                @if ($halfStar)
                                    <i class="fa-solid fa-star-half-stroke text-warning"></i>
                                @endif
                                @for ($i = 0; $i < $emptyStars; $i++)
                                    <i class="fa-regular fa-star text-warning"></i>
                                @endfor
                            </div>
                            <p class="fs-14 text-body mb-0">{{ $product->avg_rating }} ({{ $product->reviews_count ?? 0}} {{__('reviews')}})</p>
                        </div>
                        <h6 class="mb-0 text-start"><a href="{{ route('productdetail', $product->product->slug) }}">{{ $product->product->source_name ?? '' }} </a></h6>
                    </div>
                    <div class="product-action d-flex align-items-center justify-content-between gap-2 flex-wrap">
                        <h6 class="mb-0">{{ getDefaultCurrencySymbol() }}{{ $product->product->source_price ?? '' }}</h6>
                        <div class="d-flex align-items-center justify-content-between gap-2 flex-wrap">
                            <a href="/productdetail/{{ $product->product->slug }}" class="btn btn-icon btn-dark"><i class="isax isax-shopping-cart"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
@elseif($data['type'] == 'services')
    @foreach($wishlists as $service)
        @php
            $image = $service->service?->imageMeta?->source_Values
                ? asset('storage/' . $service->service->imageMeta->source_Values)
                : asset('img/default-image.png');

            $shop = $service->service?->shop;

            $shop_image = $shop?->shop_logo
                ? url('storage/' . $shop->shop_logo)
                : asset('img/default-image.png');

            $rating = round($service->avg_rating, 1);
            $reviewsCount = $service->reviews_count ?? 0;

            $fullStars = floor($rating);
            $halfStar = ($rating - $fullStars) >= 0.5 ? 1 : 0;
            $emptyStars = 5 - ($fullStars + $halfStar);
        @endphp

        <div class="col-xl-12 col-lg-12 col-md-12 d-flex">
            <div class="service-item flex-fill d-flex flex-wrap flex-md-nowrap flex-md-row overflow-hidden">
                <div class="service-img service-img-list position-relative overflow-hidden">
                    <a href="{{ route('servicedetail', $service->service?->slug ?? '') }}">
                        <img class="img-fluid" src="{{ $image }}" alt="service">
                    </a>
                    <div class="badge-item w-100 d-flex align-items-center justify-content-end position-absolute top-0 start-0">
                        <span class="badge bg-secondary">
                            {{ $service->service?->categories?->name ?? ''}}
                        </span>
                    </div>
                    @if($service->popular == 1)
                        <span class="feature-icon bg-danger"><i class="isax isax-flash-1"></i></span>
                    @elseif($service->featured == 1)
                        <span class="feature-icon bg-purple"><i class="isax isax-status-up"></i></span>
                    @endif

                    <a href="javascript:void(0)" class="favourite"
                       data-product-id="{{ $service->service?->id ?? '' }}"
                       data-type="services" id="remove-wishlist">
                        <i class="isax isax-heart5 text-danger"></i>
                    </a>
                </div>

                <div class="service-content w-100">
                    <p class="text-body mb-2 fs-16 fw-normal d-flex align-items-center gap-1">
                        <i class="isax isax-location"></i>
                        {{ $shop?->cityRelation?->name ?? '' }}, {{ $shop?->countryRelation?->code ?? '' }}
                    </p>
                    <h6 class="title mb-2 text-start wishlist-service-title">
                        <a href="{{ route('servicedetail', $service->service?->slug ?? '') }}">
                            {{ $service->service?->source_name ?? '' }}
                        </a>
                    </h6>

                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-1 mt-3">
                        <div class="d-flex align-items-center">
                            @if($shop)
                                <a href="{{ route('frontend.shops.show', $shop->slug) }}" class="avatar me-2">
                                    <img src="{{ $shop_image }}" alt="shop" class="rounded-circle border">
                                </a>
                                <div>
                                    <h5 class="fs-16 fw-semibold mb-1">
                                        <a href="{{ route('frontend.shops.show', $shop->slug) }}">
                                            {{ $shop->shop_name ?? ''}}
                                        </a>
                                    </h5>
                                    <div class="d-flex align-items-center fs-14">
                                        @for ($i = 0; $i < $fullStars; $i++)
                                            <i class="fa-solid fa-star text-warning"></i>
                                        @endfor
                                        @if ($halfStar)
                                            <i class="fa-solid fa-star-half-stroke text-warning"></i>
                                        @endif
                                        @for ($i = 0; $i < $emptyStars; $i++)
                                            <i class="fa-regular fa-star text-warning"></i>
                                        @endfor

                                        <span class="ms-2">{{ $rating }} ({{ $reviewsCount }} {{__('reviews')}})</span>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div>
                            <p class="mb-1 fs-14">{{__('start_from')}}</p>
                            <h6 class="mb-0 text-end">
                                {{ getDefaultCurrencySymbol() }}{{ $service->service?->source_price ?? '' }}
                            </h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
@endif
