@extends('frontend.theme_2.app')

@section('title', __('support_tickets') . ' || ' . $companyName)

@push('styles')
{{-- Add any specific styles if needed --}}
<style>
    .ticket-history {
        max-height: 300px;
        overflow-y: auto;
        padding: 15px;
        background-color: #f8f9fa;
        border-radius: 5px;
    }

    .history-item {
        margin-bottom: 15px;
        padding-bottom: 10px;
        border-bottom: 1px solid #e9ecef;
    }

    .history-item:last-child {
        border-bottom: none;
        margin-bottom: 0;
    }

    .history-item .meta {
        font-size: 0.8rem;
        color: #6c757d;
    }

    .history-item.user-reply {
        text-align: right;
    }

    .history-item.user-reply .message-body {
        background-color: #e0f0ff;
        display: inline-block;
        padding: 8px 12px;
        border-radius: 10px;
        text-align: left;
    }

    .history-item.admin-reply .message-body {
        background-color: #f1f1f1;
        display: inline-block;
        padding: 8px 12px;
        border-radius: 10px;
    }
</style>
@endpush

@section('content')

<div class="breadcrumb-bar">
    <div class="container">
        <div class="breadcrumb-item">
            <nav aria-label="breadcrumb" class="page-breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-items"><a href="{{ url('/') }}">{{__('home')}}</a></li>
                    <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                    <li class="breadcrumb-items active" aria-current="page">{{__('support_tickets')}}</li>
                </ol>
            </nav>
            <h1 class="breadcrumb-title">{{__('support_tickets')}}</h1>
        </div>
    </div>
    {{-- Decorative images --}}
</div>
<div class="content">
    <div class="container">
        <div class="row">
            @include('frontend.pages.customer.sidemenu')

            <div class="col-xl-9 col-lg-8">
                <div class="d-flex align-items-center justify-content-between mb-4">
                    <h4 class="mb-0">{{__('support_tickets')}}</h4>
                    <a href="javascript:void(0);" class="btn btn-md btn-secondary d-inline-flex align-items-center"
                        data-bs-toggle="modal" data-bs-target="#add_ticket"><i class="isax isax-add-circle me-1"></i>{{__('add_ticket')}}</a>
                </div>
                <hr>

                <div id="ticket-list">
                </div>
                <div class="spinner-loader d-none"></div>
            </div>
        </div>
    </div>
</div>
<div id="add_ticket" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{__('add_new_ticket')}}</h5>
                <button type="button" class="btn-close btn-close-modal custom-btn-close" data-bs-dismiss="modal"
                    aria-label="Close"><i class="isax isax-close-circle"></i></button>
            </div>
            <form id="add_ticket_form">
                @csrf
                <div class="modal-body p-4">
                    <div class="row row-gap-3">
                        <div class="col-md-12">
                            <label class="form-label">{{__('Subject')}}<span class="text-danger ms-1">*</span></label>
                            <input type="text" name="subject" class="form-control" required>
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">{{__('Priority')}}<span class="text-danger ms-1">*</span></label>
                            <select class="form-select" name="priority" required>
                                <option value="">{{__('Select')}}</option>
                                <option value="High">{{__('High')}}</option>
                                <option value="Medium">{{__('Medium')}}</option>
                                <option value="Low">{{__('Low')}}</option>
                            </select>
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">{{__('Description')}}<span class="text-danger ms-1">*</span></label>
                            <textarea class="form-control" name="description" rows="4" required></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer d-flex align-items-center justify-content-end gap-1">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                    <button type="submit" class="btn btn-secondary">{{__('add_ticket')}}</button>
                </div>
            </form>
        </div>
    </div>
</div>
<div id="edit_ticket" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{__('edit_ticket')}}</h5>
                <button type="button" class="btn-close btn-close-modal custom-btn-close" data-bs-dismiss="modal"
                    aria-label="Close"><i class="isax isax-close-circle"></i></button>
            </div>
            <form id="edit_ticket_form">
                @csrf
                @method('PUT')
                <input type="hidden" id="edit_ticket_id" name="ticket_id">
                <div class="modal-body p-4">
                    <div class="row row-gap-3">
                        <div class="col-md-12">
                            <label class="form-label">{{__('Subject')}}<span class="text-danger ms-1">*</span></label>
                            <input type="text" id="edit_subject" name="subject" class="form-control" required>
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">{{__('Priority')}}<span class="text-danger ms-1">*</span></label>
                            <select class="form-select" id="edit_priority" name="priority" required>
                                <option value="High">{{__('High')}}</option>
                                <option value="Medium">{{__('Medium')}}</option>
                                <option value="Low">{{__('Low')}}</option>
                            </select>
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">{{__('Description')}}<span class="text-danger ms-1">*</span></label>
                            <textarea class="form-control" id="edit_description" name="description" rows="4" required></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer d-flex align-items-center justify-content-end gap-1">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                    <button type="submit" class="btn btn-secondary">{{__('Save Changes')}}</button>
                </div>
            </form>
        </div>
    </div>
</div>
<div id="view_ticket" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <div class="d-flex align-items-center">
                    <h5 class="modal-title me-2" id="view_ticket_subject">{{__('Ticket Details')}}</h5>
                    <span class="badge badge-sm" id="view_ticket_status"></span>
                </div>
                <button type="button" class="btn-close btn-close-modal custom-btn-close" data-bs-dismiss="modal"
                    aria-label="Close"><i class="isax isax-close-circle"></i></button>
            </div>
            <div class="modal-body p-4">
                <h6>{{__('initial_description')}}:</h6>
                <p id="view_initial_description"></p>
                <hr>
                <h6>{{__('conversation_history')}}</h6>
                <div class="ticket-history" id="ticket_history_container">
                </div>
                <hr>
                <h6>{{__('add_a_reply')}}</h6>
                <form id="reply_form">
                    @csrf
                    <input type="hidden" name="ticket_id" id="reply_ticket_id">
                    <div class="form-group">
                        <textarea name="reply_description" class="form-control" rows="3" placeholder="Type your reply here..." required></textarea>
                    </div>
                    <div class="text-end mt-2">
                        <button type="submit" class="btn btn-secondary">{{__('send_reply')}}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="delete_ticket_modal">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-body text-center position-relative z-1 p-4">
                <form id="delete_ticket_form">
                    @csrf
                    @method('DELETE')
                    <input type="hidden" id="delete_ticket_id" name="ticket_id">
                    <div class="d-flex align-items-center justify-content-center">
                        <span class="delete-icon rounded-circle mb-3"><i class="isax isax-trash fs-16"></i></span>
                    </div>
                    <div class="text-center">
                        <h6 class="mb-1">{{__('are_you_sure')}}</h6>
                        <p class="mb-3">{{__('ticker_delete_confirmation')}}</p>
                    </div>
                    <div class="d-flex align-items-center justify-content-center">
                        <button type="button" class="btn btn-dark me-2" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                        <button type="submit" class="btn btn-danger">{{__('Delete')}}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('assets/plugins/sweetalert/sweetalert2.all.min.js') }}"></script>
<script>
    $(document).ready(function() {
        // Setup CSRF token for all AJAX requests
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // 1. Load Tickets on Page Load
        loadTickets();

        function loadTickets() {
            $(".spinner-loader").removeClass('d-none');
            $.ajax({
                url: "{{ route('customer.ticket.list') }}",
                type: 'GET',
                success: function(response) {
                    $(".spinner-loader").addClass('d-none');
                    function getStatusBadge(status) {
                        switch (parseInt(status)) {
                            case 1:
                                return '<span class="badge bg-primary">Open</span>';
                            case 2:
                                return '<span class="badge bg-warning text-dark">Assigned</span>';
                            case 3:
                                return '<span class="badge bg-info text-dark">In Progress</span>';
                            case 4:
                                return '<span class="badge bg-success">Closed</span>';
                            default:
                                return '<span class="badge bg-secondary">Unknown</span>';
                        }
                    }
                    let html = '';
                    if (response.length === 0) {
                        html = '<h5 class="text-center py-5">You have not created any support tickets yet.</h5>';
                    } else {
                        response.forEach(function(ticket) {
                            let ticketSubject = ticket.subject.split(' ').slice(0, 5).join(' ');
                            if(ticket.subject.split(' ').length > 5){
                                ticketSubject += '...';
                            }
                            html += `
                            <div class="card mb-4">
                                <div class="card-body">
                                    <div class="customer-tickets">
                                        <div>
                                            <p class="fs-14 mb-1">Subject (#${ticket.ticket_id})</p>
                                            <h6 class="fw-medium mb-0 text-truncate fs-16">${ticketSubject}</h6>
                                        </div>
                                        <div>
                                            <p class="fs-14 mb-1">Priority</p>
                                            ${getPriorityBadge(ticket.priority)}
                                        </div>
                                        <div>
                                            <p class="fs-14 mb-1">Status</p>
                                            ${getStatusBadge(ticket.status)}
                                        </div>
                                        <div class="d-flex flex-wrap gap-2 text-lg-end">
                                            <button class="btn btn-sm btn-white border me-2 view-btn"
                                                data-id="${ticket.id}"><i class="isax isax-eye me-1"></i>Details</button>
                                            <button class="btn btn-sm btn-white border d-inline-flex align-items-center me-2 edit-btn"
                                                data-id="${ticket.id}"
                                                data-subject="${ticket.subject}"
                                                data-priority="${ticket.priority}"
                                                data-description="${ticket.description}"><i class="isax isax-edit me-1"></i>Edit</button>
                                            <button class="btn btn-sm btn-white border delete-btn"
                                                data-id="${ticket.id}"><i class="isax isax-trash me-1"></i>Delete</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            `;
                        });
                    }
                    $('#ticket-list').html(html);
                }
            });
        }

        // Helper functions for badges
        function getPriorityBadge(priority) {
            if (priority === 'High') return `<span class="badge badge-sm badge-soft-danger">${priority}</span>`;
            if (priority === 'Medium') return `<span class="badge badge-sm badge-soft-warning">${priority}</span>`;
            return `<span class="badge badge-sm badge-soft-info">${priority}</span>`;
        }

        function getStatusBadge(status) {
            if (status === 'Closed') return `<span class="badge badge-sm badge-soft-success">${status}</span>`;
            if (status === 'Open') return `<span class="badge badge-sm badge-soft-purple">${status}</span>`;
            return `<span class="badge badge-sm badge-soft-secondary">${status}</span>`;
        }

        // 2. Add Ticket
        $('#add_ticket_form').on('submit', function(e) {
            e.preventDefault();
            let formData = $(this).serialize();

            $.ajax({
                url: "{{ route('customer.ticket.store') }}",
                type: 'POST',
                data: formData,
                success: function(response) {
                    $('#add_ticket').modal('hide');
                    $('#add_ticket_form')[0].reset();
                    Swal.fire('Success!', response.success, 'success');
                    loadTickets();
                },
                error: function(response) {
                    // Handle validation errors
                    Swal.fire('Error!', 'Please check your input.', 'error');
                }
            });
        });

        // 3. Edit Ticket - Show Modal
        $(document).on('click', '.edit-btn', function() {
            let ticketId = $(this).data('id');
            let subject = $(this).data('subject');
            let priority = $(this).data('priority');
            let description = $(this).data('description');

            $('#edit_ticket_id').val(ticketId);
            $('#edit_subject').val(subject);
            $('#edit_priority').val(priority);
            $('#edit_description').val(description);

            $('#edit_ticket').modal('show');
        });

        // 4. Update Ticket - Handle Form Submission
        $('#edit_ticket_form').on('submit', function(e) {
            e.preventDefault();
            let ticketId = $('#edit_ticket_id').val();
            let formData = $(this).serialize();

            $.ajax({
                url: `/customer/ticket/update/${ticketId}`,
                type: 'PUT',
                data: formData,
                success: function(response) {
                    $('#edit_ticket').modal('hide');
                    Swal.fire('Success!', response.success, 'success');
                    loadTickets();
                },
                error: function(response) {
                    Swal.fire('Error!', 'Could not update ticket.', 'error');
                }
            });
        });

        // 5. Delete Ticket - Show Modal
        $(document).on('click', '.delete-btn', function() {
            let ticketId = $(this).data('id');
            $('#delete_ticket_id').val(ticketId);
            $('#delete_ticket_modal').modal('show');
        });

        // 6. Delete Ticket - Handle Form Submission
        $('#delete_ticket_form').on('submit', function(e) {
            e.preventDefault();
            let ticketId = $('#delete_ticket_id').val();

            $.ajax({
                url: `/customer/ticket/destroy/${ticketId}`,
                type: 'DELETE',
                success: function(response) {
                    $('#delete_ticket_modal').modal('hide');
                    Swal.fire('Deleted!', response.success, 'success');
                    loadTickets();
                },
                error: function(response) {
                    Swal.fire('Error!', 'Could not delete ticket.', 'error');
                }
            });
        });

        // 7. View Ticket Details
        $(document).on('click', '.view-btn', function() {
            let ticketId = $(this).data('id');
            showTicketDetails(ticketId);
        });

        function getStatusText(status) {
            switch (parseInt(status)) {
                case 1:
                    return 'Open';
                case 2:
                    return 'Assigned';
                case 3:
                    return 'In Progress';
                case 4:
                    return 'Closed';
                default:
                    return 'Unknown';
            }
        }

        function getStatusBadgeClass(status) {
            switch (parseInt(status)) {
                case 1:
                    return 'badge-soft-primary'; // Open
                case 2:
                    return 'badge-soft-warning'; // Assigned
                case 3:
                    return 'badge-soft-info'; // In Progress
                case 4:
                    return 'badge-soft-success'; // Closed
                default:
                    return 'badge-soft-secondary'; // Unknown
            }
        }

        function showTicketDetails(ticketId) {
            $.ajax({
                url: `/customer/ticket/show/${ticketId}`,
                type: 'GET',
                success: function(ticket) {
                    $('#view_ticket_subject').text(`Ticket #${ticket.ticket_id}: ${ticket.subject}`);
                    $('#view_ticket_status')
                        .text(getStatusText(ticket.status)) // ✅ status text only
                        .removeClass() // remove old classes
                        .addClass('badge badge-sm ' + getStatusBadgeClass(ticket.status));
                    $('#view_initial_description').text(ticket.description);
                    $('#reply_ticket_id').val(ticket.id);

                    let historyHtml = '';
                    if (ticket.history.length > 0) {
                        ticket.history.forEach(function(item) {
                            const messageDate = new Date(item.created_at).toLocaleString();
                            const replier = item.user_type === 'user' ? 'You' : (item.user ? item.user.name : 'Admin');
                            const itemClass = item.user_type === 'user' ? 'user-reply' : 'admin-reply';

                            historyHtml += `
                            <div class="history-item ${itemClass}">
                                <div class="meta">
                                    <strong>${replier}</strong> replied on ${messageDate}
                                </div>
                                <div class="message-body">
                                    <p class="mb-0">${item.description.replace(/\n/g, '<br>')}</p>
                                </div>
                            </div>
                            `;
                        });
                    } else {
                        historyHtml = '<p>No conversation history yet.</p>';
                    }
                    $('#ticket_history_container').html(historyHtml);
                    // Scroll to bottom of history
                    $('#ticket_history_container').scrollTop($('#ticket_history_container')[0].scrollHeight);

                    $('#view_ticket').modal('show');
                }
            });
        }

        // 8. Handle Reply Submission
        $('#reply_form').on('submit', function(e) {
            e.preventDefault();
            let formData = $(this).serialize();
            let ticketId = $('#reply_ticket_id').val();

            $.ajax({
                url: "{{ route('customer.ticket.reply') }}",
                type: 'POST',
                data: formData,
                success: function(response) {
                    $('#reply_form')[0].reset();
                    Swal.fire('Success!', response.success, 'success');
                    // Refresh the history in the modal
                    showTicketDetails(ticketId);
                    // Refresh the main ticket list status
                    loadTickets();
                },
                error: function(response) {
                    Swal.fire('Error!', 'Could not add reply.', 'error');
                }
            });
        });

    });
</script>
@endpush