<div class="col-xl-3 col-lg-4">
	<div class="sidebar-wrap">
		<div class="sidebar-header">
			<div class="profile-wrapper">
				<div class="profile-image avatar avatar-xxxl rounded-circle">
					<img src="{{ getProfileImage() }}" alt="user-01" class="avatar avatar-xxxl rounded-circle headerProfileImg">
				</div>
				<a href="{{ route('customer.profile') }}" class="btn btn-icon btn-white rounded-circle"><i class="isax isax-edit-2"></i></a>
				<h6 class="fw-semibold mb-1 headerName">{{ getCurrentUserFullname() }}</h6>
				<p class="fs-14">
					{{ __('Member Since') }} <br>
					{{ \Carbon\Carbon::parse(Auth::user()->created_at)->format('d M Y') }}
				</p>

			</div>
		</div>
		<div class="sidebar-body">
			<div class="sidebar-menus">
				<ul>
					<li class="{{ request()->routeIs('user.dashboard') ? 'active' : '' }}">
						<a href="{{ route('user.dashboard') }}">
							<i class="isax isax-home"></i>
							<span class="ms-2">{{ __('Dashboard') }}</span>
						</a>
					</li>
					<li class="submenu">
						<a href="javascript:void(0);" class="{{ request()->routeIs(['customer.booking.upcoming']) || request()->routeIs(['customer.booking.completed']) || request()->routeIs(['customer.booking.cancelled']) ? 'active' : '' }}">
							<i class="isax isax-calendar-tick"></i>
							<span class="ms-2">{{ __('my_bookings') }}</span>
							<span class="isax isax-arrow-right-3 arrow-menu ms-auto"></span>
						</a>
						<ul>
							<li>
								<a href="{{ route('customer.booking.upcoming') }}" class="{{ request()->routeIs('customer.booking.upcoming') ? 'active' : '' }}">{{ __('Upcoming') }}</a>
							</li>
							<li>
								<a href="{{ route('customer.booking.completed') }}" class="{{ request()->routeIs('customer.booking.completed') ? 'active' : '' }}">{{ __('Completed') }}</a>
							</li>
							<li>
								<a href="{{ route('customer.booking.cancelled') }}" class="{{ request()->routeIs('customer.booking.cancelled') ? 'active' : '' }}">{{ __('Cancelled') }}</a>
							</li>
						</ul>
					</li>
					<li class="submenu">
						<a href="{{ route('customer.myorders.products') }}" class="{{ request()->routeIs(['customer.myorders.products', 'customer.myorders.delivery_track_detail']) ? 'active' : '' }}">
							<i class="isax isax-shopping-cart"></i>
							<span class="ms-2">{{ __('my_orders') }}</span>
							<span class="isax isax-arrow-right-3 arrow-menu ms-auto"></span>
						</a>
						<ul>
							<li><a href="{{ route('customer.myorders.products') }}" class="{{ request()->routeIs(['customer.myorders.products', 'customer.myorders.delivery_track_detail']) ? 'active' : '' }}">{{ __('Product') }}</a></li>
						</ul>
					</li>
					<li class="{{ request()->routeIs('customer.wishlist') ? 'active' : '' }}">
						<a href="{{ route('customer.wishlist') }}">
							<i class="isax isax-heart"></i>
							<span class="ms-2">{{__('wishlist')}}</span>
						</a>
					</li>
					<li class="{{ request()->routeIs('users.chat') ? 'active' : '' }}">
						<a href="{{ route('users.chat') }}">
							<i class="isax isax-message"></i>
							<span class="ms-2">{{__('Chat')}}</span>
						</a>
					</li>
					<li class="submenu">
						<a href="javascript:void(0);" class="{{ request()->routeIs(['customer.wallet']) || request()->routeIs(['customer.order_invoice_list']) ? 'active' : '' }}">
							<i class="isax isax-dollar-square"></i>
							<span class="ms-2">{{__('wallet_payments')}}</span>
							<span class="isax isax-arrow-right-3 arrow-menu ms-auto"></span>
						</a>
						<ul>
							<li><a href="{{ route('customer.wallet') }}" class="{{ request()->routeIs('customer.wallet') ? 'active' : '' }}">{{ __('Wallet') }}</a></li>
							<li><a href="{{ route('customer.order_invoice_list') }}" class="{{ request()->routeIs('customer.order_invoice_list') ? 'active' : '' }}">{{__('Invoices')}}</a></li>
						</ul>
					</li>
					<li class="{{ request()->routeIs('customer.reviews') ? 'active' : '' }}">
						<a href="{{ route('customer.reviews') }}">
							<i class="isax isax-star-1"></i>
							<span class="ms-2">{{ __('Reviews') }}</span>
						</a>
					</li>
					<li class="{{ request()->routeIs('customer.ticket.*') ? 'active' : '' }}">
						<a href="{{ route('customer.ticket.index') }}">
							<i class="isax isax-ticket"></i>
							<span class="ms-2">{{__('support_tickets')}}</span>
						</a>
					</li>
					<li class="{{ request()->routeIs('customer.notification') ? 'active' : '' }}">
						<a href="{{ route('customer.notification') }}">
							<i class="isax isax-notification"></i>
							<span class="ms-2">{{ __('Notifications') }}</span>
						</a>
					</li>
					<li class="submenu">
						<a href="javascript:void(0);" class="{{ request()->routeIs(['customer.profile', 'customer.change-password', 'customer.account-settings', 'customer.billing-address', 'customer.delete-account', 'customer.notification.preferences']) ? 'active' : '' }}">
							<i class="isax isax-setting-2"></i>
							<span class="ms-2">{{ __('Settings') }}</span>
							<span class="isax isax-arrow-right-3 arrow-menu ms-auto"></span>
						</a>
						<ul>
							<li><a href="{{ route('customer.profile') }}" class="{{ request()->routeIs('customer.profile') ? 'active' : '' }}">{{ __('Profile') }}</a></li>
							<li><a href="{{ route('customer.change-password') }}" class="{{ request()->routeIs('customer.change-password') ? 'active' : '' }}">{{ __('Change Password') }}</a></li>
							<li><a href="{{ route('customer.account-settings') }}" class="{{ request()->routeIs('customer.account-settings') ? 'active' : '' }}">{{ __('account_settings') }}</a></li>
							<li><a href="{{ route('customer.billing-address') }}" class="{{ request()->routeIs('customer.billing-address') ? 'active' : '' }}">{{ __('billing_address') }}</a></li>
							<li><a href="{{ route('customer.notification.preferences') }}" class="{{ request()->routeIs('customer.notification.preferences') ? 'active' : '' }}">{{ __('notification_preferences') }}</a></li>
							<li><a href="{{ route('customer.delete-account') }}" class="{{ request()->routeIs('customer.delete-account') ? 'active' : '' }}">{{ __('Delete Account') }}</a></li>
						</ul>
					</li>
				</ul>
			</div>
		</div>
	</div>
</div>