@extends('frontend.theme_2.app')

@section('title', __('Reviews') . ' || ' . $companyName)

@section('content')
	<div class="page-wrapper">

        <!-- Start Breadscrumb -->
        @include('frontend.pages.banner')
        <!-- End Breadscrumb -->

        <!-- Start Content -->
        <div class="content">
            <div class="container">
				<!-- start row -->
				<div class="row">
					@include('frontend.pages.customer.sidemenu')
					<div class="col-xl-9 col-lg-8">
						<div class="d-flex align-items-center justify-content-between mb-3">
							<h4 class="mb-0">{{ __('Reviews') }}</h4>
						</div>
						<hr>
						<div class="spinner-loader"></div>
						<div id="review_list_container">
						</div>
						<div class="d-flex align-items-center justify-content-center mt-3">
							<a href="javascript:void(0);" class="btn btn-dark d-inline-flex align-items-center load-more-reviews-btn d-none"><i class="isax isax-rotate-left me-1"></i>{{ __('load_more') }}</a>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- Start edit Modal -->
		<div id="edit_review" class="modal fade">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<form id="edit_review_form">
						<input type="hidden" name="review_id" id="review_id">
						<div class="modal-header">
							<h6 class="text-dark modal-title fw-bold">{{ __('edit_review') }}</h6>
							<button type="button" class="btn-close btn-close-modal custom-btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="isax isax-close-circle"></i></button>
						</div>
						<div class="modal-body">
							<div class="row">
								<div class="col-lg-12">
									<div class="mb-3">
										<label class="form-label">{{ __('your_ratings') }}</label>
										<div class="rating star-box ratings_stars">
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
										</div>
									</div>
								</div>
							</div>
							<div class="mb-3">
								<label for="review" class="form-label">{{ __('review') }}</label>
								<textarea class="form-control" rows="4" name="review" id="review"></textarea>
								<span class="text-danger error-text" id="review_error"></span>
							</div>
						</div>
						<div class="modal-footer">
							<div class="d-flex align-items-center justify-content-end">
								<button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
								<button type="submit" class="btn btn-secondary submit-review">{{ __('save_changes') }}</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- End Add Modal -->

		<!-- Start Delete -->
		<div id="delete_modal" class="modal fade">
			<div class="modal-dialog modal-dialog-centered modal-sm">
				<div class="modal-content">
					<form id="deleteReviewForm">
						<input type="hidden" name="delete_review_id" id="delete_review_id" value="">
						<div class="modal-body">
							<div class="d-flex align-items-center justify-content-center">
								<span class="delete-icon rounded-circle mb-3"><i class="isax isax-trash fs-16"></i></span>
							</div>
							<div class="text-center">
								<h6 class="mb-1">{{ __('Are you Sure') }}</h6>
								<p class="mb-3">{{ __('delete_review_confirmation') }}</p>
							</div>
							<div class="d-flex align-items-center justify-content-center">
								<button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
								<button type="submit" class="btn btn-danger delete-confirm" id="delete_confirm">{{ __('Delete') }}</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- End Delete -->
	</div>

@endsection

@push('scripts')
	<script src="{{ asset('frontend/assets/js/custom/customer-review.js') }}"></script>
@endpush