@extends('frontend.theme_2.app')

@section('title', __('products') . ' || ' . $companyName)

@push('styles')
<link rel="stylesheet" href=" {{ asset('frontend/assets/plugins/daterangepicker/daterangepicker.css') }}">
@endpush

@section('content')

	<div class="page-wrapper">

            <!-- Start Breadscrumb -->
            @include('frontend.pages.banner')
            <!-- End Breadscrumb -->

            <div class="content">
                <div class="container">

					<!-- start row -->
					<div class="row">

						@include('frontend.pages.customer.sidemenu')

						<div class="col-xl-9 col-lg-8">

							<!-- Page Header -->
							<div class="d-flex align-items-center justify-content-between flex-wrap gap-3 mb-4">
								<h4 class="mb-0">{{ __('products') }}</h4>
								<div id="reportrange" class="reportrange-picker bg-white d-flex align-items-center">
									<i class="isax isax-calendar-edit text-dark fs-14 me-1"></i><span class="reportrange-picker-field">1 Aug 25 - 31 Aug 25</span><i class="isax isax-arrow-down-14 ms-2"></i>
								</div>
							</div>
							<!-- End Page Header -->
							<div class="text-center py-5 w-100 loader">
								<div class="spinner-border text-primary" role="status">
									<span class="visually-hidden">{{ __('loading') }}</span>
								</div>
								<p class="mt-2">{{ __('fetching_orders') }}</p>
							</div>
							<div id="orders-container" class="purchase-list d-none"></div>
						</div> <!-- end col -->

					</div>
					<!-- end row -->

                </div>
            </div>

        </div>
        <div id="view_details" class="modal fade">
	        <div class="modal-dialog modal-dialog-centered modal-lg">
	            <div class="modal-content">
	                <div class="modal-header d-flex align-items-center justify-content-between">
	                    <h5 class="modal-title mb-0">{{ __('order_summary') }}<span class="badge badge-sm badge-soft-purple ms-2" id="order_id"></span></h5>
	                    <button type="button" class="btn-close custom-btn-close opacity-100 bg-transparent" data-bs-dismiss="modal" aria-label="Close"><i class="isax isax-close-circle"></i></button>
	                </div>
	                <div class="modal-body">
	                </div>
	            </div>
	        </div>
	    </div>
@endsection
@push('scripts')
	<script src="{{ asset('frontend/assets/js/custom/myorders.js') }}"></script>
@endpush