@extends('frontend.theme_2.app')

@section('title', __('Invoices') . ' || ' . $companyName)

@push('styles')

<link rel="stylesheet" href=" {{ asset('frontend/assets/plugins/daterangepicker/daterangepicker.css') }}">
<link rel="stylesheet" href=" {{ asset('frontend/assets/plugins/datatables/datatables.min.css') }}">
@endpush
@section('content')
	<div class="page-wrapper">

        <!-- Start Breadscrumb -->
        @include('frontend.pages.banner')
        <!-- End Breadscrumb -->

        <!-- Start Content -->
        <div class="content">
            <div class="container">

				<!-- start row -->
				<div class="row">

					@include('frontend.pages.customer.sidemenu')

					<div class="col-xl-9 col-lg-8">
						<div class="d-flex align-items-center justify-content-between mb-4">
							<h4 class="mb-0">{{__('Invoices')}}</h4>

							<div id="reportrange" class="reportrange-picker d-flex align-items-center">
								<i class="isax isax-calendar-edit fs-14 me-1"></i><span class="reportrange-picker-field">1 Aug 25 - 31 Aug 25</span><i class="isax isax-arrow-down-14 ms-2"></i>
							</div>
						</div>
						<div class="card mb-0">
							<div class="card-body">
								<!-- start search input item -->
								<div class="d-flex align-items-center justify-content-between gap-2 flex-wrap">
									<h5 class="mb-0">{{ __('Total Invoices') }}</h5>
								<div class="d-flex align-items-center justify-content-between gap-2 flex-wrap">

									<!-- Tab Navigation -->
									<div class="mb-2">
										<ul class="nav nav-tabs nav-solid-primary wishlist-tab">
											<li class="nav-item"><a class="nav-link active invoice_tab" data-type="service" href="#solid-tab1" data-bs-toggle="tab">{{__('Services')}}</a></li>
											<li class="nav-item"><a class="nav-link invoice_tab" href="#solid-tab2" data-type="product" data-bs-toggle="tab">{{__('products')}}</a></li>
										</ul>
									</div>
									<div class="dropdown">
										<a href="javascript:void(0);" class="dropdown-toggle sort-dropdown dropdown-sm btn btn-md border border-color d-inline-flex align-items-center fw-normal" data-bs-toggle="dropdown" aria-expanded="false">
											<i class="isax isax-arrow-3 me-1"></i><span class="me-1">{{ __('sort_by') }}</span>
										</a>
										<ul class="dropdown-menu dropdown-menu-end p-2">
											<li>
												<a href="javascript:void(0);" class="dropdown-item fw-normal fs-14 rounded-1 sort-option" data-value="oldest">{{ __('oldest') }}</a>
											</li>
											<li>
												<a href="javascript:void(0);" class="dropdown-item fw-normal fs-14 rounded-1 sort-option" data-value="newest">{{ __('newest') }}</a>
											</li>
										</ul>
									</div>
								</div>
								</div>
								<!-- end search input item -->
								<hr>

								<div class="spinner-loader"></div>
								<div id="invoice-container" class="table-responsive table-nowrap real-table d-none">
									<table class="table mb-0 border border-bottom-0 datatable table-nowrap no-pagination" id="invoiceTable">
										<thead>
											<tr>
												<th>{{ __('invoice_id') }}</th>
												<th>{{ __('invoice_date') }}</th>
												<th>{{ __('Description') }}</th>
												<th>{{__('Total Amount') }}</th>
												<th>{{__('due_date')}}</th>
												<th>{{ __('Status') }}</th>
												<th></th>
											</tr>
										</thead>
									</table>
								</div>
							</div><!-- end card body -->
						</div><!-- end card -->
					</div>
				</div>
			</div>
		</div>
	</div>

@endsection
@push('scripts')
	<script src="{{ asset('frontend/assets/js/custom/invoice_details.js') }}"></script>
	<script src="{{ asset('frontend/assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
	<script src="{{ asset('frontend/assets/plugins/datatables/datatables.min.js') }}"></script>
@endpush