<div class="card mb-3">
	<div class="card-body">
		<div class="mb-3">
			<h6 class="mb-0">{{ __('product_info') }}</h6>
		</div>
		@php
		    $image = null;

		    if ($order->product->meta->isNotEmpty()) {
		        $image = $order->product->meta[0]->source_Values ?? null;
		    }
		    else if(isset($order->product->meta)) {
		        $image = $order->product->meta->source_Values ?? null;
		    }

		    if($image != null)
		    	$imageUrl = uploadedAsset($image ?? '');
		@endphp

		<div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap gap-2 rounded">
			<div class="d-flex align-items-center flex-wrap flex-sm-nowrap gap-2 overflow-hidden">
				<a href="javascript:void(0);" class="avatar avatar-xxl flex-shrink-0">
					<img src="{{ $imageUrl }}" alt="product" class="img-fluid">
				</a>
				<div class="flex-grow-1 overflow-hidden">
					<h6 class="fs-16 fw-semibold text-truncate mb-2"><a href="javascript:void(0);">{{ $order->product_name ?? '-'}}</a></h6>
					<div class="d-flex align-items-center gap-2 flex-wrap item-info">
						<p class="mb-0">{{ __('category') }} : {{ $order->product->categories->name ?? '-' }}</p>
						<p class="mb-0">{{ __('ordered_on') }} : {{ date('d M Y',strtotime($order->booking->booking_date))}}</p>
					</div>
				</div>
			</div>
			@php
				$statusMap = [
                1 =>  __('pending'),
                2 =>  __('confirmed'),
                3 =>  __('shipped'),
                4 =>  __('delivery'),
                5 =>  __('vendor_cancel'),
                6 =>  __('customer_cancel'),
            ];

            $statusClass = [
                1 => 'badge-soft-warning',
                2 => 'badge-soft-success',
                3 => 'badge-soft-info',
                4 => 'badge-soft-success',
                5 => 'badge-soft-info',
                6 => 'badge-soft-info',
            ];

	            $status_class = $statusClass[$order->product_status] ?? 'badge-soft-info';
	            $status = $statusMap[$order->product_status] ??  __('pending');
			@endphp
			<span class="badge badge-sm {{ $status_class }}">{{ $status }}</span>
		</div>
	</div>
</div> <!-- end card -->

<div class="card mb-3">
	<div class="card-body">
		<div class="mb-3">
			<h6 class="mb-0">{{ __('Overview') }}</h6>
		</div>
		<p class="mb-2">{{ __('brand') }} : <span class="text-dark">{{ $order->product->shop->shop_name ?? '-' }}</span></p>
		<p class="mb-2">{{ __('quantity') }} :<span class="text-dark">{{ $order->quantity ?? '-' }}</span></p>
		<p class="mb-2">{{ __('variant') }} : <span class="text-dark">{{ $order->variant ?? '-' }}</span></p>
	</div>
</div>	<!-- end card -->

<div class="card mb-3">
	<div class="card-body">
		<div class="row row-gap-3">
			<div class="col-xl-6">
				<div class="mb-3">
					<h6 class="mb-0">{{ __('customer_details') }}</h6>
				</div>
				<p class="mb-2">{{ __('name') }} : <span class="text-dark">
					{{ !empty($order->booking->first_name) || !empty($order->booking->last_name)
						? ucwords(trim($order->booking->first_name . ' ' . $order->booking->last_name))
						: '-' }}
					</span>
				</p>
				<p class="mb-2">{{ __('email') }} : <span class="text-dark">{{ $order->booking->user_email ?? '-' }}</span></p>
				<p class="mb-0">{{ __('phone') }} : <span class="text-dark">{{ $order->booking->user_phone ?? '-' }}</span></p>
			</div>
			<div class="col-xl-6">
				<div class="mb-3">
					<h6 class="mb-0">{{ __('shipping_address') }}</h6>
				</div>
				<h6 class="fs-16 fw-medium mb-1"><span class="text-dark">
						{{ !empty($order->booking->first_name) || !empty($order->booking->last_name)
							? ucwords(trim($order->booking->first_name . ' ' . $order->booking->last_name))
							: '-' }}
					</span>
				</h6>
				<p class="mb-1">{{ $order->booking->user_address ?? '-' }}</p>
			</div>
		</div>
	</div>
</div>	<!-- end card -->

<div class="card mb-3">
	<div class="card-body">
		<div class="mb-3">
			<h6 class="mb-0">{{ __('payment_details') }}</h6>
		</div>

		<!-- start row-->
		<div class="row row-gap-4">

			<div class="col-xl-3 col-sm-6">
				<div class="d-flex align-items-center">
					<span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
						<i class="isax isax-wallet-2"></i>
					</span>
					<div>
						<h6 class="fs-14 fw-semibold mb-1">{{ __('product_subtotal') }}</h6>
						<p class="mb-0">{{ $currencySymbol }}{{ $order->price ?? 0}}</p>
					</div>
				</div>
			</div> <!-- end col -->

			<div class="col-xl-3 col-sm-6">
				<div class="d-flex align-items-center">
					<span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
						<i class="isax isax-percentage-square"></i>
					</span>
					<div>
						<h6 class="fs-14 fw-semibold mb-1">{{ __('Tax') }}</h6>
						<p class="mb-0">{{ $currencySymbol }}{{ $order->booking->product_tax ?? '-'}}</p>
					</div>
				</div>
			</div> <!-- end col -->

			<div class="col-xl-3 col-sm-6">
				<div class="d-flex align-items-center">
					<span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
						<i class="isax isax-discount-circle"></i>
					</span>
					<div>
						<h6 class="fs-14 fw-semibold mb-1">{{ __('Coupon') }}</h6>
						<p class="mb-0">- {{ $currencySymbol }}{{ $order->booking->coupon_discount_amount ?? '0.00'}}</p>
					</div>
				</div>
			</div> <!-- end col -->

			<div class="col-xl-3 col-sm-6">
				<div class="d-flex align-items-center">
					<span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
						<i class="isax isax-receipt-discount"></i>
					</span>
					<div>
						<h6 class="fs-14 fw-semibold mb-1">{{ __('total_payable') }}</h6>
						<p class="mb-0">{{ $currencySymbol }}{{ $order->booking->payable_amount ?? '0.00'}}</p>
					</div>
				</div>
			</div> <!-- end col -->

		</div>
		<!-- end row-->

	</div>
</div> <!-- end card -->

<div class="card mb-0">
	<div class="card-body">
		<div class="mb-3">
			<h6 class="mb-0">{{ __('delivery_info') }}</h6>
		</div>
		@php
		    $startDate = \Carbon\Carbon::parse($order->booking->booking_date)->addDays(2);
		    $endDate = $startDate->copy()->addDays(2);
		    $estimated_delivery_date = $startDate->format('F j'). ' - ' .$endDate->format('F j');
		@endphp
		<p class="mb-2">{{ __('shipping_method') }} : <span class="text-dark">{{ __('delivery_message') }}</span></p>
		<p class="mb-2">{{ __('estimated_delivery_date') }} : <span class="text-dark">{{ $estimated_delivery_date }}</span></p>
		<p class="mb-0">{{ __('tracking') }} : <span class="text-dark">{{ __('track_message') }}</span></p>
	</div>
</div>	<!-- end card -->