@extends('frontend.theme_2.app')

@section('title', __('notification_preferences') . ' || ' . $companyName)

@section('content')

<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('notification_preferences') }}</li>
                    </ol>
                </nav>	
                <h1 class="breadcrumb-title">{{ __('notification_preferences') }}</h1>
            </div>
        </div>
        <img src="{{ asset('frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <!-- Start Content -->
    <div class="content">
        <div class="container">
            <!-- start row -->
            <div class="row">
                @include('frontend.pages.customer.sidemenu')
                <div class="col-xl-9 col-lg-8">
                    <div>
                        <h4 class="mb-0">{{ __('notification_preferences') }}</h4>
                    </div>
                    <hr>
                    <div class="card mb-0">
                        <div class="card-body">
                            <div>
                                <div class="d-flex align-items-center justify-content-between flex-wrap row-gap-3 border-bottom mb-4 pb-4">										
                                    <div class="d-flex align-items-center">
                                        <div>
                                            <h6 class="fs-16 fw-semibold mb-1">{{ __('booking_alerts') }}</h6>
                                            <p class="fs-14">{{ __('booking_alerts_description') }}</p>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <label class="d-flex align-items-center form-switch ps-3" for="toggleAppointment">
                                            <input id="toggleAppointment" class="form-check-input m-0 me-2 notification_status" type="checkbox"
                                                data-notification_type="booking_alerts_notification_status" {{ isset($notificationPreferences['booking_alerts_notification_status']) && $notificationPreferences['booking_alerts_notification_status'] == 1 ? 'checked' : '' }} aria-label="Toggle appointment notifications">
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div><!-- end card body -->
                    </div><!-- end card -->
                </div>
            </div>
        </div>
    </div>
    <!-- End Content -->
</div>

@endsection

@push('scripts')
    <script src="{{ asset('frontend/assets/js/custom/notification-preferences.js') }}"></script>
@endpush