@extends('frontend.theme_2.app')

@section('title', __('Delivery Tracking') . ' || ' . $companyName)

@push('styles')

<link rel="stylesheet" href=" {{ asset('frontend/assets/plugins/daterangepicker/daterangepicker.css') }}">
<link rel="stylesheet" href=" {{ asset('frontend/assets/plugins/datatables/datatables.min.css') }}">
@endpush

@section('content')

    <div class="page-wrapper">

            <!-- Start Breadscrumb -->
            @include('frontend.pages.banner')
            <!-- End Breadscrumb -->

            <div class="content">
                <div class="container">

                    <!-- start row -->
                    <div class="row">

                        @include('frontend.pages.customer.sidemenu')

                        <div class="col-xl-9 col-lg-8">
							<a href="{{ route('customer.myorders.products') }}" class="btn btn-md btn-white d-inline-flex align-items-center mb-2">
								<i class="isax isax-arrow-left me-1"></i>{{ __('Back') }}
							</a>
							<!-- Page Header -->
							<div class="d-flex align-items-center justify-content-between flex-wrap gap-3 border-bottom pb-4 mb-4">
								<h4 class="mb-0">{{ __('Delivery Tracking') }}</h4>
							</div>
							<!-- End Page Header -->
							@php
                                $statusMap = [
                                    1 =>  __('pending'),
                                    2 =>  __('confirmed'),
                                    3 =>  __('shipped'),
                                    4 =>  __('delivery'),
                                    5 =>  __('vendor_cancel'),
                                    6 =>  __('customer_cancel'),
									7 => __('refund_initiated'),
									8 => __('refund_completed'),
                                ];

                                $statusClass = [
                                    1 => 'badge-soft-warning',
                                    2 => 'badge-soft-success',
                                    3 => 'badge-soft-info',
                                    4 => 'badge-soft-success',
                                    5 => 'badge-soft-info',
                                    6 => 'badge-soft-info',
									7 => 'badge-soft-info',
									8 => 'badge-soft-success',
                                ];

                                // Check if order is cancelled (status 5 or 6)
                                $isCancelled = in_array($bookingProducts->product_status, [5, 6, 7, 8]);
                                $isNormalFlow = in_array($bookingProducts->product_status, [1, 2, 3, 4]);
                            @endphp
							<div class="card mb-0">
								<div class="card-body">

									<!-- start row -->
									<div class="row row-gap-4">
										<div class="col-xl-7 col-lg-12">

											<div class="d-flex align-items-center justify-content-between gap-2 overflow-hidden mb-4">
												<div class="d-flex align-items-center gap-2 overflow-hidden">
													<a href="{{ route('productdetail', $bookingProducts->product->slug ?? 0) }}" class="avatar avatar-lg flex-shrink-0">
														<img src="{{ $productImage ?? '' }}" alt="product" class="img-fluid">
													</a>
													<div class="flex-grow-1 overflow-hidden">
														<h6 class="fs-16 fw-semibold text-truncate mb-1"><a href="{{ route('productdetail', $bookingProducts->product->slug ?? 0) }}">{{ $bookingProducts->product->source_name ?? '-' }}</a></h6>
														<div class="d-flex align-items-center gap-2 flex-wrap item-info">
															<p class="mb-0">{{ $bookingProducts->booking->order_id ?? '' }}</p>
															<p class="text-dark mb-0">{{ $bookingProducts->product->categories->name ?? '' }}</p>
														</div>
													</div>
												</div>
												<span class="badge badge-sm {{ $statusClass[$bookingProducts->product_status] ?? 'badge-soft-info'}}">{{ $statusMap[$bookingProducts->product_status] ?? 'Pending' }}</span>
												@if ($bookingProducts->product_status == 8)
													<a href="{{ $refundPaymentProof ?? '' }}" target="_blank" class="btn btn-sm btn-white d-inline-flex align-items-center">
														<i class="isax isax-eye me-1"></i>{{ __('view_proof') }}
													</a>
												@endif
											</div>

											<!-- Track List for Normal Flow (Status 1-4) -->
											@if($isNormalFlow)
												<div class="track-wrap mb-4">
													<ul class="track-list">

														{{-- Step 1 --}}
														<li class="{{ $bookingProducts->product_status >= 1 ? 'completed' : '' }}">
															<span>
																<i class="isax isax-d-cube-scan"></i>
															</span>
														</li>

														{{-- Step 2 --}}
														<li class="{{ $bookingProducts->product_status >= 2 ? 'completed' : '' }}">
															<span>
																<i class="isax isax-box-tick"></i>
															</span>
														</li>

														{{-- Step 3 --}}
														<li class="{{ $bookingProducts->product_status >= 3 ? 'completed' : '' }}">
															<span>
																<i class="isax isax-truck-fast"></i>
															</span>
														</li>

														{{-- Step 4 --}}
														<li class="{{ $bookingProducts->product_status >= 4 ? 'completed' : '' }}">
															<span>
																<i class="isax isax-location"></i>
															</span>
														</li>

													</ul>
												</div>
											@endif


											<!-- Track List for Cancellation Flow (Status 5-8) -->
											@if($isCancelled)
												<div class="track-wrap mb-4">
													<ul class="track-list">

														{{-- Step 1 --}}
														<li class="step {{ $bookingProducts->product_status >= 5 ? 'completed' : '' }}">
															<span>
																<i class="isax isax-close-circle"></i>
															</span>
															{{-- Line to Step 2 --}}
															<div class="line {{ $bookingProducts->product_status >= 7 ? 'completed' : '' }}"></div>
														</li>

														{{-- Step 2 --}}
														<li class="step {{ in_array($bookingProducts->product_status, [7, 8]) ? 'completed' : '' }}">
															<span>
																<i class="isax isax-card-remove"></i>
															</span>
															{{-- Line to Step 3 --}}
															<div class="line {{ $bookingProducts->product_status == 8 ? 'completed' : '' }}"></div>
														</li>

														{{-- Step 3 --}}
														<li class="step {{ $bookingProducts->product_status == 8 ? 'completed' : '' }}">
															<span>
																<i class="isax isax-tick-circle"></i>
															</span>
														</li>

													</ul>
												</div>
											@endif


											<!-- Order Tracking for Normal Flow (Status 1-4) -->
											@if($isNormalFlow)
											<div class="order-tracking-wrap mb-4">
												<h6 class="mb-3">{{ __('Shipment Status') }}</h6>
												<ul class="order-tracking-list">
													<li class="{{ $bookingProducts->product_status >= 1 ? 'completed' : 'active' }}">
														<div class="tracking-content">
															<h6 class="fs-16 fw-semibold mb-1">{{ __('Order Placed') }}</h6>
															<span class="fs-14 d-block mb-1">{{ !empty($tracker_data) && $tracker_data['pending'] ? formatDateTime($tracker_data['pending']) : '' }}</span>
															<p class="mb-0">{{ $bookingProducts->product_status >= 1 ? __('shippment_status_message') : '' }}</p>
														</div>
													</li>
													<li class="{{ $bookingProducts->product_status >= 2 ? 'completed' : 'active' }}">
														<div class="tracking-content">
															<h6 class="fs-16 fw-semibold mb-1">{{ __('Confirm Shipment') }}</h6>
															<span class="fs-14 d-block mb-1">{{ !empty($tracker_data) && isset($tracker_data['confirmed']) && $tracker_data['confirmed'] ? formatDateTime($tracker_data['confirmed'],true) : '' }}</span>
															<p class="mb-0">{{ $bookingProducts->product_status >= 2 ? __('order_placed_status_message') : '' }}</p>
														</div>
													</li>
													<li class="{{ $bookingProducts->product_status >= 3 ? 'completed' : 'active' }}">
														<div class="tracking-content">
															<h6 class="fs-16 fw-semibold mb-1">{{ __('Out for Delivery') }}</h6>
															<span class="fs-14 d-block mb-1">{{ !empty($tracker_data) && isset($tracker_data['shipped']) && $tracker_data['shipped'] ? formatDateTime($tracker_data['shipped'],true) : '' }}</span>
															<p class="mb-0">{{ $bookingProducts->product_status >= 3 ? __('out_for_delivery_status_message') : '' }}</p>
														</div>
													</li>
													<li class="{{ $bookingProducts->product_status >= 4 ? 'completed' : 'active' }}">
														<div class="tracking-content">
															<h6 class="fs-16 fw-semibold mb-1">{{ __('Delivered') }}</h6>
															<span class="fs-14 d-block mb-1">{{ !empty($tracker_data) && isset($tracker_data['delivered']) && $tracker_data['delivered'] ? formatDateTime($tracker_data['delivered'],true) : '' }}</span>
															<p class="mb-0">{{ $bookingProducts->product_status >= 4 ? __('picked_up_status_message') : '' }}</p>
														</div>
													</li>
												</ul>
											</div>
											<div class="card mb-0">
												<div class="card-body">
													<h6 class="mb-3">{{ __('Date & Time') }}</h6>
													<div class="d-flex align-items-center gap-3 flex-wrap justify-content-between">
														<div>
															<p class="fs-14 mb-1">{{ __('Shipment Date') }}</p>
															<h6 class="fs-16 fw-semibold mb-0 text-center">{{ $data['shipping_delivery'] ?? '-'}}</h6>
														</div>
														<div>
															<p class="fs-14 mb-1">{{ __('Approximate Duration') }}</p>
															<h6 class="fs-16 fw-semibold mb-0">{{ $data['delivery_difference'] ?? ''}}</h6>
														</div>
														<div>
															<p class="fs-14 mb-1">{{ __('Expected Date') }}</p>
															<h6 class="fs-16 fw-semibold mb-0">{{ $data['expected_delivery'] ?? ''}}</h6>
														</div>
													</div>
												</div>
											</div>
											@endif

											<!-- Order Tracking for Cancellation Flow (Status 5-8) -->
											@if($isCancelled)
											<div class="order-tracking-wrap mb-4">
												<h6 class="mb-3">{{ __('Cancellation Status') }}</h6>
												<ul class="order-tracking-list">
													<li class="{{ in_array($bookingProducts->product_status, [5, 6, 7, 8]) ? 'completed' : 'active' }}">
														<div class="tracking-content">
															<h6 class="fs-16 fw-semibold mb-1">
																{{ $bookingProducts->product_status == 5 ? __('Vendor Cancelled') : __('Customer Cancelled') }}
															</h6>
															<span class="fs-14 d-block mb-1">{{ !empty($tracker_data) && isset($tracker_data['cancelled']) && $tracker_data['cancelled'] ? formatDateTime($tracker_data['cancelled'],true) : '' }}</span>
															<p class="mb-0">{{ __('Your order has been cancelled') }}</p>
														</div>
													</li>
													@if(in_array($bookingProducts->product_status, [7, 8]))
													<li class="{{ in_array($bookingProducts->product_status, [7, 8]) ? 'completed' : 'active' }}">
														<div class="tracking-content">
															<h6 class="fs-16 fw-semibold mb-1">{{ __('Refund Initiated') }}</h6>
															<span class="fs-14 d-block mb-1">{{ !empty($tracker_data) && isset($tracker_data['refund_initiated']) && $tracker_data['refund_initiated'] ? formatDateTime($tracker_data['refund_initiated'],true) : '' }}</span>
															<p class="mb-0">{{ __('Your refund process has been initiated') }}</p>
														</div>
													</li>
													@endif
													@if($bookingProducts->product_status == 8)
													<li class="{{ $bookingProducts->product_status == 8 ? 'completed' : 'active' }}">
														<div class="tracking-content">
															<h6 class="fs-16 fw-semibold mb-1">{{ __('Refund Completed') }}</h6>
															<span class="fs-14 d-block mb-1">{{ !empty($tracker_data) && isset($tracker_data['refund_completed']) && $tracker_data['refund_completed'] ? formatDateTime($tracker_data['refund_completed'],true) : '' }}</span>
															<p class="mb-0">{{ __('Your refund has been completed successfully') }}</p>
														</div>
													</li>
													@endif
												</ul>
											</div>
											@endif
										</div> <!-- end col -->

										<div class="col-xl-5">
											<div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-4">
												<h6 class="mb-0">{{ __('Live Tracking') }}</h6>
												@if($bookingProducts->product_status < 6 && $bookingProducts->product_status != 3 && $bookingProducts->product_status != 4)
													<a href="javascript:void(0);" class="link-danger cancel-booking-btn" data-booking-id="{{$bookingProducts->id}}">{{ __('Cancel Order') }}</a>
												@elseif($bookingProducts->product_status == 6)
													<a href="javascript:void(0);" class="link-danger refund-booking-btn" data-booking-id="{{$bookingProducts->id}}">{{ __('initial_refund') }}</a>
												@endif

											</div>
                                            @if($bookingProducts->product_status && $bookingProducts->product_status == 4)
                                                <div class="tracking-map mb-4">
                                                    <iframe src="{{$data['customer_googleMapUrl']}}"  allowfullscreen loading="lazy" referrerpolicy="no-referrer-when-downgrade" title="Map"></iframe>
                                                </div>
                                            @else
                                                <div class="tracking-map mb-4">
                                                    <iframe src="{{$data['vendor_googleMapUrl']}}"  allowfullscreen loading="lazy" referrerpolicy="no-referrer-when-downgrade" title="Map"></iframe>
                                                </div>
                                            @endif

											<div class="card mb-0">
												<div class="card-body">
													<h6 class="mb-2">{{ __('Contact Details') }}</h6>
													<div class="d-flex align-items-center justify-content-between gap-2 flex-wrap">
														<div class="d-flex align-items-center">
															<span class="avatar me-2 flex-shrink-0">
																@php
																	 $profile_image_url = $user_address->profile_image
												                        ? url('storage/profile/' . $user_address->profile_image)
												                        : null;
																@endphp
																<img src="{{ $profile_image_url }}" alt="user" class="img-fluid rounded-circle">
															</span>
															<div>
																<h6 class="fs-16 fw-semibold mb-1">{{ $user_address->name ?? ''}}</h6>
																<p class="fs-14 mb-0">{{ $user_address->email ?? ''}}</p>
															</div>
														</div>
														<div class="d-flex align-items-center gap-2">
															<a href="javascript:void(0);" class="btn btn-md btn-icon btn-light rounded fs-16"><i class="isax isax-message"></i></a>
															<a href="javascript:void(0);" class="btn btn-md btn-icon btn-light rounded fs-16"><i class="isax isax-call"></i></a>
														</div>
													</div>
												</div>
											</div> <!-- end card -->

										</div> <!-- end card -->

									</div>

								</div>
							</div>

						</div> <!-- end col -->

                    </div>
                    <!-- end row -->
                    <div id="cancel_booking" class="modal fade" tabindex="-1">
					    <div class="modal-dialog modal-dialog-centered">
					        <div class="modal-content">
					            <div class="modal-body">
					                <form id="cancelBookingForm">
					                    @csrf
					                    <input type="hidden" id="booking_id_to_cancel" name="booking_id">
					                    <div class="text-center mb-3">
					                        <span class="avatar avatar-lg avatar-rounded bg-soft-danger text-danger fs-16 mb-3">
					                            <i class="isax isax-close-circle"></i>
					                        </span>
					                        <h6 class="mb-1">{{ __('Cancel Booking') }}</h6>
					                        <p class="mb-0">{{ __('Are you sure you want to cancel this booking?')}} </p>
					                    </div>
					                    <div class="mb-3">
					                        <label class="form-label" for="cancellation_reason">{{ __('Reason for Cancellation')}}</label>
					                        <textarea class="form-control" id="cancellation_reason" name="reason" rows="3" required></textarea>
					                    </div>
					                    <div class="d-flex align-items-center gap-2">
					                        <button type="button" class="btn btn-light w-100" data-bs-dismiss="modal">{{ __('Close') }}</button>
					                        <button type="submit" class="btn btn-danger w-100">{{ __('Yes, Cancel') }}</button>
					                    </div>
					                </form>
					            </div>
					        </div>
					    </div>
					</div>

					<div id="refund_initiate" class="modal fade" tabindex="-1">
					    <div class="modal-dialog modal-dialog-centered">
					        <div class="modal-content">
					            <div class="modal-body">
					                <form id="refund_initiate_form">
					                    <input type="hidden" id="refund_amount" name="refund_booking_id" value="{{ $bookingProducts->id }} ">
					                    <div class="text-center mb-3">
					                        <span class="avatar avatar-lg avatar-rounded bg-soft-danger text-danger fs-16 mb-3">
					                            <i class="isax isax-close-circle"></i>
					                        </span>
					                        <h6 class="mb-1">{{ __('Refund Process') }}</h6>
					                        <p class="mb-0">{{ __('Are you sure you want to Initiate Refund Process?') }}</p>
					                    </div>
					                    <div class="d-flex align-items-center gap-2">
					                        <button type="{{ route('customer.myorders.delivery_track_detail',$bookingProducts->id) }}" class="btn btn-light w-100" data-bs-dismiss="modal">{{ __('Close') }}</button>
					                        <button type="submit" class="btn btn-danger w-100" id="refund_option">{{ __('Yes') }}</button>
					                    </div>
					                </form>
					            </div>
					        </div>
					    </div>
					</div>
                </div>
            </div>

        </div>
@endsection
@push('scripts')
    <script src="{{ asset('frontend/assets/js/custom/delivery_tracker_details.js') }}"></script>
    <script src="{{ asset('frontend/assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/plugins/datatables/datatables.min.js') }}"></script>
@endpush