@extends('frontend.theme_2.app')

@section('title', 'Customer Dashboard')

@push('styles')
<link rel="stylesheet" href="{{ asset('frontend/assets/plugins/daterangepicker/daterangepicker.css') }}">
@endpush

@section('content')
<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    @include('frontend.pages.banner')
    <!-- End Breadscrumb -->

    <div class="content">
        <div class="container">
            <!-- start row -->
            <div class="row">
                @include('frontend.pages.customer.sidemenu')

                <div class="col-xl-9 col-lg-8">
                    <a href="{{ route('customer.myorders.products') }}" class="btn btn-md btn-white d-inline-flex align-items-center">
                        <i class="isax isax-arrow-left me-1"></i>{{ __('Back') }}
                    </a>
                    <!-- Page Header -->
                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 mb-4">
                        <h4 class="mb-0">{{ __('delivery_traking') }}</h4>
                        <div id="reportrange" class="reportrange-picker bg-white d-flex align-items-center">
                            <i class="isax isax-calendar-edit text-dark fs-14 me-1"></i>
                            <span class="reportrange-picker-field">1 Aug 25 - 31 Aug 25</span>
                            <i class="isax isax-arrow-down-14 ms-2"></i>
                        </div>
                    </div>
                    <!-- End Page Header -->
					<div id="orders-container" class="orders-list">
						<!-- Cards will be loaded here dynamically -->
					</div>
                </div> <!-- end col -->
            </div>
            <!-- end row -->
        </div>
    </div>
</div>

<!-- Order Details Modal -->
<div class="modal fade" id="view_details" tabindex="-1" aria-labelledby="viewDetailsLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewDetailsLabel">
                    {{ __('order_details') }} - <span id="order_id"></span>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- Content will be loaded here -->
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('frontend/assets/js/moment.min.js') }}"></script>
<script src="{{ asset('frontend/assets/plugins/daterangepicker/daterangepicker.js') }}"></script>
<script src="{{ asset('frontend/assets/js/custom/delivery_tracker.js') }}"></script>
@endpush
