@extends('frontend.theme_2.app')

@section('title', __('Delete Account') . ' || ' . $companyName)

@section('content')

<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('Delete Account') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{ __('Delete Account') }}</h1>
            </div>
        </div>
        <img src="{{ asset('frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <!-- Start Content -->
    <div class="content">
        <div class="container">
            <!-- start row -->
            <div class="row">
                @include('frontend.pages.customer.sidemenu')
                <div class="col-xl-9 col-lg-8">
                    <div>
                        <h4 class="mb-0">{{ __('Delete Account') }}</h4>
                    </div>
                    <hr>
                    <div class="card mb-0">
                        <div class="card-body">
                            <div class="row align-items-center justify-content-between row-gap-3 ">
                                <div class="col-lg-10">
                                    <h6 class="fs-16 fw-semibold mb-1">{{ __('Delete your Account') }}</h6>
                                    <p class="fs-14 mb-0">{{ __('delete_account_info') }}</p>
                                </div>
                                <div class="col-lg-2 text-end">
                                    <a href="javascript:void(0);" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#delete_account">{{ __('Delete') }}</a>
                                </div>
                            </div>
                        </div><!-- end card body -->
                    </div><!-- end card -->
                </div>
            </div>
        </div>
    </div>
    <!-- End Content -->
</div>

<!-- Start delete account -->
<div id="delete_account" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Delete Account') }}</h5>
                <button type="button" class="btn-close btn-close-modal custom-btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="isax isax-close-circle"></i></button>
            </div>
            <form id="deleteAccountForm" autocomplete="off">
                <div class="modal-body p-4">
                    @if ($walletTotalAmount > 0 || $serviceBookingIncompleteCount > 0 || $serviceBookingRefundCount > 0 || $productOrderIncompleteCount > 0 || $productOrderRefundCount > 0)
                    <div class="mb-3">
                        <p class="fs-14 fw-semibold">{{ __('you_still_have_the_following') }}</p>
                        @if ($walletTotalAmount > 0)
                        <h6 class="fs-14 fw-semibold mb-3">{{ __('wallet_balance') }} - {{ getDefaultCurrencySymbol() }}{{ $walletTotalAmount }}</h6>
                        @endif
                        @if ($serviceBookingIncompleteCount > 0 || $serviceBookingRefundCount > 0)
                        <div class="mb-3">
                            <h6 class="fs-14 fw-bold mb-3">{{ __('Bookings') }}:</h6>
                            @if ($serviceBookingIncompleteCount > 0)
                            <div class="fs-14 ms-3 fw-semibold mb-3">{{ __('incomplete_bookings') }} - {{ $serviceBookingIncompleteCount }}</div>
                            @endif
                            @if ($serviceBookingRefundCount > 0)
                            <div class="fs-14 ms-3 fw-semibold">{{ __('refund_initiated') }} - {{ $serviceBookingRefundCount }}</div>
                            @endif
                        </div>
                        @endif

                        @if ($productOrderIncompleteCount > 0 || $productOrderRefundCount > 0)
                        <div class="mb-3">
                            <h6 class="fs-14 fw-bold mb-3">{{ __('Orders') }}:</h6>
                            @if ($productOrderIncompleteCount > 0)
                            <div class="fs-14 ms-3 mb-3 fw-semibold">{{ __('incomplete_orders') }} - {{ $productOrderIncompleteCount }}</div>
                            @endif
                            @if ($productOrderRefundCount > 0)
                            <div class="fs-14 ms-3 fw-semibold">{{ __('refund_initiated') }} - {{ $productOrderRefundCount }}</div>
                            @endif
                        </div>
                        @endif
                    </div>
                    @endif
                    <h6 class="text-center mb-3">{{ __('delete_account_confirm') }}</h6>
                    <div class="mb-0">
                        <label for="password" class="form-label">{{__('Password')}}</label>
                        <div class="input-group input-group-flat pass-group">
                            <span class="input-group-text">
                                <i class="isax isax-lock text-dark"></i>
                            </span>
                            <input type="password" class="form-control pass-input" name="password" id="password" placeholder="**********">
                            <span class="input-group-text toggle-password ">
                                <i class="isax isax-eye-slash text-dark"></i>
                            </span>
                        </div>
                        <span class="text-danger error-text" id="password_error"></span>
                    </div>
                </div>
                <div class="modal-footer d-flex align-items-center justify-content-end gap-1">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                <button type="submit" class="btn btn-secondary" id="deleteAccountBtn" data-id="{{ Auth::id() }}">{{ __('Delete Account') }}</button>
            </div>
            </form>
        </div>
    </div>
</div>
<!-- End delete account -->

@endsection

@push('scripts')
    <script src="{{ asset('frontend/assets/js/custom/delete-account.js') }}"></script>
@endpush