<div class="row justify-content-center">

    <div class="col-xl-4 col-lg-6 col-md-6 d-flex">
        <div class="dashboard-item w-100">
            <div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
                <div>
                    <p class="mb-1 fs-14 text-body">{{ __('service_booked') }}</p>
                    <h3 class="mb-0">{{ $servicesBooked }}</h3>
                </div>
                <div class="avatar avatar-xl bg-secondary rounded-circle">
                    <i class="isax isax-calendar-2 fs-36"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-4 col-lg-6 col-md-6 d-flex">
        <div class="dashboard-item w-100">
            <div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
                <div>
                    <p class="mb-1 fs-14 text-body">{{ __('total_transactions') }}</p>
                    <h3 class="mb-0">{{ getDefaultCurrencySymbol() }}{{ $totalTransactions }}</h3>
                </div>
                <div class="avatar avatar-xl bg-success rounded-circle">
                    <i class="isax isax-money-send5 fs-36"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-4 col-lg-6 col-md-6 d-flex">
        <div class="dashboard-item w-100">
            <div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
                <div>
                    <p class="mb-1 fs-14 text-body">{{ __('products_purchased') }}</p>
                    <h3 class="mb-0">{{ $productsPurchased }}</h3>
                </div>
                <div class="avatar avatar-xl bg-purple rounded-circle">
                    <i class="isax isax-box fs-36"></i>
                </div>
            </div>
        </div>
    </div>

</div>

<div class="row">

    <div class="col-xl-6">
    <div class="card">
        <div class="card-body pb-1">
            <div class="sub-header d-flex align-items-center justify-content-between flex-wrap gap-2">
                <h5 class="mb-0">{{ __('recent_booking') }}</h5>
                <a href="{{ route('customer.booking.upcoming') }}" class="view-link">{{ __('view_all') }}</a>
            </div>
            <div class="recent-list">
                @if($recentBookings->isNotEmpty())
                    @foreach($recentBookings as $booking_value)
                        @php
                            $image = $booking_value->product_image
                                ? asset('storage/' . $booking_value->product_image)
                                : asset('img/default-image.png');
                        @endphp
                        <div class="d-flex align-items-center justify-content-between gap-2 mb-3">
                            <div class="d-flex align-items-center overflow-hidden">
                                <a href="{{ route('servicedetail', $booking_value->product_id) }}" class="avatar avatar-lg flex-shrink-0 me-2">
                                    <img src="{{ $image }}" alt="service" class="avatar avatar-lg">
                                </a>
                                <div class="flex-grow-1 overflow-hidden">
                                    <h6 class="fs-16 fw-semibold text-truncate mb-1">
                                        <a href="{{ route('servicedetail', $booking_value->product_id) }}">
                                            {{ $booking_value->source_name ?? '' }}
                                        </a>
                                    </h6>
                                    <p class="fs-14 text-truncate mb-0">{{ $booking_value->category_name ?? '' }}</p>
                                </div>
                            </div>
                            <div>
                                <h6 class="fs-16 fw-semibold mb-0">
                                    {{ getDefaultCurrencySymbol() }}{{ number_format($booking_value->total_amount, 2) }}
                                </h6>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="empty-state">
                        {{ __('no_recent_booking') }}
                    </div>
            @endif
            </div>
        </div>
    </div>
</div>


    <div class="col-xl-6">
        <div class="card">
            <div class="card-body pb-1">
                <div class="sub-header d-flex align-items-center justify-content-between flex-wrap gap-2">
                    <h5 class="mb-0">{{ __('recent_purchases') }}</h5>
                    <a href="{{ route('customer.myorders.products') }}" class="view-link">{{ __('view_all') }}</a>
                </div>
                <div class="recent-list">
                @if($recentPurchases->isNotEmpty())
                    @foreach($recentPurchases as $purchase_key => $purchase_value)
                        @php
                            $image = isset($purchase_value->product->meta) && $purchase_value->product->meta[0] && $purchase_value->product->meta[0]->source_Values ? asset('storage/' . $purchase_value->product->meta[0]->source_Values) : asset('img/default-image.png');

                        @endphp
                        <div class="d-flex align-items-center justify-content-between gap-2 mb-3">
                            <div class="d-flex align-items-center overflow-hidden">
                                <a href="{{ route('productdetail',$purchase_value->product->slug) }}" class="avatar avatar-lg flex-shrink-0 me-2">
                                    <img src="{{$image}}" alt="product" class="avatar avatar-lg">
                                </a>
                                <div class="flex-grow-1 overflow-hidden">
                                    <h6 class="fs-16 fw-semibold text-truncate mb-1"><a href="{{ route('productdetail',$purchase_value->product->slug) }}">{{ $purchase_value->product->source_name ?? ''}}</a></h6>
                                    <p class="fs-14 text-truncate mb-0">{{ $purchase_value->product->categories->name ?? ''}}</p>
                                </div>
                            </div>
                            <div>
                                <h6 class="fs-16 fw-semibold mb-0">{{ getDefaultCurrencySymbol() }}{{ $purchase_value->subtotal ? number_format($purchase_value->subtotal,2): 0 }}</h6>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="empty-state">{{ __('no_recent_purchase') }}</div>
                @endif
                </div>
            </div>
        </div>
    </div>

</div>

<div class="card mb-0">
    <div class="card-body">
        <div class="sub-header d-flex align-items-center justify-content-between flex-wrap gap-2">
            <h5 class="mb-0">{{ __('Recent Transaction') }}</h5>
            <div class="d-flex align-items-center gap-2">
                <div class="mb-2">
                    <ul class="nav nav-tabs nav-solid-primary wishlist-tab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <a class="nav-link active" id="services-tab" data-bs-toggle="tab" href="#services" role="tab" aria-controls="services" aria-selected="true">
                                {{ __('services') }}
                            </a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="products-tab" data-bs-toggle="tab" href="#products" role="tab" aria-controls="products" aria-selected="false">
                                {{ __('products') }}
                            </a>
                        </li>
                    </ul>
                </div>
                <a href="{{ route('customer.order_invoice_list') }}" class="view-link">{{ __('view_all') }}</a>
            </div>
        </div>
        <div class="tab-content mt-3">
            <!-- Services Table -->
            <div class="tab-pane fade show active" id="services" role="tabpanel" aria-labelledby="services-tab">
                <div class="table-responsive table-nowrap">
                    <table class="table border mb-0">
                        <thead>
                            <tr>
                                <th>{{ __('invoice_id') }}</th>
                                <th>{{ __('payment_date') }}</th>
                                <th>{{ __('Description') }}</th>
                                <th>{{ __('Total Amount') }}</th>
                                <th>{{ __('Status') }}</th>
                                <th>{{ __('payment_method') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $payment_method = [1 => 'Paypal', 2 => 'Stripe', 3 => 'Razorpay', 4 => 'BankTransfer', 5 => 'COD', 6 => 'Wallet', 7 => 'Cashfree', 8 => 'Payu', 9 => 'Authorizenet', 10 => 'Paystack'];
                            @endphp
                            @if($serviceBookingTransactions->isNotEmpty())
                                @foreach($serviceBookingTransactions as $transaction)
                                    <tr>
                                        <td>
                                            <a href="{{ route('customer.invoice.details', $transaction->order_id) }}">
                                                {{ $transaction->order_id }}
                                            </a>
                                        </td>
                                        <td>{{ $transaction->invoice_date }}</td>
                                        <td>{{ $transaction->description ?? '-' }}</td>
                                        <td>{{ $transaction->amount ?? '0.00' }}</td>
                                        <td>
											<span class="badge {{ $transaction->payment_status == 1 ? 'badge-soft-danger' : ($transaction->payment_status == 2? 'badge-soft-success' : 'badge-soft-warning') }}">
                                                {{ $transaction->payment_status_label }}
                                            </span>
                                        </td>
                                        <td>{{ $payment_method[$transaction->payment_type] }}</td>
                                    </tr>
                                @endforeach
                            @else
                                <tr><td colspan="6" class="text-center">{{ __('no_transactions_found') }}</td></tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Products Table -->
            <div class="tab-pane fade" id="products" role="tabpanel" aria-labelledby="products-tab">
                <div class="table-responsive table-nowrap">
                    <table class="table border mb-0">
                        <thead>
                            <tr>
                                <th>{{ __('invoice_id') }}</th>
                                <th>{{ __('payment_date') }}</th>
                                <th>{{ __('Description') }}</th>
                                <th>{{ __('Total Amount') }}</th>
                                <th>{{ __('Status') }}</th>
                                <th>{{ __('payment_method') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if($productOrderTransactionsData->isNotEmpty())
                                @foreach($productOrderTransactionsData as $transaction)
                                    <tr>
                                        <td>
                                            <a href="{{ route('customer.invoice.details', $transaction->order_id) }}">
                                                {{ $transaction->order_id }}
                                            </a>
                                        </td>
                                        <td>{{ $transaction->invoice_date }}</td>
                                        <td>{{ $transaction->description ?? '-' }}</td>
                                        <td>{{ $transaction->amount ?? '0.00' }}</td>
                                        <td>
                                            <span class="badge {{ $transaction->payment_status == 1 ? 'badge-soft-danger' : ($transaction->payment_status == 2? 'badge-soft-success' : 'badge-soft-warning') }}">
                                                {{ $transaction->payment_status_label }}
                                            </span>
                                        </td>
                                        <td>{{ $payment_method[$transaction->payment_type] }}</td>
                                    </tr>
                                @endforeach
                            @else
                                <tr><td colspan="6" class="text-center">{{ __('no_transactions_found') }}</td></tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>