@extends('frontend.theme_2.app')

@section('title', 'Customer Booking Upcoming')

@push('styles')
    <link rel="stylesheet" href=" {{ asset('frontend/assets/plugins/daterangepicker/daterangepicker.css') }}">
    <link rel="stylesheet" href=" {{ asset('frontend/assets/plugins/datatables/datatables.min.css') }}">
@endpush

@section('content')

<div class="breadcrumb-bar">
    <div class="container">
        <div class="breadcrumb-item">
            <nav aria-label="breadcrumb" class="page-breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-items"><a href="{{ url('/') }}">{{ __('Home') }}</a></li>
                    <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                    <li class="breadcrumb-items active" aria-current="page">{{ __('my_bookings') }}</li>
                </ol>
            </nav>
            <h1 class="breadcrumb-title">{{ __('my_bookings') }}</h1>
        </div>
    </div>
    <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
    <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
    <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
    <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
    <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
</div>

<div class="content">
    <div class="container">

        <div class="row">
            @include('frontend.pages.customer.sidemenu')

            <div class="col-xl-9 col-lg-8">

                <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 border-bottom pb-4 mb-4">
                    <h4 class="mb-0">{{ __('my_upcoming_bookings') }}</h4>
                    {{-- Filters can be implemented later if needed --}}
                </div>
                <div id="booking-list-container">
                    <div class="spinner-loader"></div>
                </div>

            </div> </div>
        </div>
</div>

<div id="cancel_booking" class="modal fade" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <form id="cancelBookingForm">
                    @csrf
                    <input type="hidden" id="booking_id_to_cancel" name="booking_id">
                    <div class="text-center mb-3">
                        <span class="avatar avatar-lg avatar-rounded bg-soft-danger text-danger fs-16 mb-3">
                            <i class="isax isax-close-circle"></i>
                        </span>
                        <h6 class="mb-1">{{ __('cancel_booking') }}</h6>
                        <p class="mb-0">{{__('cancel_booking_confirmation')}}</p>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="cancellation_reason">{{__('reason_for_cancellation')}}</label>
                        <textarea class="form-control" id="cancellation_reason" name="reason" rows="3" required></textarea>
                    </div>
                    <div class="d-flex align-items-center gap-2">
                        <button type="button" class="btn btn-light w-100" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                        <button type="submit" class="btn btn-danger w-100">{{__('Yes, Cancel')}}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div id="view_details" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header d-flex align-items-center justify-content-between">
                <h5 class="modal-title mb-0">{{ __('booking_summary') }}<span class="badge badge-sm badge-soft-purple ms-2" id="order_id"></span></h5>
                <button type="button" class="btn-close custom-btn-close opacity-100 bg-transparent" data-bs-dismiss="modal" aria-label="Close"><i class="isax isax-close-circle"></i></button>
            </div>

            <div class="modal-body">
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
{{-- SweetAlert for better notifications --}}
<script src="{{ asset('assets/plugins/sweetalert/sweetalert2.all.min.js') }}"></script>

<script>
$(document).ready(function() {

    // Setup CSRF token for all AJAX requests
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // Function to load upcoming bookings
    function loadBookings() {
        const container = $('#booking-list-container');
        container.html('<div class="spinner-loader"></div>'); // Show loader

        $.ajax({
            url: "{{ route('customer.booking.upcoming.list') }}",
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                container.empty(); // Clear loader
                if (response.data && response.data.length > 0) {
                    $.each(response.data, function(index, booking) {
                        var bookingHtml = `
                        <div class="booking-item">
                            <div class="row row-gap-3 align-items-center">
                                <div class="col-xl-8">
                                    <div class="d-flex align-items-center flex-wrap flex-sm-nowrap gap-2 overflow-hidden">
                                        <a href="#" class="avatar avatar-xxl flex-shrink-0">
                                            <img src="${booking.image_url}" alt="service" class="img-fluid">
                                        </a>
                                        <div class="flex-grow-1 overflow-hidden">
                                            <a href="javascript:void(0);" class="d-block text-secondary fs-14 mb-1">#${booking.order_id}</a>
                                            <h6 class="fs-16 fw-semibold text-truncate mb-1"><a href="#">${booking.source_name}</a></h6>
                                            <div class="d-flex align-items-center gap-2 flex-wrap item-info">
                                                <p class="d-inline-flex align-items-center mb-0"><i class="isax isax-category-2 me-1"></i>Category : ${booking.subcategory_name || 'N/A'}</p>
                                                <p class="d-inline-flex align-items-center mb-0"><i class="isax isax-calendar-tick me-1"></i>Date : ${booking.booking_date_formatted}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-4">
                                    <div class="d-flex align-items-center justify-content-xl-end gap-2">
                                        <a href="javascript:void(0);"
                                        class="btn btn-sm btn-white d-inline-flex align-items-center view-details"
                                        data-id="${booking.booking_id}"
                                        data-bs-toggle="modal"
                                        data-bs-target="#view_details">
                                            <i class="isax isax-eye me-1"></i> {{ __('Details') }}
                                        </a>
                                        <a href="javascript:void(0);" class="btn btn-sm btn-danger d-inline-flex align-items-center cancel-booking-btn" data-booking-id="${booking.booking_id}">
                                            <i class="isax isax-close-circle me-1"></i>{{ __('Cancel') }}
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        `;
                        container.append(bookingHtml);
                    });
                } else {
                    container.html('<h5 class="text-center my-5">You have no upcoming bookings.</h5>');
                }
            },
            error: function(xhr, status, error) {
                container.html('<div class="alert alert-danger">Failed to load bookings. Please try again later.</div>');
            }
        });
    }

    // Initial load of bookings
    loadBookings();

    // Event delegation for cancel button click
    $(document).on('click', '.cancel-booking-btn', function() {
        var bookingId = $(this).data('booking-id');
        $('#booking_id_to_cancel').val(bookingId);
        $('#cancel_booking').modal('show');
    });

    // Handle the cancellation form submission
    $('#cancelBookingForm').on('submit', function(e) {
        e.preventDefault();
        var form = $(this);
        var formData = form.serialize();
        var submitButton = form.find('button[type="submit"]');

        submitButton.prop('disabled', true).text('Cancelling...');

        $.ajax({
            url: "{{ route('customer.booking.upcoming.cancel') }}",
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                $('#cancel_booking').modal('hide');
                showToast("success", response.message);
                loadBookings(); // Reload the list
            },
            error: function(xhr) {
                var errorMessage = 'An error occurred. Please try again.';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                }
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: errorMessage,
                });
            },
            complete: function() {
                submitButton.prop('disabled', false).text('Yes, Cancel');
                form[0].reset();
            }
        });
    });

    $(document).on('click', '.view-details', function () {
        let orderId = $(this).data('id');

        // Show loader while fetching
        $('#view_details .modal-body').html(`
            <div class="text-center py-5">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
                <p class="mt-2">Fetching order details...</p>
            </div>
        `);

        $('#view_details').modal('show');

        // Fetch details via AJAX
        $.ajax({
            url: '/customer/products/get-booking-details',   // <-- your controller route
            type: 'GET',
            data: { id: orderId },
            success: function (res) {
                // Inject HTML response into modal
                $('#order_id').html(res.order_id);
                $('#view_details .modal-body').html(res.html);
            },
            error: function () {
                $('#view_details .modal-body').html(`
                    <div class="alert alert-danger mb-0">
                        Failed to fetch details. Please try again.
                    </div>
                `);
            }
        });
    });

});
</script>
@endpush