@extends('frontend.theme_2.app')

@section('title', 'Customer Booking Upcoming')

@push('styles')
<link rel="stylesheet" href=" {{ asset('frontend/assets/plugins/daterangepicker/daterangepicker.css') }}">
<link rel="stylesheet" href=" {{ asset('frontend/assets/plugins/datatables/datatables.min.css') }}">
@endpush

@section('content')

<div class="breadcrumb-bar">
    <div class="container">
        <div class="breadcrumb-item">
            <nav aria-label="breadcrumb" class="page-breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-items"><a href="{{ url('/') }}">{{ __('Home') }}</a></li>
                    <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                    <li class="breadcrumb-items active" aria-current="page">{{ __('my_bookings') }}</li>
                </ol>
            </nav>
            <h1 class="breadcrumb-title">{{ __('my_bookings') }}</h1>
        </div>
    </div>
    <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
    <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
    <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
    <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
    <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
</div>
<div class="content">
    <div class="container">

        <div class="row">
            @include('frontend.pages.customer.sidemenu')

            <div class="col-xl-9 col-lg-8">

                <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 border-bottom pb-4 mb-4">
                    <h4 class="mb-0">{{ __('my_completed_bookings') }}</h4>
                    {{-- Filters can be implemented later if needed --}}
                </div>
                <div id="booking-list-container">
                    <div class="spinner-loader"></div>
                </div>

            </div>
        </div>
    </div>
</div>
<div id="cancel_booking" class="modal fade" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <form id="cancelBookingForm">
                    @csrf
                    <input type="hidden" id="booking_id_to_cancel" name="booking_id">
                    <div class="text-center mb-3">
                        <span class="avatar avatar-lg avatar-rounded bg-soft-danger text-danger fs-16 mb-3">
                            <i class="isax isax-close-circle"></i>
                        </span>
                        <h6 class="mb-1">{{ __('cancel_booking') }}</h6>
                        <p class="mb-0">{{__('cancel_booking_confirmation')}}</p>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="cancellation_reason">{{__('reason_for_cancellation')}}</label>
                        <textarea class="form-control" id="cancellation_reason" name="reason" rows="3" required></textarea>
                    </div>
                    <div class="d-flex align-items-center gap-2">
                        <button type="button" class="btn btn-light w-100" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                        <button type="submit" class="btn btn-danger w-100">{{__('Yes, Cancel')}}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Start Add Modal -->
<div id="add_review" class="modal fade">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form id="reviewForm">
                <input type="hidden" id="product_id" name="product_id">
                <div class="modal-header">
                    <h6 class="text-dark modal-title fw-bold">{{__('add_review')}}</h6>
                    <button type="button" class="btn-close btn-close-modal custom-btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="isax isax-close-circle"></i></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('your_ratings') }}</label>
                        <div class="rating star-box ratings_stars">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                    </div>
                    <div class="mb-0">
                        <label class="form-label">{{__('Description')}}<span class="text-danger ms-1">*</span></label>
                        <textarea id="review" name="review" class="form-control fs-14" rows="3"></textarea>
                        <span class="text-danger error-text" id="review_error"></span>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="d-flex align-items-center justify-content-end">
                        <button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                        <button type="submit" class="btn btn-secondary submit-review">{{__('add_review')}}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<div id="view_details" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header d-flex align-items-center justify-content-between">
                <h5 class="modal-title mb-0">{{ __('booking_summary') }}<span class="badge badge-sm badge-soft-purple ms-2" id="order_id"></span></h5>
                <button type="button" class="btn-close custom-btn-close opacity-100 bg-transparent" data-bs-dismiss="modal" aria-label="Close"><i class="isax isax-close-circle"></i></button>
            </div>

            <div class="modal-body">
            </div>
        </div>
    </div>
</div>
<!-- End Add Modal -->

@endsection

@push('scripts')
<script src="{{ asset('assets/plugins/sweetalert/sweetalert2.all.min.js') }}"></script>

<script>
(async function () {
    "use strict";
    await loadTranslationFile();
    $(document).ready(function() {

        // Setup CSRF token for all AJAX requests
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Function to load upcoming bookings
        function loadBookings() {
            const container = $('#booking-list-container');
            container.html('<div class="spinner-loader"></div>'); // Show loader

            $.ajax({
                url: "{{ route('customer.booking.completed.list') }}",
                type: 'POST',
                dataType: 'json',
                success: function(response) {
                    container.empty(); // Clear loader
                    if (response.data && response.data.length > 0) {
                        $.each(response.data, function(index, booking) {
                            let reviewExists = booking.review_exists;
                            var bookingHtml = `
            <!-- booking item -->
            <div class="booking-item">
                <div class="row row-gap-3 align-items-center">
                    <div class="col-xxl-6 col-xl-7">
                        <div class="d-flex align-items-center flex-wrap flex-sm-nowrap gap-2 overflow-hidden">
                            <a href="javascript:void(0);" class="avatar avatar-xxl flex-shrink-0" data-bs-toggle="modal" data-bs-target="#view_details_${booking.id}">
                                <img src="${booking.image_url}" alt="service" class="img-fluid">
                            </a>
                            <div class="flex-grow-1 overflow-hidden">
                                <a href="javascript:void(0);" class="d-block text-secondary fs-14 mb-1">#${booking.order_id}</a>
                                <h6 class="fs-16 fw-semibold text-truncate mb-1">
                                    <a href="/servicedetail/${booking.slug}">${booking.source_name}</a>
                                </h6>
                                <div class="d-flex align-items-center gap-2 flex-wrap item-info">
                                    <p class="d-inline-flex align-items-center mb-0">
                                        <i class="isax isax-category-2 me-1"></i>
                                        Category : ${booking.subcategory_name || 'N/A'}
                                    </p>
                                    <p class="d-inline-flex align-items-center mb-0">
                                        <i class="isax isax-calendar-tick me-1"></i>
                                        Date : ${booking.booking_date_formatted}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-6 col-xl-5">
                        <div class="d-flex align-items-center justify-content-between gap-2">
                            ${!reviewExists ?
                            `<a href="#!"
                               class="fs-14 fw-medium d-inline-flex align-items-center link-body add_review_btn"
                               data-bs-toggle="modal"
                               data-bs-target="#add_review"
                               data-product-id="${booking.product_id}">
                                <i class="isax isax-star-1 me-1"></i>{{__('add_review')}}
                            </a>` : ''
                            }
                            <div class="d-flex align-items-center justify-content-xl-end gap-2">
                                <a href="#!"
                                   class="btn btn-sm btn-white d-inline-flex align-items-center view-details"
                                   data-id="${booking.booking_id}"
                                   data-bs-toggle="modal"
                                   data-bs-target="#view_details">
                                    <i class="isax isax-eye me-1"></i> {{__('Details')}}
                                </a>
                                <a href="/servicedetail/${booking.slug}"
                                   class="btn btn-sm btn-secondary d-inline-flex align-items-center">
                                    <i class="isax isax-calendar-edit me-1"></i> {{__('book_again')}}
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end booking item -->
            `;
                            container.append(bookingHtml);
                        });
                    } else {
                        container.html('<h5 class="text-center my-5">You have no completed bookings.</h5>');
                    }
                },
                error: function(xhr, status, error) {
                    container.html('<div class="alert alert-danger">Failed to load bookings. Please try again later.</div>');
                }
            });
        }


        // Initial load of bookings
        loadBookings();

        // Event delegation for cancel button click
        $(document).on('click', '.cancel-booking-btn', function() {
            var bookingId = $(this).data('booking-id');
            $('#booking_id_to_cancel').val(bookingId);
            $('#cancel_booking').modal('show');
        });

        // Handle the cancellation form submission
        $('#cancelBookingForm').on('submit', function(e) {
            e.preventDefault();
            var form = $(this);
            var formData = form.serialize();
            var submitButton = form.find('button[type="submit"]');

            submitButton.prop('disabled', true).text('Cancelling...');

            $.ajax({
                url: "{{ route('customer.booking.upcoming.cancel') }}",
                type: 'POST',
                data: formData,
                dataType: 'json',
                success: function(response) {
                    $('#cancel_booking').modal('hide');
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: response.message,
                    });
                    loadBookings(); // Reload the list
                },
                error: function(xhr) {
                    var errorMessage = 'An error occurred. Please try again.';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    }
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: errorMessage,
                    });
                },
                complete: function() {
                    submitButton.prop('disabled', false).text('Yes, Cancel');
                    form[0].reset();
                }
            });
        });
        $(document).on('click', '.view-details', function () {
            let orderId = $(this).data('id');

            // Show loader while fetching
            $('#view_details .modal-body').html(`
                <div class="text-center py-5">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <p class="mt-2">Fetching order details...</p>
                </div>
            `);

            $('#view_details').modal('show');

            // Fetch details via AJAX
            $.ajax({
                url: '/customer/products/get-booking-details',   // <-- your controller route
                type: 'GET',
                data: { id: orderId },
                success: function (res) {
                    // Inject HTML response into modal
                    $('#order_id').html(res.order_id);
                    $('#view_details .modal-body').html(res.html);
                },
                error: function () {
                    $('#view_details .modal-body').html(`
                        <div class="alert alert-danger mb-0">
                            Failed to fetch details. Please try again.
                        </div>
                    `);
                }
            });
        });

        $(document).on('click', '.add_review_btn', function () {
            let productId = $(this).data('product-id');
            $('#product_id').val(productId);
        });

        $("#reviewForm").validate({
            rules: {
                review: {
                    required: true,
                    minlength: 10,
                },
            },
            messages: {
                review: {
                    required: _l("review_required"),
                    minlength: _l("review_minlength"),
                },
            },
            errorPlacement: function (error, element) {
                var errorId = element.attr("id") + "_error";
                if (element.hasClass("select2-hidden-accessible")) {
                    $("#" + errorId).text(error.text());
                } else {
                    $("#" + errorId).text(error.text());
                }
            },
            highlight: function (element) {
                if ($(element).hasClass("select2-hidden-accessible")) {
                    $(element).next(".select2-container").addClass("is-invalid").removeClass("is-valid");
                }
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function (element) {
                if ($(element).hasClass("select2-hidden-accessible")) {
                    $(element).next(".select2-container").removeClass("is-invalid").addClass("is-valid");
                }
                $(element).removeClass("is-invalid").addClass("is-valid");
                var errorId = element.id + "_error";
                $("#" + errorId).text("");
            },
            onkeyup: function (element) {
                $(element).valid();
            },
            onchange: function (element) {
                $(element).valid();
            },
            submitHandler: function () {
                let formData = new FormData();
                formData.append("review", $("#review").val());
                formData.append("rating", $(".ratings_stars i.filled").length);
                formData.append("product_id", $("#product_id").val());
                formData.append("type", "service");

                $.ajax({
                    type: "POST",
                    url: "/customer/store-review",
                    data: formData,
                    processData: false,
                    contentType: false,
                    headers: {
                        Accept: "application/json",
                        "X-CSRF-TOKEN": $("meta[name=\"csrf-token\"]").attr("content"),
                    },
                    beforeSend: function () {
                        $(".submit-review").attr("disabled", true).html(`
                            <span class="spinner-border spinner-border-sm align-middle me-1" role="status" aria-hidden="true"></span> ${_l("submitting")}
                        `);
                    },
                    success: function (resp) {
                        $("#reviewForm")[0].reset();
                        $(".error-text").text("");
                        $(".form-control").removeClass("is-invalid is-valid");
                        $(".submit-review").removeAttr("disabled").html(_l("add_review"));
                        if (resp.code === 200) {
                            showToast("success", resp.message);
                            $("#add_review").modal("hide");
                            loadBookings();
                        }
                    },
                    error: function (error) {
                        $(".error-text").text("");
                        $(".form-control").removeClass("is-invalid is-valid");
                        $(".submit-review").removeAttr("disabled").html(_l("add_review"));
                        if (error.responseJSON.code === 422) {
                            $.each(
                                error.responseJSON.errors,
                                function (key, val) {
                                    $("#" + key).addClass("is-invalid");
                                    $("#" + key + "_error").text(val[0]);
                                }
                            );
                        } else {
                            showToast("error", error.responseJSON.message);
                        }
                    },
                });
            },
        });
    });
}) ();
</script>
@endpush