@extends('frontend.theme_2.app')

@section('title', __('my_cancelled_bookings') . ' || ' . $companyName)

@section('content')

<div class="breadcrumb-bar">
    <div class="container">
        <div class="breadcrumb-item">
            <nav aria-label="breadcrumb" class="page-breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-items"><a href="{{ url('/') }}">{{ __('Home') }}</a></li>
                    <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                    <li class="breadcrumb-items active" aria-current="page">{{ __('my_bookings') }}</li>
                </ol>
            </nav>
            <h1 class="breadcrumb-title">{{ __('my_bookings') }}</h1>
        </div>
    </div>
    <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
    <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
    <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
    <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
    <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
</div>
<div class="content">
    <div class="container">

        <div class="row">
            @include('frontend.pages.customer.sidemenu')

            <div class="col-xl-9 col-lg-8">

                <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 border-bottom pb-4 mb-4">
                    <h4 class="mb-0">{{ __('my_cancelled_bookings') }}</h4>
                    {{-- Filters can be implemented later if needed --}}
                </div>
                <div id="booking-list-container">
                    <div class="spinner-loader"></div>
                </div>

            </div>
        </div>
    </div>
</div>
<div id="refund_booking" class="modal fade" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <form id="cancelBookingForm">
                    @csrf
                    <input type="hidden" id="booking_id_to_refund" name="booking_id">
                    <div class="text-center mb-3">
                        <span class="avatar avatar-lg avatar-rounded bg-soft-danger text-danger fs-16 mb-3">
                            <i class="isax isax-close-circle"></i>
                        </span>
                        <h6 class="mb-1">{{ __('initial_refund') }}</h6>
                        <p class="mb-0">{{__('refund_confirmation')}}</p>
                    </div>
                    <div class="d-flex align-items-center gap-2">
                        <button type="button" class="btn btn-light w-100" data-bs-dismiss="modal">{{__('Close')}}</button>
                        <button type="submit" class="btn btn-danger w-100">{{__('Yes')}}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script src=" {{ asset('frontend/assets/js/custom/customer-booking-cencelled.js') }}"></script>
@endpush