@extends('frontend.theme_2.app')

@section('title', __('Change Password'))

@push('styles')
    <!-- Mobile CSS-->
    <link rel="stylesheet" href="{{ asset('front/plugins/intltelinput/css/intlTelInput.css') }}">    
@endpush

@section('content')

<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('Change Password') }}</li>
                    </ol>
                </nav>	
                <h1 class="breadcrumb-title">{{ __('Change Password') }}</h1>
            </div>
        </div>
        <img src="{{ asset('frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <!-- Start Content -->
    <div class="content">
        <div class="container">
            <!-- start row -->
            <div class="row">
                @include('frontend.pages.customer.sidemenu')
                <div class="col-xl-9 col-lg-8">
                    <div>
                        <h4 class="mb-0">{{__('Change Password')}}</h4>
                    </div>
                    <hr>
                    <div class="card shadow-sm mb-0">
                        <form id="changePasswordForm" autocomplete="off">
                            <input type="hidden" name="id" id="id" value="{{ auth()->id() ?? '' }}">
                            <div class="card-body">
                                <!-- start row -->
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="current_password" class="form-label">{{__('Current Password')}}</label>
                                            <div class="input-group input-group-flat pass-group">
                                                <span class="input-group-text">
                                                    <i class="isax isax-lock text-dark"></i>
                                                </span>
                                                <input type="password" class="form-control pass-input" name="current_password" id="current_password" placeholder="**********">
                                                <span class="input-group-text toggle-password ">
                                                    <i class="isax isax-eye-slash text-dark"></i>
                                                </span>
                                            </div>
                                            <span class="text-danger error-text" id="current_password_error"></span>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="new_password" class="form-label">{{__('New Password')}}</label>
                                            <div class="input-group input-group-flat pass-group">
                                                <span class="input-group-text">
                                                    <i class="isax isax-lock text-dark"></i>
                                                </span>
                                                <input type="password" class="form-control pass-input" name="new_password" id="new_password" placeholder="**********">
                                                <span class="input-group-text toggle-password ">
                                                    <i class="isax isax-eye-slash text-dark"></i>
                                                </span>
                                            </div>
                                            <span class="text-danger error-text" id="new_password_error"></span>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="confirm_password" class="form-label">{{__('Confirm Password')}}</label>
                                            <div class="input-group input-group-flat pass-group">
                                                <span class="input-group-text">
                                                    <i class="isax isax-lock text-dark"></i>
                                                </span>
                                                <input type="password" class="form-control pass-input" name="confirm_password" id="confirm_password" placeholder="**********">
                                                <span class="input-group-text toggle-password ">
                                                    <i class="isax isax-eye-slash text-dark"></i>
                                                </span>
                                            </div>
                                            <span class="text-danger error-text" id="confirm_password_error"></span>
                                        </div>
                                    </div>
                                </div>
                                <!-- end row -->
                                    <hr>
                                <div class="d-flex align-items-center justify-content-end">
                                    <button type="submit" id="change_password" class="btn btn-secondary">{{__('save_changes') }}</a>
                                </div>
                            </div><!-- end card body -->
                        </form>
                    </div><!-- end card -->
                </div>
            </div>
        </div>
    </div>
    <!-- End Content -->
</div>

@endsection

@push('scripts')
    <script src="{{ asset('frontend/assets/js/custom/change-password.js') }}"></script>
@endpush