{{-- Product Info --}}
<div class="card mb-3">
    <div class="card-body">
        <div class="d-flex align-items-center justify-content-between gap-3 mb-3">
            <h6 class="mb-0">{{ __('service_details') }}</h6>
            <span class="badge badge-sm badge-soft-purple">{{ ucfirst($bookingDetails['booking']->status) }}</span>
        </div>

        <div class="d-flex align-items-center flex-wrap flex-sm-nowrap gap-2 overflow-hidden">
            <a href="javascript:void(0);" class="avatar avatar-xxl flex-shrink-0">
                <img src="{{ $bookingDetails['product']->image_url ?? asset('img/default-image.png') }}" alt="service" class="img-fluid">
            </a>
            <div class="flex-grow-1 overflow-hidden">
                <a href="javascript:void(0);" class="d-block text-secondary fs-14 mb-1">#{{ $bookingDetails['booking']->order_id ?? $bookingDetails['booking']->id }}</a>
                <h6 class="fs-16 fw-semibold text-truncate mb-1">
                    <a href="javascript:void(0);">{{ $bookingDetails['product']->source_name ?? 'N/A' }}</a>
                </h6>
                <div class="d-flex align-items-center gap-2 flex-wrap item-info">
                    <p class="fs-14 d-inline-flex align-items-center mb-0">{{ __('category') }} : {{ $bookingDetails['product']->subcategory_name ?? 'N/A' }}</p>
                    <p class="fs-14 d-inline-flex align-items-center mb-0">{{ __('date') }} : {{ date('l, d M Y, h:i A', strtotime($bookingDetails['booking']->booking_date)) }}</p>
                </div>
            </div>
        </div>
    </div>
</div> <!-- end card -->

{{-- Service Provider Details --}}
<div class="card mb-3">
    <div class="card-body">
        <div class="mb-3">
            <h6 class="mb-0">{{ __('provider_details') }}</h6>
        </div>
        <div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap gap-2 bg-light p-3 rounded mb-3">
            <div class="d-flex align-items-center flex-wrap flex-sm-nowrap gap-2 overflow-hidden">
                <a href="javascript:void(0);" class="avatar avatar-xl flex-shrink-0">
                    <img src="{{ getProfileImage() }}" alt="provider" class="rounded-circle img-fluid">
                </a>
                <div class="flex-grow-1 overflow-hidden">
                    <h6 class="fs-16 fw-semibold text-truncate mb-1">
                        <a href="javascript:void(0);">{{ $bookingDetails['provider']->name ?? 'N/A' }}</a>
                    </h6>
                </div>
            </div>
            <span class="badge badge-sm bg-success">
                <i class="isax isax-shield-tick me-1"></i>{{ __('verified') }}
            </span>
        </div>

        <!-- start row-->
        <div class="row row-gap-4">
            <div class="col-xl-4 col-lg-6">
                <div class="d-flex align-items-center">
                    <span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
                        <i class="isax isax-sms"></i>
                    </span>
                    <div>
                        <h6 class="fs-14 fw-semibold mb-1">{{ __('email') }}</h6>
                        <p class="mb-0">{{ $bookingDetails['provider']->email ?? 'N/A' }}</p>
                    </div>
                </div>
            </div> <!-- end col -->

            <div class="col-xl-4 col-lg-6">
                <div class="d-flex align-items-center">
                    <span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
                        <i class="isax isax-call"></i>
                    </span>
                    <div>
                        <h6 class="fs-14 fw-semibold mb-1">{{ __('phone') }}</h6>
                        <p class="mb-0">{{ $bookingDetails['provider']->phone_number ?? 'N/A' }}</p>
                    </div>
                </div>
            </div> <!-- end col -->

            <div class="col-xl-4 col-lg-6">
                <div class="d-flex align-items-center">
                    <span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
                        <i class="isax isax-calendar-2"></i>
                    </span>
                    <div>
                        <h6 class="fs-14 fw-semibold mb-1">{{ __('member_since') }}</h6>
                        <p class="mb-0">{{ isset($bookingDetails['provider']->created_at) ? date('d M Y', strtotime($bookingDetails['provider']->created_at)) : 'N/A' }}</p>
                    </div>
                </div>
            </div> <!-- end col -->
        </div>
        <!-- end row-->
    </div>
</div> <!-- end card -->

{{-- Additional Service (if exists) --}}
@if(isset($bookingDetails['booking']->additional_services) && $bookingDetails['booking']->additional_services)
<div class="card mb-3">
    <div class="card-body">
        <div class="mb-3">
            <h6 class="mb-0">{{ __('additional_service') }}</h6>
        </div>
        <div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap gap-2 rounded">
            <div class="d-flex align-items-center flex-wrap flex-sm-nowrap gap-2 overflow-hidden">
                <a href="javascript:void(0);" class="avatar avatar-lg flex-shrink-0">
                    <img src="{{ asset('img/default-service.png') }}" alt="service">
                </a>
                <div class="flex-grow-1 overflow-hidden">
                    <h6 class="fs-16 fw-semibold text-truncate mb-1">
                        <a href="javascript:void(0);">{{ $bookingDetails['booking']->additional_services }}</a>
                    </h6>
                    <p class="fs-14 mb-0">{{ __('additional_services') }}</p>
                </div>
            </div>
            <h6 class="fs-16 fw-semibold mb-0">${{ $bookingDetails['booking']->additional_amount ?? '0' }}</h6>
        </div>
    </div>
</div> <!-- end card -->
@endif

{{-- Payment Details --}}
<div class="card mb-0">
    <div class="card-body">
        <div class="mb-3">
            <h6 class="mb-0">{{ __('payment_details') }}</h6>
        </div>

        <!-- start row-->
        <div class="row row-gap-4">
            <div class="col-lg-4 col-sm-6">
                <div class="d-flex align-items-center">
                    <span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
                        <i class="isax isax-receipt-text"></i>
                    </span>
                    <div>
                        <h6 class="fs-14 fw-semibold mb-1">{{ __('transaction_id') }}</h6>
                        <p class="mb-0">#{{ $bookingDetails['booking']->transaction_id ?? 'TNX' . $bookingDetails['booking']->id }}</p>
                    </div>
                </div>
            </div> <!-- end col -->

            <div class="col-lg-4 col-sm-6">
                <div class="d-flex align-items-center">
                    <span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
                        <i class="isax isax-cards"></i>
                    </span>
                    <div>
                        <h6 class="fs-14 fw-semibold mb-1">{{ __('payment_method') }}</h6>
                        <p class="mb-0">{{ $bookingDetails['payment_type'] }}</p>
                    </div>
                </div>
            </div> <!-- end col -->

            <div class="col-lg-4 col-sm-6">
                <div class="d-flex align-items-center">
                    <span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
                        <i class="isax isax-calendar"></i>
                    </span>
                    <div>
                        <h6 class="fs-14 fw-semibold mb-1">{{ __('date_of_payment') }}</h6>
                        <p class="mb-0">{{ date('d M Y, h:i A', strtotime($bookingDetails['booking']->created_at)) }}</p>
                    </div>
                </div>
            </div> <!-- end col -->

            <div class="col-lg-4 col-sm-6">
                <div class="d-flex align-items-center">
                    <span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
                        <i class="isax isax-percentage-square"></i>
                    </span>
                    <div>
                        <h6 class="fs-14 fw-semibold mb-1">{{ __('Tax') }}</h6>
                        <p class="mb-0">{{ getDefaultCurrencySymbol() }}{{ $bookingDetails['booking']->amount_tax ?? '0' }}</p>
                    </div>
                </div>
            </div> <!-- end col -->

            <div class="col-lg-4 col-sm-6">
                <div class="d-flex align-items-center">
                    <span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
                        <i class="isax isax-discount-circle"></i>
                    </span>
                    <div>
                        <h6 class="fs-14 fw-semibold mb-1">{{ __('discount') }}</h6>
                        <p class="mb-0">-{{ getDefaultCurrencySymbol() }}{{ $bookingDetails['booking']->discount_amount ?? '0.00' }}</p>
                    </div>
                </div>
            </div> <!-- end col -->

            <div class="col-lg-4 col-sm-6">
                <div class="d-flex align-items-center">
                    <span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
                        <i class="isax isax-wallet-2"></i>
                    </span>
                    <div>
                        <h6 class="fs-14 fw-semibold mb-1">{{ __('booking_fees') }}</h6>
                        <p class="mb-0">{{ getDefaultCurrencySymbol() }}{{ $bookingDetails['booking']->service_amount ?? '0' }}</p>
                    </div>
                </div>
            </div> <!-- end col -->

            <div class="col-lg-4 col-sm-6">
                <div class="d-flex align-items-center">
                    <span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
                        <i class="isax isax-activity"></i>
                    </span>
                    <div>
                        <h6 class="fs-14 fw-semibold mb-1">{{ __('payment_status') }}</h6>
                        <p class="mb-0">
                            <span class="badge badge-sm {{ $bookingDetails['payment_status'] == 'Paid' ? 'bg-success' : ($bookingDetails['payment_status'] == 'Refund' ? 'bg-warning' : 'bg-danger') }}">
                                {{ $bookingDetails['payment_status'] }}
                            </span>
                        </p>
                    </div>
                </div>
            </div> <!-- end col -->

            <div class="col-lg-4 col-sm-6">
                <div class="d-flex align-items-center">
                    <span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
                        <i class="isax isax-receipt-discount"></i>
                    </span>
                    <div>
                        <h6 class="fs-14 fw-semibold mb-1">{{ __('Total') }}</h6>
                        <p class="mb-0">{{ getDefaultCurrencySymbol() }}{{ $bookingDetails['booking']->total_amount ?? '0' }}</p>
                    </div>
                </div>
            </div>
        <!-- end col -->
     @if (!empty($bookingDetails['booking']->notes))
        <div class="row">
            <div class="col-lg-12 col-sm-6">
                <div class="d-flex align-items-start">
                    <span class="avatar avatar-md bg-light flex-shrink-0 text-dark fs-16 me-2">
                        <i class="isax isax-note-2"></i>
                    </span>
                    <div class="w-100">
                        <h6 class="fs-14 fw-semibold mb-1">{{ __('notes') }}</h6>
                        <textarea class="form-control" rows="3" readonly>{{ $bookingDetails['booking']->notes ?? '-' }}</textarea>
                    </div>
                </div>
            </div>
    @endif
        </div>
        </div>
        <!-- end row-->
    </div>
</div> <!-- end card -->