@extends('frontend.theme_2.app')

@section('title', __('billing_address') . ' || ' . $companyName)

@push('styles')
    <!-- Mobile CSS-->
    <link rel="stylesheet" href="{{ asset('front/plugins/intltelinput/css/intlTelInput.css') }}">    
@endpush

@section('content')

<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('billing_address') }}</li>
                    </ol>
                </nav>	
                <h1 class="breadcrumb-title">{{ __('billing_address') }}</h1>
            </div>
        </div>
        <img src="{{ asset('frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <!-- Start Content -->
    <div class="content">
        <div class="container">
            <!-- start row -->
            <div class="row">
                @include('frontend.pages.customer.sidemenu')
                <div class="col-xl-9 col-lg-8">
                    <div class="d-flex align-items-center justify-content-between">
                        <h4 class="mb-0">{{__('billing_address')}}</h4>
                        <a href="javascript:void(0);" class="btn btn-md btn-secondary d-inline-flex align-items-center" id="add_address"><i class="isax isax-add-circle me-1"></i>{{ __('add_address') }}</a>
                    </div>
                    <hr>
                    
                    <div class="card shadow-sm mb-0">
                        <div class="card-body" id="billing_address_wrapper">
                            <div class="spinner-loader"></div>
                        </div><!-- end card body -->
                    </div><!-- end card -->
                </div>
            </div>
        </div>
    </div>
    <!-- End Content -->
</div>

<!-- Start Add/Edit Modal -->
<div id="billing_address_modal" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('add_billing_address') }}</h5>
                <button type="button" class="btn-close btn-close-modal custom-btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="isax isax-close-circle"></i></button>
            </div>
            <form id="billingAddressForm">
                <input type="hidden" name="id" id="id">
                <div class="modal-body p-4">
                    <!-- start row -->
                    <div class="row row-gap-3">
                        <div class="col-md-12">
                            <div class="mb-0">
                                <label class="form-label">{{ __('name') }}<span class="text-danger ms-1">*</span></label>
                                <input type="text" class="form-control" name="name" id="name">
                                <span class="text-danger error-text" id="name_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('email') }}<span class="text-danger ms-1">*</span></label>
                                <input type="text" class="form-control" name="email" id="email">
                                <span class="text-danger error-text" id="email_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('phone_number') }}<span class="text-danger ms-1">*</span></label>
                                <input type="text" class="form-control phone_number" name="phone_number" id="phone_number">
                                <input type="hidden" class="form-control international_phone_number" name="international_phone_number" id="international_phone_number">
                                <span class="text-danger error-text" id="phone_number_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('address_line_1') }}<span class="text-danger ms-1">*</span></label>
                                <input type="text" class="form-control" name="address_line_one" id="address_line_one">
                                <span class="text-danger error-text" id="address_line_one_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('address_line_2') }}</label>
                                <input type="text" class="form-control" name="address_line_two" id="address_line_two">
                                <span class="text-danger error-text" id="address_line_two_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('country') }}<span class="text-danger ms-1">*</span></label>
                                <select class="form-control select2" name="country_id" id="country_id">
                                    <option value="">{{ __('Select') }}</option>
                                    @if ($countries)
                                        @foreach ($countries as $country)
                                            <option value="{{ $country->id }}">{{ $country->name }}</option>
                                        @endforeach
                                    @endif
                                </select>
                                <span class="text-danger error-text" id="country_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('state') }}<span class="text-danger ms-1">*</span></label>
                                <select class="form-control select2" name="state_id" id="state_id">
                                </select>
                                <span class="text-danger error-text" id="state_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('city') }}<span class="text-danger ms-1">*</span></label>
                                <select class="form-control select2" name="city_id" id="city_id">
                                </select>
                                <span class="text-danger error-text" id="city_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('ZIP Code') }}<span class="text-danger ms-1">*</span></label>
                                <input type="text" class="form-control" name="zipcode" id="zipcode">
                                <span class="text-danger error-text" id="zipcode_error"></span>
                            </div>
                        </div><!-- end col -->
                    </div>
                    <!-- end row -->
                </div>
                <div class="modal-footer d-flex align-items-center justify-content-between gap-1">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="" name="is_default" id="is_default">
                        <label class="form-check-label" for="is_default">{{ __('mark_as_default') }}</label>
                    </div>
                    <div>
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                        <button type="submit" class="btn btn-secondary submitbtn">{{ __('add_address') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- End Add/Edit Modal -->

<!-- Start Delete Modal  -->
<div class="modal fade" id="delete_address_modal">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-body text-center position-relative z-1 p-0">
                <form id="deleteBillingAddressForm">
                    <input type="hidden" name="delete_id" id="delete_id">
                    <div class="modal-body">
                        <div class="d-flex align-items-center justify-content-center">
                            <span class="delete-icon rounded-circle mb-3"><i class="isax isax-trash fs-16"></i></span>
                        </div>
                        <div class="text-center">
                            <h6 class="mb-1">{{ __('Are you Sure') }}</h6>
                            <p class="mb-3">{{ __('billing_address_delete_confirm') }}</p>
                        </div>
                        <div class="d-flex align-items-center justify-content-center">
                            <button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                            <button type="submit" class="btn btn-danger">{{ __('Delete') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- End Delete Modal  -->

@endsection

@push('plugins')
    <!-- Mobile Input -->
    <script src="{{ asset('front/plugins/intltelinput/js/intlTelInput.js') }}"></script>
@endpush

@push('scripts')
    <script src="{{ asset('frontend/assets/js/custom/billing-address.js') }}"></script>
@endpush