@extends('frontend.theme_2.app')

@section('title', __('account_settings') . ' || ' . $companyName)

@section('content')

<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('billing_address') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{ __('billing_address') }}</h1>
            </div>
        </div>
        <img src="{{ asset('frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <!-- Start Content -->
    <div class="content">
        <div class="container">
            <!-- start row -->
            <div class="row">
                @include('frontend.pages.customer.sidemenu')
                <div class="col-xl-9 col-lg-8">
                    <div class="d-flex align-items-center justify-content-between">
                        <h4 class="mb-0">{{__('account_settings')}}</h4>
                    </div>
                    <hr>
                    <!-- Account Settings -->
                    <!-- Paypal -->
                    <div class="card mb-3">
                        <div class="card-header bg-light ms-0 me-0 p-3">
                            <div class="d-flex align-items-center">
                                <h6 class="mb-0">{{ __('paypal') }}</h6>
                                <div class="d-flex align-items-center ms-auto">
                                    <div class="mb-0 form-label">{{ __('set_as_default') }}</div>
                                    <label class="d-flex align-items-center form-switch ps-3" for="bank_default_status">
                                        <input type="checkbox" id="paypal_default_status" class="form-check-input m-0 me-2 default_status" data-type="paypal" {{ (isset($accountSettings['default_type']) && $accountSettings['default_type'] === 'paypal') ? 'checked disabled' : '' }}>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <form id="paypalForm" autocomplete="off">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-wrap">
                                            <label class="form-label" for="paypal_email"> {{ __('Id') }} <span class="text-primary">*</span></label>
                                            <input type="text" class="form-control" name="paypal_id" id="paypal_id" value="{{ $accountSettings['paypal']['paypal_id'] ?? ''}}" maxlength="100">
                                            <span id="paypal_id_error" class="text-danger error-text"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-3">
                                    <button type="submit"
                                        class="btn btn-dark text-white paypal_savebtn">{{ __('save_changes') }}
                                        <i class="ti ti-arrow-up-right"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /Paypal -->

                    <!-- Stripe Transfer -->
                    <div class="card mb-3">
                        <div class="card-header bg-light ms-0 me-0 p-3">
                            <div class="d-flex align-items-center">
                                <h6 class="mb-0">{{ __('stripe') }}</h6>
                                <div class="d-flex align-items-center ms-auto">
                                    <div class="mb-0 form-label">{{ __('set_as_default') }}</div>
                                    <label class="d-flex align-items-center form-switch ps-3" for="bank_default_status">
                                        <input type="checkbox" id="stripe_default_status" class="form-check-input m-0 me-2 default_status" data-type="stripe" {{ (isset($accountSettings['default_type']) && $accountSettings['default_type'] === 'stripe') ? 'checked disabled' : '' }}>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <form id="stripeForm">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-wrap">
                                            <label class="form-label" for="stripe_email"> {{ __('Id') }} <span class="text-primary">*</span></label>
                                            <input type="text" class="form-control" name="stripe_id" id="stripe_id" value="{{ $accountSettings['stripe']['stripe_id'] ?? ''}}" maxlength="100">
                                            <span id="stripe_id_error" class="text-danger error-text"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-3">
                                    <button type="submit"
                                        class="btn btn-dark text-white stripe_savebtn">{{ __('save_changes') }}
                                        <i class="ti ti-arrow-up-right ms-1"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /Stripe Transfer -->

                    <!-- Bank Transfer -->
                    <div class="card mb-3">
                        <div class="card-header bg-light ms-0 me-0 p-3">
                            <div class="d-flex align-items-center">
                                <h6 class="mb-0">{{ __('bank_transfer') }}</h6>
                                <div class="d-flex align-items-center ms-auto">
                                    <div class="mb-0 form-label">{{ __('set_as_default') }}</div>
                                    <label class="d-flex align-items-center form-switch ps-3" for="bank_default_status">
                                        <input type="checkbox" id="bank_default_status" class="form-check-input m-0 me-2 default_status" data-type="bank_transfer" {{ (isset($accountSettings['default_type']) && $accountSettings['default_type'] === 'bank_transfer') ? 'checked disabled' : '' }}>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <form id="bankForm" autocomplete="off">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <div class="form-wrap">
                                            <label class="form-label" for="account_holder_name"> {{ __('Account Holder Name') }}
                                            </label>
                                            <input type="text" class="form-control" name="account_holder_name"
                                                id="account_holder_name"
                                                value="{{ $accountSettings['bank_transfer']['account_holder_name'] ?? ''}}">
                                            <span id="account_holder_name_error"
                                                class="text-danger error-text"></span>
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <div class="form-wrap">
                                            <label class="form-label" for="bank_name"> {{ __('bank_name') }} </label>
                                            <input type="text" class="form-control" name="bank_name"
                                                id="bank_name"
                                                value="{{ $accountSettings['bank_transfer']['bank_name'] ?? ''}}">
                                            <span id="bank_name_error" class="text-danger error-text"></span>
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <div class="form-wrap">
                                            <label class="form-label" for="ifsc_code"> {{ __('IFSC Code') }} </label>
                                            <input type="text" class="form-control" name="ifsc_code"
                                                id="ifsc_code"
                                                value="{{ $accountSettings['bank_transfer']['ifsc_code'] ?? ''}}">
                                            <span id="ifsc_code_error" class="text-danger error-text"></span>
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-0">
                                        <div class="form-wrap">
                                            <label class="form-label" for="account_number"> {{ __('account_number') }}
                                            </label>
                                            <input type="text" class="form-control" name="account_number"
                                                id="account_number"
                                                value="{{ $accountSettings['bank_transfer']['account_number'] ?? ''}}">
                                            <span id="account_number_error"
                                                class="text-danger error-text"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-3">
                                    <button type="submit"
                                        class="btn btn-dark text-white bank_savebtn">{{ __('save_changes') }}
                                        <i class="ti ti-arrow-up-right ms-1"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /Bank Transfer -->
                    <!-- /Account Settings  -->
                </div>
            </div>
        </div>
    </div>
    <!-- End Content -->
</div>

@endsection

@push('scripts')
    <script src="{{ asset('frontend/assets/js/custom/account-settings.js') }}"></script>
@endpush