<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>

	<!-- Meta Tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{ __('login') . ' || ' . $companyName }}</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="">
	<meta name="keywords" content="">
	<meta name="author" content="Dreams Technologies">

    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ $dynamicFavicon }}">

    <!-- Apple Icon -->
    <link rel="apple-touch-icon" href="{{ $dynamicFavicon }}">

    @php
        $isRTL = isRTL(app()->getLocale());
    @endphp

    @if ($isRTL)
        <!-- Bootstrap CSS -->
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/bootstrap.rtl.min.css') }}">
    @else
        <!-- Bootstrap CSS -->
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/bootstrap.min.css') }}">
    @endif
    <!-- Iconsax CSS -->
    <link rel="stylesheet" href="{{ asset('frontend/assets/plugins/iconsax/iconsax.css') }}">

    <!-- Fontawesome CSS -->
    <link rel="stylesheet" href="{{ asset('frontend/assets/plugins/fontawesome/css/all.min.css') }}">

    @if ($isRTL)
        <!-- Main RTL CSS -->
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/style-rtl.css') }}">
    @else
        <!-- Main CSS -->
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/style.css') }}">
    @endif

    <!-- Custom Style CSS -->
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/custom/custom-style.css') }}">

</head>

<body>
	<!-- Begin Wrapper -->
	<div class="main-wrapper">

        <!-- Start Content -->
		<div class="container-fuild">
			<div class="w-100 overflow-hidden position-relative flex-wrap d-block vh-100 login-wrap py-4">

				<!-- start row -->
				<div class="row justify-content-center align-items-center vh-100 overflow-auto flex-wrap">

					<div class="col-md-8 col-lg-6 col-xl-4 mx-auto">
						<form action="javascript:void(0);" id="userLoginForm" class="d-flex justify-content-center align-items-center" autocomplete="off">
							<div class="d-flex flex-column justify-content-center p-4 flex-fill bg-light border mb-4">
								<div class="login-logo mx-auto text-center">
									<a href="{{ route('home') }}">
										<img src="{{ $dynamicLogo }}" class="img-fluid" alt="Logo">
									</a>
								</div>
								<div>
									<div class="text-center">
										<h4>{{ __('welcome_back') }}</h4>
									</div>
									<div class="mb-3">
										<label class="form-label">{{ __('email') }} <span class="text-danger">*</span></label>
										<div class="input-group input-group-flat">
											<span class="input-group-text">
												<i class="isax isax-sms text-dark"></i>
											</span>
											<input type="email" name="email" id="email" class="form-control" placeholder="{{ __('enter_email_address') }}" autocomplete="off" readonly onfocus="this.removeAttribute('readonly');">
										</div>
										<span id="email_error" class="text-danger error-text"></span>
									</div>
                                    @if ($otpStatus == 1)
                                    <div class="d-flex align-items-center justify-content-end flex-wrap gap-2">
                                        <div class="text-end">
                                            <a href="javascript:void(0);" class="text-danger" id="login_otp">{{ __('login_with_otp') }}</a>
                                        </div>
                                    </div>
                                    @endif
									<div class="mb-3">
										<label class="form-label">{{ __('password') }} <span class="text-danger">*</span></label>
										<div class="input-group input-group-flat pass-group">
											<span class="input-group-text">
												<i class="isax isax-lock text-dark"></i>
											</span>
											<input type="password" name="password" id="password" class="form-control pass-input" placeholder="**********">
											<span class="input-group-text toggle-password">
												<i class="isax isax-eye-slash text-dark"></i>
											</span>
										</div>
										<span id="password_error" class="text-danger error-text"></span>
									</div>
                                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-4">
                                        <div class="d-flex align-items-center">
                                            <div class="form-check form-check-md mb-0">
                                                <input class="form-check-input" id="remember_me" type="checkbox" name="remember">
                                                <label for="remember_me" class="form-check-label mt-0 text">{{ __('remember_me') }}</label>
                                            </div>
                                        </div>
                                        <div>
                                            <a href="/user/forgot-password" class="text-danger">{{ __('forgot_password') }}</a>
                                        </div>
                                    </div>
									<div class="mb-3">
										<button type="submit" class="btn btn-secondary w-100" id="signin">{{ __('signin') }}</button>
									</div>

									<div class="text-center">
										<p class="mb-0 pt-1"><a href="/user/register" class="link-secondary">{{ __('signup') }}</a></p>
									</div>

								</div>
							</div>
						</form>

					</div><!-- end col -->

				</div>
				<!-- end row -->

			</div>
		</div>
		<!-- End Content -->

		@include('frontend.toast')

		<div class="modal fade" id="otp-email-modal" tabindex="-1" data-bs-backdrop="static" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header d-flex align-items-center justify-content-end pb-0 border-0">
                        <button type="button" data-bs-dismiss="modal" aria-label="Close" id="close-otp-modal" class="btn p-0 border-0 bg-transparent">
                            <i class="ti ti-circle-x-filled fs-20"></i>
                        </button>
                    </div>
                    <div class="modal-body p-4">
                        <form action="#" class="digit-group">
                            <div class="text-center mb-3">
                                <h3 class="mb-2">{{ __('email_otp_verification') }}</h3>
                                <p id="otp-email-message" class="fs-14">{{ __('otp_sent_to_email') }}</p>
                            </div>
                            <div class="text-center otp-input">
                                <div class="inputcontainer"></div>
                                <span id="error_message" class="text-danger"></span>
                                <div>
                                    <div class="badge bg-danger-transparent mb-3">
                                        <p class="d-flex align-items-center">
                                            <i class="ti ti-clock me-1"></i>
                                            <span id="otp-timer">00:00</span>
                                        </p>
                                    </div>
                                    <div class="mb-3 d-flex justify-content-center">
                                        <p>{{ __('didnt_get_otp') }}
                                            <button type="button" class="resendEmailOtpForgot btn btn-link text-primary p-0">
                                                {{ __('resend_otp') }}
                                            </button>
                                        </p>
                                    </div>
                                    <div>
                                        <button type="button" id="verify-email-forgot-otp-btn" class="verify-email-otp-btn btn btn-lg btn-primary w-100">
                                            {{ __('verify_proceed') }}
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>
	<!-- End Wrapper -->

    <!-- jQuery -->
    <script src="{{ asset('frontend/assets/js/jquery-3.7.1.min.js') }}"></script>

    <!-- Bootstrap Core JS -->
    <script src="{{ asset('frontend/assets/js/bootstrap.bundle.min.js') }}"></script>

    @stack('plugins')

    @if ($isRTL)
        <script src="{{ asset('frontend/assets/js/script-rtl.js') }}"></script>
    @else
        <script src="{{ asset('frontend/assets/js/script.js') }}"></script>
    @endif

    <!-- jQuery validation -->
    <script src="{{ asset('frontend/assets/js/jquery/jquery-validation.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/jquery/jquery-validation-additional-methods.min.js') }}"></script>

    <!-- Main JS -->
    <script src="{{ asset('frontend/assets/js/lang_script.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/custom/custom-script.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/custom/login.js') }}"></script>

</body>

</html>