
<!-- Service Section -->
<section class="service-section section position-relative trendingServiceSection">
    <div class="container">
        <!-- Section Header -->
        <div class="section-header d-flex align-items-center justify-content-between flex-wrap gap-3 aos" data-aos="fade-down">
            <div>
                <h2 class="title">{!! ucfirst($section['section_title'] ?? "") !!}</h2>
                <p>{{ ucfirst($section['section_label'] ?? "") }}</p>
            </div>
            <a href="{{ route('servicelists') }}" class="btn btn-white box-hover d-inline-flex align-items-center">{{__('view_all')}}<i class="isax isax-arrow-right-3 ms-1"></i></a>
        </div>
        <!-- Section Header End -->

        <!-- start row -->
        <div class="row row-gap-4 justify-content-center">
            @if(!empty($section['section_content']) && count($section['section_content']) > 0)
                @foreach($section['section_content'] as $service_key => $service_value)
                    <div class="col-xl-4 col-lg-6 col-md-6 d-flex">
                        <div class="service-item flex-fill mb-0">
                            <div class="service-img position-relative overflow-hidden">
                                <a href="{{ url('servicedetail/' . $service_value->slug) }}">
                                    <img class="img-fluid" src="{{ $service_value->product_images }}" alt="service">
                                </a>
                                <div class="badge-item w-100 d-flex align-items-center justify-content-end position-absolute top-0 start-0">
                                    <span class="badge bg-secondary">
                                        {{ $service_value->category_name }}
                                    </span>
                                </div>
                                <span class="feature-icon bg-danger">
                                    <i class="isax isax-flash-1"></i>
                                </span>
                                <a href="javascript:void(0);" class="favourite" data-product-id="{{ $service_value->id }}" data-type="services" aria-label="Add to wishlist">
                                    <i class="isax {{ isset($service_value->is_wishlist) && $service_value->is_wishlist == 1 ? 'text-danger isax-heart5' : 'isax-heart ' }}"></i>
                                </a>
                            </div>
                            <div class="service-content">
                                <h6 class="title">
                                    <a href="{{ url('servicedetail/' . $service_value->slug) }}">{{ $service_value->source_name }}</a>
                                </h6>
                                <div class="d-flex align-items-center justify-content-between flex-wrap flex-wrap gap-1">
                                    <div class="d-flex align-items-center">
                                        <a href="{{ url('servicedetail/' . $service_value->slug) }}" class="avatar me-2">
                                            <img src="{{ $service_value->shop_image }}" alt="shop" class="rounded-circle border">
                                        </a>
                                        <div>
                                            <h6 class="fs-16 fw-semibold mb-1"><a href="{{ url('servicedetail/' . $service_value->slug) }}">{{ $service_value->shop_name }}</a></h6>
                                            <p class="fs-14 d-inline-flex align-items-center">
                                                <i class="me-1 text-warning
                                                    @if($service_value->average_rating >= 1)
                                                        fa-solid fa-star
                                                    @elseif($service_value->average_rating > 0 && $service_value->average_rating < 1)
                                                        fa-solid fa-star-half-stroke
                                                    @else
                                                        fa-regular fa-star
                                                    @endif
                                                "></i>
                                                {{ $service_value->average_rating ?? 0.0 }} ({{ $service_value->review_count }} {{__('reviews')}})
                                            </p>
                                        </div>
                                    </div>
                                    <div class="price-range">
                                        <p class="fs-14 mb-1">{{ __('start_from') }}</p>
                                        <h6 class="mb-0">{{ $currencySymbol }}{{ $service_value->source_price }}</h6>
                                    </div>
                                    @if (Auth::check() && Auth::user()->user_type == 3)
                                        <button type="button" id="bookServiceButton" class="btn btn-dark book-btn" data-product_slug="{{ $service_value->slug }}">{{ __('book_now') }}</button>
                                    @elseif (Auth::check() && Auth::user()->user_type == 2 && $service_value->user_id == Auth::user()->id)
                                        <a href="{{ route('provider.service') }}" class="btn btn-dark">{{ __('My Service') }}</a>
                                    @elseif (Auth::check() && Auth::user()->user_type == 2 && $service_value->user_id != Auth::user()->id)
                                        <a href="{{ url('servicedetail/' . $service_value->slug) }}" class="btn btn-dark">{{ __('book_now') }}</a>
                                    @else
                                        <a href="{{ url('user/login') }}" class="btn btn-dark">{{ __('book_now') }}</a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div> <!-- end col -->
                @endforeach
            @else
                <div class="col-12">
                    <h6 class="text-center">{{__('no_trending_services_available')}}</h6>
                </div>
            @endif
        </div>
        <!-- end row -->

        <img src="{{ asset('frontend/assets/img/bg/service.png') }}" alt="shape" class="img-fluid service-bg-01">
        <img src="{{ asset('frontend/assets/img/bg/service-01.svg') }}" alt="shape" class="img-fluid service-bg-02">
        <img src="{{ asset('frontend/assets/img/bg/service-02.svg') }}" alt="shape" class="img-fluid service-bg-03">

    </div>
</section>