<!-- Testimonial Section -->
<section class="testimonial-section section position-relative">
    <div class="container">

        <!-- Section Header -->
        <div class="section-header text-center aos" data-aos="fade-down">
            <h2 class="title">{!! ucfirst($section['section_title'] ?? "") !!}</h2>
            <p>{{ ucfirst($section['section_label'] ?? "") }}</p>
        </div>
        <!-- Section Header End -->

    </div>

    @if(!empty($section['section_content']) && count($section['section_content']) > 0)
        <div class="testimonial-slider">
            @foreach($section['section_content'] as $key => $value)
                <!-- Testimonial Item -->
                <div class="testimonial-item flex-fill aos aos-init aos-animate" data-aos="fade-down">
                    <div class="rating d-flex align-items-center gap-1">
                        <i class="fa-solid fa-star filled"></i>
                        <i class="fa-solid fa-star filled"></i>
                        <i class="fa-solid fa-star filled"></i>
                        <i class="fa-solid fa-star filled"></i>
                        <i class="fa-solid fa-star filled"></i>
                        <p class="mb-0 ms-1">5.0</p>
                    </div>
                    <h6 class="fs-16 fw-semibold mb-2"><a href="javascript:void(0);">{{ $value->position ?? '' }}</a></h6>
                    <p class="mb-0">{{ $value->description ?? '' }} </p>
                    <div class="d-flex align-items-center justify-content-between testimonial-user gap-2">
                        <div class="d-flex align-items-center overflow-hidden gap-2">
                            <a href="javascript:void(0);" class="avatar avatar-lg">
                                <img src="{{ asset('frontend/assets/img/users/user-05.jpg') }}" alt="user" class="img-fluid rounded-circle">
                            </a>
                            <div class="overflow-hidden">
                                <h6 class="fs-16 fw-medium text-truncate mb-1"><a href="javascript:void(0);">{{ $value->client_name }}</a></h6>
                                <p class="fs-14">{{ $value->location ?? '' }}</p>
                            </div>
                        </div>
                        <div class="quote-img">
                            <img src="{{ asset('frontend/assets/img/icons/quote.svg') }}" alt="quote" class="img-fluid">
                        </div>
                    </div>
                </div>
                <!-- End Testimonial Item -->
            @endforeach
        </div>
        @else
            <div class="row row-gap-4 justify-content-center">
                <div class="col-12">
                    <h6 class="text-center">{{__('no_testimonials_available')}}</h6>
                </div>
            </div>
        @endif

    <img src="{{ asset('frontend/assets/img/bg/testimonial-01.png') }}" alt="shape" class="testimonial-bg-01">
    <img src="{{ asset('frontend/assets/img/bg/testimonial-02.png') }}" alt="shape" class="testimonial-bg-02">

</section>
<!-- Testimonial Section End -->