<!-- Service Section -->
<section class="product-section section position-relative productSection">
    <div class="container">
        <div class="product-sec">

            <!-- Section Header -->
            <div class="section-header d-flex align-items-center justify-content-between flex-wrap gap-3 aos" data-aos="fade-down">
                <div>
                    <h2 class="title">{!! ucfirst($section['section_title'] ?? "") !!}</h2>
                    <p>{{ ucfirst($section['section_label'] ?? "") }}</p>
                </div>
                <a href="{{ route('allproducts') }}" class="btn btn-white box-hover d-inline-flex align-items-center">{{__('view_all')}}<i class="isax isax-arrow-right-3 ms-1"></i></a>
            </div>
            <!-- Section Header End -->

            <div class="row row-gap-4 justify-content-center">
                @if(!empty($section['section_content']) && count($section['section_content']) > 0)
                    @foreach($section['section_content'] as $product_key => $product_value)
                        <!-- Item -->
                        <div class="col-xl-3 col-lg-4 col-md-6 col-sm-12 d-flex">
                            <div class="product-item box-hover rounded mb-0 flex-fill">
                                <div class="product-img position-relative">
                                    <a href="{{ url('productdetail/' . $product_value->slug) }}">
                                        <img src="{{ $product_value->product_images ?? '' }}" class="img-fluid w-100" alt="product">
                                    </a>
                                    <div class="product-status">
                                        <span class="badge bg-purple badge-sm rounded d-flex align-items-center justify-content-center gap-1 position-absolute top-0 left-0">
                                            <i class="isax isax-status-up"></i> {{ __('best_selling') }}
                                        </span>
                                    </div>

                                    <a href="{{ url('productdetail/' . $product_value->slug) }}" class="avatar user-avatar position-absolute bottom-0 left-0">
                                        <img src="{{ $product_value->profile_image }}" alt="brand-img-01" class="rounded-circle">
                                    </a>
                                    <div class="product-layout d-flex flex-column align-items-center justify-content-center gap-2">
                                        <a href="javascript:void(0);" class="btn btn1 btn-icon btn-white favourite" data-product-id="{{ $product_value->id }}" data-type="products" aria-label="Add to wishlist">
                                            <i class="isax {{ isset($product_value->is_wishlist) && $product_value->is_wishlist == 1 ? 'text-danger isax-heart5' : 'isax-heart ' }}"></i>
                                        </a>
                                        <a href="{{ url('productdetail/' . $product_value->slug) }}" class="btn btn3 btn-icon btn-white"><i class="isax isax-eye"></i></a>
                                    </div>
                                </div>
                                <div class="product-content">
                                    <div class="product-info mb-3">
                                        <div class="d-flex align-items-center flex-wrap gap-2 mb-2">
                                            <div class="d-flex align-items-center  fs-14">
                                                @php
                                                    $rating = $product_value->average_rating;
                                                @endphp

                                                @for ($i = 1; $i <= 5; $i++)
                                                    @if ($rating >= $i)
                                                        {{-- Full star --}}
                                                        <i class="fa-solid fa-star text-warning"></i>
                                                    @elseif ($rating >= ($i - 0.5))
                                                        {{-- Half star --}}
                                                        <i class="fa-solid fa-star-half-stroke text-warning"></i>
                                                    @else
                                                        {{-- Empty star --}}
                                                        <i class="fa-regular fa-star text-warning"></i>
                                                    @endif
                                                @endfor
                                            </div>
                                            <p class="fs-14 text-body mb-0">{{ $product_value->average_rating }} ({{$product_value->review_count}} {{__('reviews')}})</p>
                                        </div>
                                        <h6 class="mb-0"><a href="{{ url('productdetail/' . $product_value->slug) }}">{{ $product_value->source_name }}</a></h6>
                                    </div>
                                    <div class="product-action d-flex align-items-center justify-content-between gap-2 flex-wrap">
                                        <h6 class="mb-0">{{ $currencySymbol }}{{$product_value->source_price}}</h6>
                                        <div class="btn-icon d-flex align-items-center justify-content-between gap-2 flex-wrap">
                                            <a href="javascript:void(0);" class="btn btn-icon btn-dark add-to-cart-item" data-product-id="{{ $product_value->id }}"><i class="isax isax-shopping-cart"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="col-12">
                        <h6 class="text-center">{{__('no_best_selling_products_available')}}</h6>
                    </div>
                @endif
            </div>

        </div>

        <img src="{{ asset('frontend/assets/img/bg/product-01.png') }}" alt="shape" class="img-fluid product-bg-01">
        <img src="{{ asset('frontend/assets/img/bg/product-02.png') }}" alt="shape" class="img-fluid product-bg-02">
        <img src="{{ asset('frontend/assets/img/icons/about-04.svg') }}" alt="shape" class="img-fluid product-bg-03">

    </div>
</section>