<!-- Shop Section -->
<section class="shop-section section position-relative">
    <div class="container">

        <!-- Section Header -->
        <div class="section-header d-flex align-items-center justify-content-between flex-wrap gap-3 aos" data-aos="fade-down">
            <div>
                <h2 class="title">{!! ucfirst($section['section_title'] ?? "") !!}</h2>
                <p>{{ ucfirst($section['section_label'] ?? "") }}</p>
            </div>
            <a href="{{ route('frontend.shops.index') }}" class="btn btn-white box-hover d-inline-flex align-items-center">{{__('view_all')}}<i class="isax isax-arrow-right-3 ms-1"></i></a>
        </div>
        <!-- Section Header End -->

        <div class="row row-gap-4">
            @if(!empty($section['section_content']) && count($section['section_content']) > 0)
                @foreach($section['section_content'] as $key => $value)
                    <div class="col-lg-3 col-md-6">
                        <div class="shop-item">
                            <div class="shop-img">
                                <a href="{{ route('frontend.shops.show', $value->slug) }}">
                                    <img src="{{ $value->shop_logo }}" alt="shop" class="img-fluid">
                                </a>
                            </div>
                            <div class="shop-content">
                                <h5><a href="{{ route('frontend.shops.show', $value->slug) }}">{{ $value->shop_name }}</a></h5>
                                <div class="d-flex align-items-center justify-content-center flex-wrap shop-info">
                                    <p class="fs-14 d-inline-flex align-items-center mb-0">
                                        <i class="isax isax-location text-dark me-1"></i>
                                        {{ $value->city ?? '' }}{{ $value->city && $value->country ? ', '.$value->country : ($value->country ?? '') }}
                                    </p>
                                    <p class="fs-14 d-inline-flex align-items-center mb-0">
                                        <i class="me-1 text-warning
                                            @if($value->average_rating >= 1)
                                                fa-solid fa-star
                                            @elseif($value->average_rating > 0 && $value->average_rating < 1)
                                                fa-solid fa-star-half-stroke
                                            @else
                                                fa-regular fa-star
                                            @endif
                                        "></i>
                                        {{ $value->average_rating ?? 0.0 }}
                                    </p>
                                </div>
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="text-center flex-fill">
                                        <h6 class="mb-1">{{$value->service_count}}+</h6>
                                        <p class="fs-14">{{__('services')}}</p>
                                    </div>
                                    <div class="text-center flex-fill">
                                        <h6 class="mb-1">{{ $value->product_count}}+</h6>
                                        <p class="fs-14">{{__('products')}}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> <!-- end col -->
                @endforeach
            @else
                <div class="col-12">
                    <h6 class="text-center">{{__('no_featured_shops_available')}}</h6>
                </div>
            @endif
        </div>

        <img src="{{ asset('frontend/assets/img/icons/shop.svg') }}" alt="icon" class="img-fluid shop-bg-01">
        <img src="{{ asset('frontend/assets/img/bg/shop.png') }}" alt="icon" class="img-fluid shop-bg-02">

    </div>
</section>
<!-- Shop Section End -->
