<!-- Service Section -->
<section class="service-section section position-relative srviceCatSection">
    <div class="container">

        <!-- Section Header -->
        <div class="section-header d-flex align-items-center justify-content-between flex-wrap gap-3 aos" data-aos="fade-down">
            <div>
                <h2 class="title">{!! ucfirst($section['section_title'] ?? "") !!}</h2>
                <p>{{ ucfirst($section['section_label'] ?? "") }}</p>
            </div>
            <a href="{{ route('frontend.servicecategories') }}" class="btn btn-white box-hover d-inline-flex align-items-center">{{__('view_all')}}<i class="isax isax-arrow-right-3 ms-1"></i></a>
        </div>
        <!-- Section Header End -->

        <!-- start row -->
        <div class="row row-gap-4 justify-content-center">
            @if(!empty($section['section_content']) && count($section['section_content']) > 0)
            @foreach(collect($section['section_content'])->take(4) as $category_key => $category_value)
            <div class="col-xl-3 col-lg-6 col-md-6 d-flex">
                <div class="category-item box-hover flex-fill">
                    <div class="category-img">
                        <a href="{{ url('services?category_id=' . $category_value->id) }}">
                            <img class="img-fluid" src="{{ asset(str_replace('categories/', 'categories/fixed/', $category_value->image)) }}" alt="service">
                        </a>
                        <a href="{{ url('services?category=' . $category_value->slug) }}" class="avatar view-icon">
                            <i class="isax isax-arrow-right-1"></i>
                        </a>
                    </div>
                    <div class="d-flex align-items-center">
                        <a href="{{ url('services?category=' . $category_value->slug) }}" class="avatar avatar-lg category-icon me-2">
                            <img src="{{ $category_value->icon ?? '' }}" alt="category" class="img-fluid w-auto h-auto rounded-0">
                        </a>
                        <div>
                            <h6 class="mb-1">
                                <a href="{{ url('services?category=' . $category_value->slug) }}">{{ $category_value->name }}</a>
                            </h6>
                            <p class="fs-14">{{ $category_value->product_count }} {{ __('services') }}</p>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
            @else
            <div class="col-12">
                <h6 class="text-center">{{__('No services available')}}</h6>
            </div>
            @endif
        </div>
        <!-- end row -->
    </div>
</section>
<!-- Service Section End -->