<!-- Service Section -->
<section class="product-section section position-relative productCatSection">
    <div class="container">

        <!-- Section Header -->
        <div class="section-header d-flex align-items-center justify-content-between flex-wrap gap-3 aos" data-aos="fade-down">
            <div>
                <h2 class="title">{!! ucfirst($section['section_title'] ?? "") !!}</h2>
                <p>{{ ucfirst($section['section_label'] ?? "") }}</p>
            </div>
            <a href="{{ route('frontend.productcategories') }}" class="btn btn-white box-hover d-inline-flex align-items-center">{{__('view_all')}}<i class="isax isax-arrow-right-3 ms-1"></i></a>
        </div>
        <!-- Section Header End -->

        <!-- start row -->
        <div class="row row-gap-4 justify-content-center">
            @if(!empty($section['section_content']) && count($section['section_content']) > 0)
            @foreach($section['section_content'] as $category_key => $category_value)
            <div class="col-xl-2 col-md-4 col-sm-6 d-flex">
                <div class="category-item-two box-hover flex-fill">
                    <a href="{{ url('products?category=' . $category_value->slug) }}" class="category-img">
                        <img class="img-fluid" src="{{ uploadedAsset($category_value->image) }}" alt="category">
                    </a>
                    <div class="category-content">
                        <h6 class="mb-1">
                            <a href="{{ url('products?category=' . $category_value->slug) }}">
                                {{ $category_value->name }}
                            </a>
                        </h6>
                        <p class="fs-14">{{$category_value->product_count}} {{__('products')}}</p>
                    </div>
                    <a href="{{ url('products?category=' . $category_value->slug) }}" class="avatar view-icon">
                        <i class="isax isax-arrow-right-1"></i>
                    </a>
                </div>
            </div> <!-- end col -->
            @endforeach
            @else
            <div class="row align-items-center">
                <h6 class="text-center">{{ __('No categories available') }}</h6>
            </div>
            @endif
        </div>
    </div>
</section>