<!-- Blog Section -->
<section class="blog-section section blogsSections">
    <div class="container">
        <!-- Section Header -->
        <div class="section-header d-flex align-items-center justify-content-between flex-wrap gap-3 aos" data-aos="fade-down">
            <div>
                <h2 class="title">{!! ucfirst($section['section_title'] ?? "") !!}</h2>
                <p>{{ ucfirst($section['section_label'] ?? "") }}</p>
            </div>
            <a href="/blog" class="btn btn-white box-hover d-inline-flex align-items-center">{{__('view_all')}}<i class="isax isax-arrow-right-3 ms-1"></i></a>
        </div>
        <!-- Section Header End -->

        <!-- start row -->
        <div class="row row-gap-4 justify-content-center">
            @if(!empty($section['section_content']) && count($section['section_content']) > 0)
                @foreach($section['section_content'] as $key => $value)
                    <div class="col-lg-4 col-md-6 d-flex">
                        <div class="blog-item flex-fill aos" data-aos="fade-down">
                            <div class="blog-img">
                                <a href="{{ url('blog-details/' . $value->slug) }}">
                                    <img src="{{$value->image}}" class="img-fluid" alt="salon management tips">
                                </a>
                                <div class="blog-date">
                                    <h5 class="mb-0">{{ $value->day }}</h5>
                                    <span>{{ $value->month }}</span>
                                </div>
                            </div>
                            <div class="blog-content">
                                <h5><a href="{{ url('blog-details/' . $value->slug) }}">{{ $value->title }}</a></h5>
                                <a href="{{ url('blog-details/' . $value->slug) }}" class="link-secondary fw-medium d-inline-flex align-items-center">{{__('read_more')}}<i class="isax isax-arrow-right-1 ms-1"></i></a>
                            </div>
                        </div>
                    </div> <!-- end col -->
                @endforeach
            @else
                <div class="row align-items-center">
                    <h6 class="text-center">{{ __('No content available') }}</h6>
                </div>
            @endif
        </div>
        <!-- end row -->

    </div>
</section>
<!-- Blog Section End -->