<!-- Banner Section -->
@foreach($section['section_content'] as $banner)
<section class="banner-section" @if(isset($banner->background_image) && !empty($banner->background_image)) style="background: url('{{ $banner->background_image }}') no-repeat center center/cover" @endif>
    <div class="container">
        <div class="position-relative">
            <div class="row align-items-end">
                <div class="col-lg-6">
                    <div class="banner-content aos" data-aos="fade-down">
                        <h1 class="mb-4">{!! ucfirst($section['section_title'] ?? "") !!}</span></h1>
                        <p class="mb-3">{{ ucfirst($section['section_label'] ?? "") }}</p>
                        <div class="d-flex align-items-center flex-wrap gap-3">
                            <a href="{{ route('servicelists') }}" class="btn btn-white box-hover box-hover d-inline-flex align-items-center">{{__('browse_services')}}<i class="isax isax-arrow-right-3 ms-1"></i></a>
                            <div class="avatar-list-stacked">
                                <span class="avatar rounded-circle"><img src="{{ asset('frontend/assets/img/users/user-20.jpg') }}" class="img-fluid rounded-circle border border-white" alt="Stephen Brekke"></span>
                                <span class="avatar rounded-circle"><img src="{{ asset('frontend/assets/img/users/user-21.jpg') }}" class="img-fluid rounded-circle border border-white" alt="Charles Earnhard"></span>
                                <span class="avatar rounded-circle"><img src="{{ asset('frontend/assets/img/users/user-22.jpg') }}" class="img-fluid rounded-circle border border-white" alt="Ethan Carter"></span>
                                <span class="avatar rounded-circle"><img src="{{ asset('frontend/assets/img/users/user-23.jpg') }}" class="img-fluid rounded-circle border border-white" alt="James Anderson"></span>
                            </div>
                        </div>
                        <form id="bannerSearchForm" class="banner-search">
                            <div>
                                <select class="select2" name="home_category" id="home_category">
                                    <option>{{__('all_category')}}</option>
                                    @if(!empty($categories))
                                        @foreach($categories as $category)
                                            <option value="{{ $category->id }}" data-slug="{{ $category->slug }}" data-type="{{ $category->source_type }}">
                                                {{ $category->name }}
                                            </option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                            <div>
                                <input type="text" name="keyword" id="keyword" class="border-0 form-control p-0" placeholder="{{__('home_looking_for')}}">
                            </div>
                            <button type="submit" class="btn btn-dark d-inline-flex align-items-center ms-auto" aria-label="Search">
                                <i class="isax isax-search-normal me-1"></i>{{__('search')}}
                            </button>
                        </form>
                        <div class="circular-text">
                            <img src="{{ asset('frontend/assets/img/icons/star.svg') }}" alt="icon" class="img-fluid">
                            <span class="char">B</span>
                            <span class="char">e</span>
                            <span class="char">s</span>
                            <span class="char">t</span>
                            <span class="char"> </span>
                            <span class="char">M</span>
                            <span class="char">a</span>
                            <span class="char">r</span>
                            <span class="char">k</span>
                            <span class="char">e</span>
                            <span class="char">t</span>
                            <span class="char">P</span>
                            <span class="char">l</span>
                            <span class="char">a</span>
                            <span class="char">c</span>
                            <span class="char">e</span>
                            <span class="char"> </span>
                            <span class="char">A</span>
                            <span class="char">r</span>
                            <span class="char">o</span>
                            <span class="char">u</span>
                            <span class="char">n</span>
                            <span class="char">d</span>
                            <span class="char"> </span>
                            <span class="char">W</span>
                            <span class="char">o</span>
                            <span class="char">r</span>
                            <span class="char">l</span>
                            <span class="char">d</span>
                            <span class="char"> </span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="banner-img">
                        <img src="{{ $banner->thumbnail_image ? $banner->thumbnail_image : asset('frontend/assets/img/banner/banner.png') }}" alt="banner-image" class="img-fluid aos" data-aos="zoom-in">
                        <div class="banner-wrap ban-bg">
                            <div class="ban-info">
                                <h3 class="text-dark mb-1">600</h3>
                                <p class="text-dark">{{__('product_and_service')}}</p>
                            </div>
                            <div class="ban-icon">
                                <img src="{{ asset('frontend/assets/img/icons/ban-icon-01.svg') }}" alt="icon">
                            </div>
                        </div>
                    </div>
                    <div class="banner-wrap ban-bg-02">
                        <div class="ban-info">
                            <h3 class="mb-1">5K+</h3>
                            <p>{{__('booking_completed')}}</p>
                        </div>
                        <div class="ban-icon">
                            <img src="{{ asset('frontend/assets/img/icons/ban-icon-02.svg') }}" alt="icon">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endforeach
<!-- Banner Section End -->