<section class="about-section section">
    <div class="container">
        @php
            $isRTL = isRTL(app()->getLocale());
        @endphp

        <!-- Section Header -->
        <div class="row row-gap-4">
            <div class="col-lg-6">
                <div class="about-img">
                    <div class="d-flex gap-3 {{ $isRTL ? 'justify-content-end' : '' }}">
                        <img src="{{ asset('frontend/assets/img/about/about-03.jpg') }}" alt="about" class="img-fluid about-01">
                        <img src="{{ asset('frontend/assets/img/about/about-04.jpg') }}" alt="about" class="img-fluid about-02">
                    </div>
                    <div class="video-wrap">
                        <img src="{{ asset('frontend/assets/img/about/about-05.jpg') }}" alt="about" class="img-fluid">
                        <a class="video-btn video-effect" data-fancybox="" href="https://www.youtube.com/watch?v=Vdp6x7Bibtk"><i class="fa-solid fa-play"></i></a>
                    </div>
                    <span class="customer-badge {{ $isRTL ? 'about-company-customer-badge-rtl' : '' }}">{{ __('about_company_customer_count') }}</span>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="aos" data-aos="fade-down">
                    <div class="mb-4">
                        <h6 class="fs-16 fw-semibold text-secondary mb-2">{{ $section['section_title'] ?? '' }}</h6>
                        <h2 class="mb-2">{{ $section['section_label'] ?? '' }}</h2>
                        <p>{{ __('about_company_description') }}</p>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 d-flex">
                            <div class="about-item d-flex align-items-center flex-fill">
                                <span class="flex-shrink-0">
                                    <img src="{{ asset('frontend/assets/img/icons/about-01.svg') }}" alt="icon" class="img-fluid">
                                </span>
                                <div class="ms-2">
                                    <h6 class="mb-2">{{ __('about_company_card_title_one') }}</h6>
                                    <p>{{ __('about_company_card_description_one') }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 d-flex">
                            <div class="about-item d-flex align-items-center flex-fill">
                                <span class="flex-shrink-0">
                                    <img src="{{ asset('frontend/assets/img/icons/about-02.svg') }}" alt="icon" class="img-fluid">
                                </span>
                                <div class="ms-2">
                                    <h6 class="mb-2">{{ __('about_company_card_title_two') }}</h6>
                                    <p>{{ __('about_company_card_description_two') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="about-list mb-4">
                        <p>{{ __('about_list_one') }}</p>
                        <p>{{ __('about_list_two') }}</p>
                        <p>{{ __('about_list_three') }}</p>
                    </div>
                    <div class="d-flex align-items-center flex-wrap gap-2">
                        <a href="{{ route('allproducts') }}" class="btn btn-secondary d-inline-flex align-items-center">{{__('discover_more')}}<i class="isax isax-arrow-right-3 ms-1"></i></a>
                        <a href="{{ route('servicelists') }}" class="btn btn-dark d-inline-flex align-items-center">{{__('view_services')}}<i class="isax isax-arrow-right-3 ms-1"></i></a>
                    </div>
                </div>
            </div>
        </div>
        <!-- Section Header End -->

        <img src="{{ asset('frontend/assets/img/bg/about-02.png') }}" alt="shape" class="img-fluid about-bg-01">
        <img src="{{ asset('frontend/assets/img/bg/about-03.png') }}" alt="shape" class="img-fluid about-bg-02">
        <img src="{{ asset('frontend/assets/img/icons/about.svg') }}" alt="icon" class="img-fluid about-bg-03">
        <img src="{{ asset('frontend/assets/img/icons/circle-01.svg') }}" alt="icon" class="img-fluid about-bg-04">
    </div>
</section>