@extends($layout)
@section('content')
@php
    $partials = [
            'banner' => 'frontend.home.partials.banner',
            'product_category' => 'frontend.home.partials.categories',
            'service' => 'frontend.home.partials.products',
            'marquee_section' => 'frontend.home.partials.marquee',
            'about_us' => 'partials.about-section',
            'about_company' => 'frontend.home.partials.about_company',
            'service_category' => 'frontend.home.partials.feature_services',
            'facts_only' => 'frontend.home.partials.facts',
            'featured_service' => 'frontend.home.partials.trending_services',
            'shop' => 'frontend.home.partials.featured_shops',
            'how_it_works' => 'frontend.home.partials.book',
            'testimonial' => 'frontend.home.partials.testimonials',
            'faq' => 'frontend.home.partials.faq',
            'blog' => 'frontend.home.partials.blogs',
            'contact_us' => 'partials.contact-section',
            'terms_conditions' => 'partials.terms-condition-section',
            'privacy_policy' => 'partials.privacy-policy-section',
            'multiple_section' => 'partials.multiple-section',
    ];
@endphp

@if (request()->routeIs(['about-us', 'terms.conditions', 'privacy.policy', 'contact-us', 'page.faq', 'page.how.it.work']))
    @include('frontend.breadcrumb', [
        'menu' => $data['menu'] ?? null,
        'title' => $data['page_name'] ?? null
    ])
@endif

@foreach($content_sections as $section)
    @if(isset($section['section_type']))
        @includeIf($partials[$section['section_type']] ?? null)
    @endif
@endforeach

@endsection
@push('scripts')
<script src="{{ asset('frontend/assets/js/custom/home_1.js') }}"></script>
@endpush
