@if(count($blogPosts) != 0)
@foreach($blogPosts as $blogPost)
<div class="col-md-6 col-lg-6 blog-post-item" data-category="{{ $blogPost->category }}">
    <div class="blog-grid-item">
        <div class="blog-grid-img">
            <a href="/blog-details/{{$blogPost->slug}}">
                @php
                $imagePath = 'storage/blogs/' . $blogPost->image;
                $defaultImage = asset('assets/img/default-image.png');
                @endphp
                <img src="{{ file_exists(public_path($imagePath)) ? asset($imagePath) : $defaultImage }}" alt="blog" class="img-fluid">
            </a>
            <a class="badge badge-sm">{{ucfirst($blogPost->category)}}</a>
        </div>
        <div class="blog-grid-item-content">
            <h6 class="mb-3"><a href="/blog-details/{{$blogPost->slug}}">{{$blogPost->title}}</a></h6>
            <div class="d-flex align-items-center justify-content-between">
                <div class="d-flex align-items-center">
                    <a href="javascript:void(0);" class="me-2">
                        @php
                        $profileImagePath = 'storage/' . $blogPost->profile_image;
                        $defaultProfileImage = asset('assets/img/profile-default.png');
                        @endphp
                        <img src="{{ file_exists(public_path($profileImagePath)) ? asset($profileImagePath) : $defaultProfileImage }}" alt="user" class="avatar avatar-md rounded-circle">
                    </a>
                    <a href="javascript:void(0);" class="fs-14">{{ucfirst($blogPost->customer)}}</a>
                </div>
                <div class="d-flex align-items-center">
                    <span class="fs-14 d-flex align-items-center"><i class="isax isax-calendar-1 text-dark me-1"></i>{{ \Carbon\Carbon::parse($blogPost->created_at)->format('d M Y') }}</span>
                </div>
            </div>
        </div>
    </div>
</div>
@endforeach

@if(count($blogPosts) > 6)
<div class="col-12">
    <div class="d-flex justify-content-center mt-3">
        <a href="javascript:void(0);" id="load-more-btn" class="btn btn-dark"><i class="isax isax-rotate-left me-1"></i>{{__('load_more')}}</a>
    </div>
</div>
@endif

@else
<div class="col-12">
    <h4 class="no-blog text-center">{{__('no_blogs_found')}}</h4>
</div>
@endif