@extends('frontend.theme_2.app')

@section('title', 'Blog')
@section('content')
<div class="breadcrumb-bar">
    <div class="container">
        <div class="breadcrumb-item">
            <nav aria-label="breadcrumb" class="page-breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-items">{!! $data['menu'] ?? '<a href="' . url('/') . '">' . __('Home') . '</a>' !!}</li>
                    <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                    <li class="breadcrumb-items active" aria-current="page">{{$data['submenu'] ??  __('Blog') }}</li>
                </ol>
            </nav>
            <h1 class="breadcrumb-title">{{$data['header'] ??  __('Blog') }}</h1>
        </div>
    </div>
    <img src="{{ asset('frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
</div>
<div class="page-wrapper">
    <div class="content">
        <div class="container">
            <div class="row row-gap-4">
                <div class="col-lg-4 theiaStickySidebar">
                    <div class="card mb-4">
                        <div class="card-header bg-white py-3">
                            <h5 class="mb-0">{{__('search')}}</h5>
                        </div>
                        <div class="card-body">
                            <div class="input-group input-group-flat">
                                <span class="input-group-text">
                                    <i class="isax isax-search-normal-1 text-dark"></i>
                                </span>
                                <input type="text" id="blogSearch" class="form-control" placeholder="{{ __('to_search_type_and_hit_enter') }}">
                            </div>
                        </div>
                    </div>
                    <div class="card mb-4">
                        <div class="card-header bg-white py-3">
                            <h5 class="mb-0">{{__('categories')}}</h5>
                        </div>
                        <div class="card-body">
                            @foreach($categories as $category)
                            @php
                            $count = Modules\GlobalSetting\app\Models\BlogPost::where('category', $category->id)->where('deleted_at', null)->where('status', 1)->where('slug', '!=', null)->count();
                            @endphp
                            <div class="d-flex align-items-center justify-content-between pb-1 mb-2">
                                <a href="javascript:void(0);"
                                    class="d-inline-flex align-items-center category-filter"
                                    data-category="{{ $category->name }}">
                                    <i class="isax isax-arrow-right-3 me-1"></i>{{ ucfirst($category->name) }}
                                </a>
                                <span>({{$count}})</span>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="card mb-4 blog-sidebar-item">
                        <div class="card-header bg-white py-3">
                            <h5 class="mb-0">{{__('recent_blogs')}}</h5>
                        </div>
                        <div class="card-body">
                            @foreach($latestblogs as $index => $latest)
                            <div class="d-flex align-items-center {{ !$loop->last ? 'mb-3' : 'mb-0' }}">
                                <div class="me-3">
                                    <a href="/blog-details/{{$latest->slug}}">
                                        @php
                                        $imagePath = 'storage/blogs/' . $latest->image;
                                        $defaultImage = asset('assets/img/default-image.png');
                                        @endphp
                                        <img src="{{ file_exists(public_path($imagePath)) ? asset($imagePath) : $defaultImage }}" alt="blog-sidebar-img" class="avatar rounded blog-sidebar-img">
                                    </a>
                                </div>
                                <div>
                                    <h6 class="text-truncate mb-1"><a href="/blog-details/{{$latest->slug}}">{{$latest->title}}</a></h6>
                                    <p class="fs-14">{{ \Carbon\Carbon::parse($latest->created_at)->format('d M Y') }}</p>
                                </div>
                            </div>
                            @if(!$loop->last)
                            <hr> @endif
                            @endforeach
                        </div>
                    </div>
                    <div class="card mb-0">
                        <div class="card-header bg-white py-3">
                            <h5 class="mb-0">{{__('popular_tags')}}</h5>
                        </div>
                        <div class="card-body">
                            <div class="d-flex align-items-center flex-wrap gap-2">
                                @foreach($tags as $tag)
                                <a href="javascript:void(0);" class="btn btn-sm py-1 px-2 btn-light">#{{ucfirst($tag)}}</a>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="row row-gap-4" id="blogListContainer">
                        @include('frontend.blogs.partials.blogs-list', ['blogPosts' => $blogPosts])
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script src="{{ asset('frontend/assets/js/blogs/blog.js') }}"></script>
@endpush