@extends('frontend.theme_2.app')

@section('title', 'Blog')
@section('content')
<div class="breadcrumb-bar">
    <div class="container">
        <div class="breadcrumb-item">
            <nav aria-label="breadcrumb" class="page-breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-items"><a href="/">{{__('home')}}</a></li>
                    <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                    <li class="breadcrumb-items active" aria-current="page">{{__('blog_details')}}</li>
                </ol>
            </nav>
            <h1 class="breadcrumb-title">{{__('blog_details')}}</h1>
        </div>
    </div>
    <img src="{{ asset('frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
</div>
<div class="page-wrapper">
    <div class="content">
        <div class="container">
            <div class="row row-gap-3">
                <div class="col-lg-4 theiaStickySidebar">
                    <div class="card mb-4">
                        <div class="card-header bg-white py-3">
                            <h5 class="mb-0">{{__('search')}}</h5>
                        </div>
                        <div class="card-body">
                            <div class="input-group input-group-flat">
                                <span class="input-group-text"><i class="isax isax-search-normal-1 text-dark"></i></span>
                                <input type="text" class="form-control" placeholder="Search">
                            </div>
                        </div>
                    </div>

                    <div class="card mb-4">
                        <div class="card-header bg-white py-3">
                            <h5 class="mb-0">{{__('categories')}}</h5>
                        </div>
                        <div class="card-body">
                            @foreach($categories as $category)
                            @php
                            $count = Modules\GlobalSetting\app\Models\BlogPost::where('category', $category->id)->whereNull('deleted_at')->where('status', 1)->count();
                            @endphp
                            <div class="d-flex align-items-center justify-content-between pb-1 mb-2">
                                {{-- This link is updated to redirect to the blog list with a filter --}}
                                <a href="{{ url('blog') }}?category={{ urlencode($category->name) }}" class="d-inline-flex align-items-center">
                                    <i class="isax isax-arrow-right-3 me-1"></i>{{ $category->name }}
                                </a>
                                <span>({{$count}})</span>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="card mb-4 blog-sidebar-item">
                        <div class="card-header bg-white py-3">
                            <h5 class="mb-0">{{__('recent_blogs')}}</h5>
                        </div>
                        <div class="card-body">
                            @foreach($latestblogs as $latest)
                            <div class="d-flex align-items-center {{ !$loop->last ? 'mb-3' : 'mb-0' }}">
                                <div class="me-3">
                                    <a href="/blog-details/{{$latest->slug}}">
                                        @php
                                        $imagePath = 'storage/blogs/' . $latest->image;
                                        $defaultImage = asset('assets/img/default-image.png');
                                        @endphp
                                        <img src="{{ file_exists(public_path($imagePath)) ? asset($imagePath) : $defaultImage }}" alt="blog-sidebar-img" class="avatar rounded blog-sidebar-img">
                                    </a>
                                </div>
                                <div>
                                    <h6 class="text-truncate mb-1"><a href="/blog-details/{{$latest->slug}}">{{$latest->title}}</a></h6>
                                    <p class="fs-14">{{ \Carbon\Carbon::parse($latest->created_at)->format('d M Y') }}</p>
                                </div>
                            </div>
                            @if(!$loop->last)
                            <hr> @endif
                            @endforeach
                        </div>
                    </div>
                    <div class="card mb-0">
                        <div class="card-header bg-white py-3">
                            <h5 class="mb-0">{{__('popular_tags')}}</h5>
                        </div>
                        <div class="card-body">
                            <div class="d-flex align-items-center flex-wrap gap-2">
                                @foreach($tags as $tag)
                                <a href="javascript:void(0);" class="btn btn-sm py-1 px-2 btn-light">#{{ucfirst($tag)}}</a>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="mb-4">
                        @php
                        $imagePath = 'storage/blogs/' . $blogPosts->image;
                        $defaultImage = asset('assets/img/default-image.png');
                        @endphp
                        <img src="{{ file_exists(public_path($imagePath)) ? asset($imagePath) : $defaultImage }}" alt="blog-details-img" class="img-fluid rounded blog-image">
                    </div>

                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-4">
                        <div class="d-flex align-items-center">
                            <div class="d-flex align-items-center blog-details-profile-divide">
                                <a href="javascript:void(0);">
                                    @php
                                    $profileImagePath = 'storage/' . $blogPosts->profile_image;
                                    $defaultProfileImage = asset('assets/img/profile-default.png');
                                    @endphp
                                    <img src="{{ file_exists(public_path($profileImagePath)) ? asset($profileImagePath) : $defaultProfileImage }}" alt="user" class="avatar avatar-md rounded-circle me-2">
                                </a>
                                <div>
                                    <a href="javascript:void(0);" class="fs-14 mb-0">{{ucfirst($blogPosts->customer)}}</a>
                                </div>
                            </div>
                            <span class="fs-14 d-flex align-items-center"><i class="isax isax-calendar-1 text-dark me-1"></i>{{ \Carbon\Carbon::parse($blogPosts->created_at)->format('d M Y') }}</span>
                        </div>
                        <a href="javascript:void(0);" class="badge badge-md bg-secondary">{{ucfirst($blogPosts->category)}}</a>
                    </div>

                    <h3 class="mb-4">{{$blogPosts->title}}</h3>

                    <div>{!! $blogPosts->description !!}</div>

                    <hr>

                    <div class="mb-4">
                        <div class="d-flex align-items-center justify-content-between flex-wrap gap-3">
                            <div class="d-flex align-items-center flex-wrap gap-2">
                                <h6 class="mb-0">Related Tags :</h6>
                                @php
                                $tags = !empty($blogPosts->tags) ? array_filter(array_map('trim', explode(',', $blogPosts->tags))) : [];
                                @endphp

                                @foreach($tags as $tagName)
                                <a href="javascript:void(0);" class="btn btn-sm py-1 px-2 btn-light">{{ ucfirst($tagName) }}</a>
                                @endforeach
                            </div>
                            <div class="d-flex align-items-center flex-wrap gap-2">
                                <h6 class="mb-0">Share Post : </h6>
                                @php
                                $currentUrl = url()->current();
                                $postTitle = $blogPosts->title;
                                @endphp
                                <a href="https://api.whatsapp.com/send?text={{ urlencode($postTitle . ' ' . $currentUrl) }}" target="_blank" rel="noopener noreferrer">
                                    <img src="{{asset('assets/img/social/social-img-4.svg')}}" alt="Whatsapp">
                                </a>
                                <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode($currentUrl) }}" target="_blank" rel="noopener noreferrer">
                                    <img src="{{asset('assets/img/social/social-img-1.svg')}}" alt="Facebook">
                                </a>
                                <a href="javascript:void(0);"
                                onclick="navigator.clipboard.writeText(window.location.href).then(() => toastr.success('Link copied to clipboard!')).catch(() => toastr.error('Failed to copy link.'));"
                                title="Copy link for Instagram">
                                <img src="{{ asset('assets/img/social/social-img-2.svg') }}" alt="instagram">
                                </a>
                                <a href="https://twitter.com/intent/tweet?url={{ urlencode($currentUrl) }}&text={{ urlencode($postTitle) }}" target="_blank" rel="noopener noreferrer">
                                    <img src="{{asset('assets/img/social/social-img-3.svg')}}" alt="twitter">
                                </a>
                                <a href="https://t.me/share/url?url={{ urlencode($currentUrl) }}&text={{ urlencode($postTitle) }}" target="_blank" rel="noopener noreferrer">
                                    <img src="{{asset('assets/img/social/social-img-5.svg')}}" alt="telegram">
                                </a>
                                <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ urlencode($currentUrl) }}&title={{ urlencode($postTitle) }}" target="_blank" rel="noopener noreferrer">
                                    <img src="{{asset('assets/img/social/social-img-6.svg')}}" alt="LinkedIn">
                                </a>
                            </div>
                        </div>
                    </div>

                    <hr>

                    <div class="card border-0 bg-dark">
                        <div class="card-body p-5">
                            <div class="d-flex align-items-center">
                                @php
                                $authorImagePath = 'storage/' . $blogPosts->profile_image;
                                $defaultAuthorImage = asset('assets/img/profile-default.png');
                                @endphp
                                <img src="{{ file_exists(public_path($authorImagePath)) ? asset($authorImagePath) : $defaultAuthorImage }}" alt="User" class="avatar avatar-xxl rounded-circle me-3">
                                <div>
                                    <h6 class="text-white mb-2">About {{ucfirst($blogPosts->customer)}}</h6>
                                </div>
                            </div>
                        </div>
                    </div>

                    <hr>

                    <h6 class="mb-3">Comments ({{$countReview}})</h6>
                    @if($countReview > 0)
                    <div class="card mb-4">
                        <div class="card-body">
                            @foreach($blogReviews as $review)
                            <div>
                                <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="javascript:void(0);"><img src="{{ asset('assets/img/profile-default.png')}}" alt="user" class="avatar avatar-md rounded-circle me-2"></a>
                                        <div><a href="javascript:void(0);" class="fw-semibold mb-1">{{ucfirst($review->name)}}</a></div>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <p class="fs-14">{{ \Carbon\Carbon::parse($review->created_at)->diffForHumans() }}</p>
                                    </div>
                                </div>
                                <p class="mb-2">{{$review->comments}}</p>
                            </div>
                            @if(!$loop->last)
                            <hr> @endif
                            @endforeach
                        </div>
                    </div>
                    @endif

                    <div class="card mb-0">
                        <div class="card-header border-0 bg-white pt-3 pb-0">
                            <h5 class="mb-0">Leave a Comment</h5>
                        </div>
                        <div class="card-body">
                            <form id="blogReviewForm" action="{{ route('blogs.review.store') }}" method="POST">
                                @csrf
                                <input type="hidden" name="blog_id" value="{{ $blogPosts->id }}">
                                <div class="row row-gap-3">
                                    <div class="col-lg-6">
                                        <div class="mb-0">
                                            <label for="name" class="form-label">{{ __('full_name') }} <span class="text-danger">*</span></label>
                                            <input type="text" name="name" class="form-control" id="name" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="mb-0">
                                            <label for="email" class="form-label">{{ __('email_address') }} <span class="text-danger">*</span></label>
                                            <input type="email" name="email" class="form-control" id="email" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="mb-3">
                                            <label for="description" class="form-label">{{ __('comments') }} <span class="text-danger">*</span></label>
                                            <textarea class="form-control" name="comment" rows="3" id="description" required></textarea>
                                        </div>
                                    </div>
                                    <div>
                                        <button id="blogReviewBtn" type="submit" class="btn btn-dark">{{ __('submit_review') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection