@extends('frontend.theme_2.app')
@section('content')
<!-- Breadcrumb -->
<div class="page-wrapper">
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items">{!! $data['menu'] ?? '<a href="' . url('/') . '">' . __('Home') . '</a>' !!}</li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{$data['submenu'] ??  __('FAQ') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{$data['header'] ??  __('FAQ') }}</h1>
            </div>
        </div>
        <img src="{{ asset('frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- /Breadcrumb -->

    <!-- Page Wrapper -->
    <div class="page-wrapper">
        <div class="content">
            <div class="container">

                <div class="accordion faq-accordion" id="accordionFaq">
                    <div class="accordion-item shadow-sm show mb-3 ">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq-collapseOne" aria-expanded="false" aria-controls="faq-collapseOne">
                                How does the marketplace work?
                            </button>
                        </h2>
                        <div id="faq-collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionFaq">
                            <div class="accordion-body">
                                <p class="mb-0">Our platform connects customers with verified service providers. Users can browse services, compare options, book appointments, and make secure payments all in one place.</p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item shadow-sm mb-3">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-collapsetwo" aria-expanded="false" aria-controls="faq-collapsetwo">
                                How do I book a service?
                            </button>
                        </h2>
                        <div id="faq-collapsetwo" class="accordion-collapse collapse" data-bs-parent="#accordionFaq">
                            <div class="accordion-body">
                                <p class="mb-0">Our platform connects customers with verified service providers. Users can browse services, compare options, book appointments, and make secure payments all in one place.</p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item shadow-sm mb-3">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-collapsthree" aria-expanded="false" aria-controls="faq-collapsthree">
                                What if I need to cancel or reschedule?
                            </button>
                        </h2>
                        <div id="faq-collapsthree" class="accordion-collapse collapse" data-bs-parent="#accordionFaq">
                            <div class="accordion-body">
                                <p class="mb-0">Our platform connects customers with verified service providers. Users can browse services, compare options, book appointments, and make secure payments all in one place.</p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item shadow-sm mb-3">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-collapsefour" aria-expanded="false" aria-controls="faq-collapsefour">
                                How are service providers rated?
                            </button>
                        </h2>
                        <div id="faq-collapsefour" class="accordion-collapse collapse" data-bs-parent="#accordionFaq">
                            <div class="accordion-body">
                                <p class="mb-0">Our platform connects customers with verified service providers. Users can browse services, compare options, book appointments, and make secure payments all in one place.</p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item shadow-sm mb-3">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-collapsefive" aria-expanded="false" aria-controls="faq-collapsefive">
                                Can I contact the service provider before booking?
                            </button>
                        </h2>
                        <div id="faq-collapsefive" class="accordion-collapse collapse" data-bs-parent="#accordionFaq">
                            <div class="accordion-body">
                                <p class="mb-0">Our platform connects customers with verified service providers. Users can browse services, compare options, book appointments, and make secure payments all in one place.</p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item shadow-sm mb-3">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-collapsesix" aria-expanded="false" aria-controls="faq-collapsesix">
                                What if I'm not satisfied with the service?
                            </button>
                        </h2>
                        <div id="faq-collapsesix" class="accordion-collapse collapse" data-bs-parent="#accordionFaq">
                            <div class="accordion-body">
                                <p class="mb-0">Our platform connects customers with verified service providers. Users can browse services, compare options, book appointments, and make secure payments all in one place.</p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item shadow-sm mb-0">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-collapseseven" aria-expanded="false" aria-controls="faq-collapseseven">
                                How do I get support?
                            </button>
                        </h2>
                        <div id="faq-collapseseven" class="accordion-collapse collapse" data-bs-parent="#accordionFaq">
                            <div class="accordion-body">
                                <p class="mb-0">Our platform connects customers with verified service providers. Users can browse services, compare options, book appointments, and make secure payments all in one place.</p>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>
    <!-- /Page Wrapper -->

    @endsection