<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
	<!-- Meta Tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>
        {{ isset($data['seo_title']) ? $data['seo_title'] . ' || ' : '' }}
        @yield('title', $companyName)
    </title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="">
	<meta name="keywords" content="">
	
    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ asset('frontend/assets/img/favicon.png') }}">

    <!-- Apple Icon -->
    <link rel="apple-touch-icon" href="{{ asset('frontend/assets/img/apple-icon.png') }}">

    @php
        $isRTL = isRTL(app()->getLocale());
    @endphp

    @if ($isRTL)
        <!-- Bootstrap CSS -->
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/bootstrap.rtl.min.css') }}">
    @else
        <!-- Bootstrap CSS -->
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/bootstrap.min.css') }}">
    @endif
    <!-- Iconsax CSS -->
    <link rel="stylesheet" href="{{ asset('frontend/assets/plugins/iconsax/iconsax.css') }}">

    <!-- Main CSS -->
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/style.css') }}">

</head>

<body>

	<!-- Begin Wrapper -->
	<div class="main-wrapper auth-cover">

        <!-- Start Content -->
		<div class="container-fuild">
			<div class="w-100 overflow-hidden position-relative flex-wrap d-block vh-100 login-wrap">

				<!-- start row -->
				<div class="row justify-content-center align-items-center vh-100 overflow-auto flex-wrap">

					<div class="col-md-10 col-lg-10 col-xl-12 mx-auto position-relative z-2">
						<form action="javascript:void(0);" class="d-flex justify-content-center align-items-center">
							<div class="p-4 text-center position-relative z-1 error-layout">
								<div class="login-logo mx-auto text-center">
									<a href="{{ route('home') }}">
										<img src="{{ asset('frontend/assets/img/logo.svg') }}" class="img-fluid" alt="Logo">
									</a>
								</div>
                                <h5 class="mb-0"> OOPS !</h5>
								<div class="custom-light-text">
                                    <img src="{{ asset('frontend/assets/img/icons/error-2.svg') }}" alt="error-1" class="img-fluid">
                                </div>
                                <div>
                                    <h3 class="mb-2">Page Not Found</h3>
                                    <p class="mb-4 custom-width m-auto">The link you followed might be broken, or the page has wandered off. Let’s help you get back on track.</p>
                                    <a href="{{ route('home') }}" class="btn btn-secondary d-inline-flex align-items-center gap-2">  Go to Home <i class="isax isax-arrow-right-3"></i></a>
                                </div>
							</div>
						</form>
					</div><!-- end col -->

				</div>
				<!-- end row -->

			</div>
		</div>
		<!-- End Content -->
    </div>
	<!-- End Wrapper -->

    <!-- jQuery -->
    <script src="{{ asset('frontend/assets/js/jquery-3.7.1.min.js') }}"></script>

    <!-- Bootstrap Core JS -->
    <script src="{{ asset('frontend/assets/js/bootstrap.bundle.min.js') }}"></script>

    <!-- Main JS -->
    <script src="{{ asset('frontend/assets/js/script.js') }}"></script>

</body>

</html>