@extends('admin.admin')

@section('content')
<div class="page-wrapper">
    <div class="content bg-white">
        <div class="d-md-flex d-block align-items-center justify-content-between -bottom pb-3">
            <div class="my-auto mb-2">
                <h3 class="page-title mb-1">{{ __('shop_details') }}</h3>
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ url('/admin/shops') }}">{{ __('shops') }}</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">{{ $shop->shop_name }}</li>
                    </ol>
                </nav>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <h4 class="card-title">{{ __('shop_information') }}</h4>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>{{ __('shop_name')}}:</strong> {{ $shop->shop_name }}</p>
                        <p><strong>{{ __('owner_name')}}:</strong> {{ $shop->owner_name }}</p>
                        <p><strong>{{ __('email')}}:</strong> {{ $shop->email }}</p>

                         <p><strong>{{ __('address')}}:</strong>
                            {{ ucfirst($shop->address) }}, {{ $shop->cityRelation?->name }}, {{ $shop->stateRelation?->name }}, {{ $shop->countryRelation?->name }}
                        </p>

                    </div>
                    <div class="col-md-6">
                        <p><strong>{{ __('shop_logo')}}:</strong></p>
                        @if($shop->shop_logo)
                            <img src="{{ asset('storage/'.$shop->shop_logo) }}" alt="Shop Logo" >
                        @else
                            <p>-</p>
                        @endif
                    </div>
                    <div class="col-md-12 mt-3">
                        <p><strong>{{ __('description')}}:</strong>
                            {{ $shop->description }}
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection