@extends('admin.admin')
@section('content')

<div class="page-wrapper">
    <div class="content bg-white">
        <div class="d-md-flex d-block align-items-center justify-content-between pb-3">
            <div class="my-auto mb-2">
                <h3 class="page-title mb-1">{{ __('product_orders')}}</h3>
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">{{ __('Dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('product_orders')}}</li>
                    </ol>
                </nav>
            </div>
        </div>
        <div class="card">
            <ul class="nav nav-tabs bookingtab p-3 pb-0" id="bookingTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="all-orders-tab" data-bs-toggle="tab" type="button" role="tab" aria-controls="all-orders" aria-selected="true">
                        {{ __('All Orders') }}
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="pending-tab" data-bs-toggle="tab" type="button" role="tab" aria-controls="pending" aria-selected="false">
                        {{ __('Pending') }}
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="confirmed-tab" data-bs-toggle="tab" type="button" role="tab" aria-controls="confirmed" aria-selected="false">
                        {{ __('Confirmed') }}
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="shipped-tab" data-bs-toggle="tab" type="button" role="tab" aria-controls="shipped" aria-selected="false">
                        {{ __('Shipped') }}
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="delivery-tab" data-bs-toggle="tab" type="button" role="tab" aria-controls="delivery" aria-selected="false">
                        {{ __('Delivery') }}
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="vendor-cancel-tab" data-bs-toggle="tab" type="button" role="tab" aria-controls="vendor_cancel" aria-selected="false">
                        {{ __('Vendor Cancel') }}
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="customer-cancel-tab" data-bs-toggle="tab" type="button" role="tab" aria-controls="customer_cancel" aria-selected="false">
                        {{ __('Customer Cancel') }}
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="refund-initiated-tab" data-bs-toggle="tab" type="button" role="tab" aria-controls="refund_initiated" aria-selected="false">
                        {{ __('Refund Initiated') }}
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="refund-completed-tab" data-bs-toggle="tab" type="button" role="tab" aria-controls="refund_completed" aria-selected="false">
                        {{ __('Refund Completed') }}
                    </button>
                </li>
            </ul>

            <div class="card-body p-3 pb-0 booktable">
                <div class="custom-datatable-filter table-responsive">
                    {{-- You can add a search input here if you want, e.g. <input type="text" id="searchInput" placeholder="Search..."> --}}
                    <table class="table" id="ListOrderTable">
                        <thead class="thead-light">
                            <tr>
                                <th>{{ __('Order ID')}}</th>
                                <th>{{ __('Date')}}</th>
                                <th>{{ __('Customer')}}</th>
                                <th>{{ __('Provider')}}</th>
                                <th>{{ __('Product')}}</th>
                                <th>{{ __('Amount')}}</th>
                                <th>{{ __('Status')}}</th>
                                <th class="no-sort">{{ __('Action')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                                <td>
                                    <div class="skeleton data-skeleton data-loader"></div>
                                </td>
                            </tr>
                            {{-- Rows will be inserted here by JavaScript --}}
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="view-modal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="eventModalLabel">{{ __('Order Details')}} <span id="modal_order_id" class="badge bg-primary ms-2"></span></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p><strong>{{ __('Product')}}:</strong> <span id="modal_product_name"></span></p>
                <p><strong>{{ __('Customer')}}:</strong> <span id="modal_customer"></span></p>
                <p><strong>{{ __('Provider')}}:</strong> <span id="modal_provider"></span></p>
                <p><strong>{{ __('Order Date')}}:</strong> <span id="modal_date"></span></p>
                <hr>
                <p><strong>{{ __('Quantity')}}:</strong> <span id="modal_quantity"></span></p>
                <p><strong>{{ __('Variant')}}:</strong> <span id="modal_variant"></span></p>
                <p><strong>{{ __('Color')}}:</strong> <span id="modal_color"></span></p>
                <p><strong>{{ __('Price per Item')}}:</strong> <span id="modal_price"></span></p>
                <p><strong>{{ __('Subtotal')}}:</strong> <span id="modal_subtotal"></span></p>
                <hr>
                <p><strong>{{ __('Status')}}:</strong> <span id="modal_status"></span></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close')}}</button>
            </div>
        </div>
    </div>
</div>
@endsection