<?php
return [
    'form_validation_error' => [
        'key_required' => 'Key is required.',
        'key_unique' => 'The key already exists.',
        'value_required' => 'Value is required.',
        'group_id_required' => 'Group id is required.',
        'name_required' => 'Language Name is required',
        'code_unique' => 'Language Code should be unique',
        'name_unique' => 'Language Name should be unique',
        'code_required' => 'Language Code is required',
        'direction_required' => 'Language Direction is required',
        'direction_in' => 'Language Direction must be either LTR or RTL',
        'status_required' => 'Language Status is required',
        'status_boolean' => 'Language Status must be 0 or 1',
        'order_by_in' => 'The order_by field must be either "asc" or "desc".',
        'sort_by_in' => 'The sort_by field must be one of the following: id, name, code, or status.',
        'search_string' => 'The search field must be a valid string.',
        'commission_type' => 'Commission type is required.',
        'commission_rate_required' => 'Commission rate is required.',
        'commission_rate_integer' => 'Commission rate must be an number.',
        'tax_type' => 'Tax type is required.',
        'tax_type_unique' => 'Tax type already exists.',
        'tax_rate_required' => 'Tax rate is required.',
        'tax_rate_integer' => 'Tax rate must be an number.',
        'client_name_required' => 'Client name is required.',
        'position_required' => 'Position is required.',
        'client_image_mimes' => 'Only JPEG, JPG, PNG, and SVG format allowed.',
        'client_image_max_size' => 'The client image may not be greater than 2MB.',
        'description_required' => 'Description is required.',
        'description_words' => 'Description should contain no more than 300 words.',
        'email_required' => 'Email is required.',
        'email_valid_email' => 'Please enter a valid email.',
        'category_name_required' => 'Category Name is required.',
        'category_name_unique' => 'Category Name already exists.',
        'slug_required' => 'Slug is required.',
        'slug_unique' => 'Slug already exists.',
        'title_required' => 'Title is required',
        'category_required' => 'Title is required',
        'seo_description_words' => 'SEO Description should contain no more than 300 words.'
    ],
    'error_response' => [
        'the_key_already_exists' => 'The key already exists.',
        'no_global_setting_found' => 'No global settings found',
        'global_setting_not_found' => 'Global setting not found',
    ],
    'success_response' => [
        'global_setting_created_success' => 'Global setting created successfully.',
        'global_setting_retrived_success' => 'Global settings retrieved successfully.',
        'global_setting_update_success' => 'Global setting updated successfully.',
        'global_setting_delete_success' => 'Global setting deleted successfully.',
        'admin_commission_update_success' => 'Admin commission updated successfully.',
        'tax_options_update_success' => 'Tax options updated successfully.',
        'credential_setting_success' => 'Credential setting updated successfully.',
        'setting_success' => 'Settings updated successfully.',
        'tax_options_update_success' => 'Tax option updated successfully.',
        'tax_options_create_success' => 'Tax option created successfully.',
        'tax_options_delete_success' => 'Tax option deleted successfully.',
        'tax_options_status_success' => 'Tax option status updated successfully.',
        'testimonial_update_success' => 'Testimonial updated successfully.',
        'testimonial_create_success' => 'Testimonial created successfully.',
        'testimonial_delete_success' => 'Testimonial deleted successfully.',
        'testimonial_status_success' => 'Testimonial status updated successfully.',
        'email_subscription_create_success' => 'Email subscribed successfully.',
        'email_subscriber_delete_success' => 'Email subscriber deleted successfully.',
        'email_subscriber_status_success' => 'Email subscriber status updated successfully.',
        'sub_setting_success' => 'Subscription package stored successfully.',
        'sub_setting_update' => 'Subscription package updated successfully.',
        'faq_setting_success' => 'Faq stored successfully.',
        'faq_setting_update' => 'Faq updated successfully.',
        'blog_category_create_success' => 'Blog category created successfully.',
        'blog_category_update_success' => 'Blog category updated successfully.',
        'blog_category_delete_success' => 'Blog category deleted successfully.',
        'blog_category_status_success' => 'Blog category status updated successfully.',
        'blog_post_create_success' => 'Blog post created successfully.',
        'blog_post_update_success' => 'Blog post updated successfully.',
        'blog_post_delete_success' => 'Blog post deleted successfully.',
        'blog_post_status_success' => 'Blog post status updated successfully.',
        'page_setting_success' => 'Page created successfully.',
        'page_setting_update' => 'Page updated successfully.',
        'service_success' => 'Service created successfully.',
        'service_update_success' => 'Service updated successfully.',
        'dispute_setting_update' => 'Dispute responce updated successfully.',
    ],
    'datatable' => [
        'lengthMenu' => 'Show :menu entries',
        'info' => 'Showing :start to :end of :total entries',
        'infoEmpty' => 'Showing :start to :end of :total entries',
        'infoFiltered' => '(filtered from :max total entries)',
        'search' => 'Searchings',
        'paginate' => [
            'first' => 'First',
            'last' => 'Last',
            'next' => 'Next',
            'previous' => 'Previous'
        ],
    ],
];

