(function () {
	"use strict";

	// Mobile menu sidebar overlay
	function bindMobileMenu() {
		const isMobile = $(window).width() <= 991;

		if (isMobile) {
			// Mobile: bind click events
			$('.main-nav a').off('click').on('click', function (e) {
				const $parent = $(this).parent();
				const $submenu = $(this).next('ul');
				if ($parent.hasClass('has-submenu')) {
					e.preventDefault();

					if ($(this).hasClass('submenu')) {
						$(this).removeClass('submenu');
						$submenu.stop(true, true).slideUp(350);
					} else {
						$('.main-nav a').removeClass('submenu');
						$('.main-nav ul ul').slideUp(350);

						$(this).addClass('submenu');
						$submenu.stop(true, true).slideDown(350);
					}
				}
			});
		} else {
			$('.main-nav a').off('click'); // remove mobile click handler
			$('.main-nav a').removeClass('submenu'); // remove toggle class
			$('.main-nav .submenu').removeAttr('style'); // clear inline display:none
		}
	}
	$(document).ready(bindMobileMenu);
	$(window).on('resize', bindMobileMenu);

	// Mobile Click
	$(document).on('click', '#mobile_btn', function () {
		$('main-wrapper').toggleClass('slide-nav');
		$('.menu-overlay').toggleClass('opened');
		$('html').addClass('menu-opened');
		return false;
	});

	// Overlay
	$(document).on('click', '.menu-overlay', function () {
		$('html').removeClass('menu-opened');
		$(this).removeClass('opened');
		$('main-wrapper').removeClass('slide-nav');
	});

	// Menu Close
	$(document).on('click', '#menu_close', function () {
		$('html').removeClass('menu-opened');
		$('.sidebar-overlay').removeClass('opened');
		$('main-wrapper').removeClass('slide-nav');
	});

	// Sticky Header
	$(window).scroll(function () {
		const $header = $("header.header");
		if ($(this).scrollTop() > 130) {
			$header.addClass("fixed");
		} else {
			$header.removeClass("fixed").addClass("fadeInUp");
		}
	});

	// Toggle Password
	if ($('.toggle-password').length > 0) {
		$(document).on('click', '.toggle-password', function () {
			const $icon = $(this).find('i');
			const $input = $(this).closest('.input-group').find('.pass-input');
			if ($input.attr('type') === 'password') {
				$input.attr('type', 'text');
				$icon.removeClass('isax-eye-slash').addClass('isax-eye');
			} else {
				$input.attr('type', 'password');
				$icon.removeClass('isax-eye').addClass('isax isax-eye-slash');
			}
		});
	}

	// Radio button navigation functionality
	document.addEventListener('DOMContentLoaded', function () {
		const providerRadio = document.getElementById('provider');
		const userRadio = document.getElementById('user');

		// Function to handle navigation
		function handleRadioChange() {
			if (providerRadio.checked) {
				window.location.href = 'signup.html';
			} else if (userRadio.checked) {
				window.location.href = 'user-signup.html';
			}
		}

		// Add event listeners
		if (providerRadio) {
			providerRadio.addEventListener('change', handleRadioChange);
		}
		if (userRadio) {
			userRadio.addEventListener('change', handleRadioChange);
		}
	});

	// Partners Slider
	$('.testimonial-slider').each(function () {
		const $slider = $(this);
		if (!$slider.hasClass('slick-initialized')) {
			$slider.slick({
				dots: false,
				infinite: true,
				rtl: true,
				speed: 2000,
				slidesToShow: 3,
				slidesToScroll: 1,
				centerMode: true,
				autoplay: false,
				arrows: false,
				adaptiveHeight: true,
				responsive: [
					{
						breakpoint: 992,
						settings: { slidesToShow: 2 }
					},
					{
						breakpoint: 768,
						settings: { slidesToShow: 2 }
					},
					{
						breakpoint: 700,
						settings: { slidesToShow: 1, dots: true }
					}
				]
			});
		}
	});

	// AOS Animation
	if ($('.main-wrapper .aos').length > 0) {
		AOS.init({
			duration: 1200,
			once: true
		});
	}

	// Cart Count
	document.addEventListener("DOMContentLoaded", function () {
		document.body.addEventListener("click", function (e) {
			const btn = e.target.closest(".add-btn, .minus-btn");
			if (!btn) return;

			const container = btn.closest(".quantity-control");
			if (!container) return;

			const input = container.querySelector(".quantity-input");
			let currentValue = parseInt(input.value) || 0;

			if (btn.classList.contains("add-btn")) {
				input.value = currentValue + 1;
			} else if (btn.classList.contains("minus-btn") && currentValue > 1) {
				input.value = currentValue - 1;
			}
		});
	});

	// Select2 Initialization
	if ($('.select').length > 0) {
		$('.select').select2({
			minimumResultsForSearch: -1,
			width: '100%'
		});
	}

	// Reusable "Show More/Less" Toggle for Multiple Sections
	for (let i = 0; i <= 6; i++) {
		const moreMenu = $(`.more-menu${i || ''}`);
		const viewAllBtn = $(`.viewall${i || ''}-button`);

		if (moreMenu.length > 0) {
			moreMenu.hide();
			viewAllBtn.on("click", function () {
				const isLess = $(this).text() === "Show Less";
				$(this).text(isLess ? "Show More" : "Show Less");
				moreMenu.slideToggle(900);
			});
		}
	}

	// Select radio inputs
	document.querySelectorAll('input[name="pay-tab"]').forEach((radio) => {
		radio.addEventListener('change', function () {
			document.querySelectorAll('.order-card').forEach(card => card.classList.remove('active'));
			if (this.checked) {
				this.closest('.order-card').classList.add('active');
			}
		});
	});

	document.querySelectorAll('input[name="pay-tab1"]').forEach((radio) => {
		radio.addEventListener('change', function () {
			document.querySelectorAll('.order-card1').forEach(card => card.classList.remove('active'));
			if (this.checked) {
				this.closest('.order-card1').classList.add('active');
			}
		});
	});

	// Horizontal Slider with Infinite Auto Scroll
	if ($('.horizontal-slider').length > 0) {
		$('.slider-for').slick({
			slidesToShow: 1,
			slidesToScroll: 1,
			arrows: false,
			fade: true,
			infinite: true,
			asNavFor: '.slider-nav'
		});

		$('.slider-nav').slick({
			slidesToShow: 5,
			slidesToScroll: 1,
			asNavFor: '.slider-for',
			dots: false,
			arrows: false,
			focusOnSelect: true,
			infinite: true,
			draggable: true,
			swipeToSlide: true,
			autoplay: true,
			autoplaySpeed: 4000,
			pauseOnHover: true,
			prevArrow: "<span class='slick-prev'><i class='ti ti-chevron-left'></i></span>",
			nextArrow: "<span class='slick-next'><i class='ti ti-chevron-right'></i></span>",
			responsive: [
				{ breakpoint: 992, settings: { slidesToShow: 5 } },
				{ breakpoint: 780, settings: { slidesToShow: 4 } },
				{ breakpoint: 580, settings: { slidesToShow: 3 } },
				{ breakpoint: 0, settings: { slidesToShow: 2 } }
			]
		});
	}

	// Vertical Slider
	if ($('.vertical-slider').length > 0) {
		$('.slider-for').slick({
			slidesToShow: 1,
			slidesToScroll: 1,
			arrows: false,
			rtl: true,
			fade: true,
			asNavFor: '.slider-nav'
		});
		$('.slider-nav').slick({
			slidesToShow: 5,
			slidesToScroll: 1,
			vertical: true,
			asNavFor: '.slider-for',
			dots: false,
			arrows: true,
			focusOnSelect: true,
			verticalSwiping: true,
			prevArrow: "<span class='slick-next'><i class='ti ti-chevron-down'></i></span>",
			nextArrow: "<span class='slick-prev'><i class='ti ti-chevron-up'></i></span>",
			responsive: [
				{
					breakpoint: 992,
					settings: { slidesToShow: 5 }
				},
				{
					breakpoint: 780,
					settings: { slidesToShow: 4 }
				},
				{
					breakpoint: 580,
					settings: { slidesToShow: 3 }
				},
				{
					breakpoint: 0,
					settings: { vertical: false, slidesToShow: 1 }
				}
			]
		});
	}

	// Horizontal Slider with Infinite Auto Scroll
	if ($('.mobile-slider').length > 0) {
		$('.slider-for').slick({
			slidesToShow: 1,
			slidesToScroll: 1,
			arrows: false,
			fade: true,
			rtl: true,
			infinite: true,
			asNavFor: '.slider-nav'
		});

		$('.slider-nav').slick({
			slidesToShow: 5,
			slidesToScroll: 1,
			asNavFor: '.slider-for',
			dots: false,
			arrows: false,
			rtl: true,
			focusOnSelect: true,
			infinite: true,
			draggable: true,
			swipeToSlide: true,
			autoplay: true,
			autoplaySpeed: 4000,
			pauseOnHover: true,
			prevArrow: "<span class='slick-prev'><i class='ti ti-chevron-left'></i></span>",
			nextArrow: "<span class='slick-next'><i class='ti ti-chevron-right'></i></span>",
			responsive: [
				{ breakpoint: 992, settings: { slidesToShow: 5 } },
				{ breakpoint: 780, settings: { slidesToShow: 4 } },
				{ breakpoint: 580, settings: { slidesToShow: 3 } },
				{ breakpoint: 0, settings: { slidesToShow: 2 } }
			]
		});
	}

	// Product Slider
	$('.product-slider').each(function () {
		const $slider = $(this);
		if (!$slider.hasClass('slick-initialized')) {
			$slider.slick({
				dots: false,
				infinite: true,
				speed: 2000,
				rtl: true,
				slidesToShow: 4,
				slidesToScroll: 1,
				autoplay: false,
				arrows: true,
				prevArrow: '<button type="button" class="slick-prev"><i class="isax isax-arrow-left"></i></button>',
				nextArrow: '<button type="button" class="slick-next"><i class="isax isax-arrow-right-1"></i></button>',
				responsive: [
					{
						breakpoint: 1300,
						settings: { slidesToShow: 3, slidesToScroll: 1 }
					},
					{
						breakpoint: 992,
						settings: { slidesToShow: 2, slidesToScroll: 1 }
					},
					{
						breakpoint: 768,
						settings: { slidesToShow: 2, slidesToScroll: 1 }
					},
					{
						breakpoint: 576,
						settings: { slidesToShow: 1, slidesToScroll: 1 }
					}
				]
			});
		}
	});

	// Service Details Slider
	$('.service-details-slider').each(function () {
		const $slider = $(this);
		if (!$slider.hasClass('slick-initialized')) {
			$slider.slick({
				dots: false,
				infinite: true,
				speed: 2000,
				rtl: true,
				slidesToShow: 3,
				slidesToScroll: 1,
				autoplay: false,
				arrows: true,
				prevArrow: '<button type="button" class="slick-prev"><i class="isax isax-arrow-left"></i></button>',
				nextArrow: '<button type="button" class="slick-next"><i class="isax isax-arrow-right-1"></i></button>',
				responsive: [
					{
						breakpoint: 1200,
						settings: { slidesToShow: 3, slidesToScroll: 1 }
					},
					{
						breakpoint: 992,
						settings: { slidesToShow: 2, slidesToScroll: 1 }
					},
					{
						breakpoint: 768,
						settings: { slidesToShow: 2, slidesToScroll: 1 }
					},
					{
						breakpoint: 576,
						settings: { slidesToShow: 1, slidesToScroll: 1 }
					}
				]
			});
		}
	});

	// Horizontal Slide (Infinite Scroll)
	document.addEventListener("DOMContentLoaded", function () {
		document.querySelectorAll(".horizontal-slide").forEach(scroller => {
			scroller.setAttribute("data-animated", true);
			const scrollerInner = scroller.querySelector(".slide-list");
			const scrollerContent = Array.from(scrollerInner.children);
			scrollerContent.forEach(item => {
				const clone = item.cloneNode(true);
				clone.setAttribute("aria-hidden", true);
				scrollerInner.appendChild(clone);
			});
		});
	});

	// Horizontal Slide (Infinite Scroll)
	document.addEventListener("DOMContentLoaded", function () {
		document.querySelectorAll(".horizontal-slide").forEach(scroller => {
			scroller.setAttribute("data-animated", true);
			const scrollerInner = scroller.querySelector(".slide-list");
			const scrollerContent = Array.from(scrollerInner.children);
			scrollerContent.forEach(item => {
				const clone = item.cloneNode(true);
				clone.setAttribute("aria-hidden", true);
				scrollerInner.appendChild(clone);
			});
		});
	});

	// Circular Text
	document.querySelectorAll('.circular-text').forEach(container => {
		const chars = container.querySelectorAll('.char');
		const radius = 40;
		const angleIncrement = 360 / chars.length;

		chars.forEach((char, index) => {
			const angle = index * angleIncrement;
			char.style.transform = `rotate(${angle}deg) translate(0, -${radius}px)`;
		});
	});

	// Datetimepicker
	if ($('.datepic').length > 0) {
		$('.datepic').datetimepicker({
			format: 'DD-MM-YYYY',
			keepOpen: true, inline: true,
			icons: {
				up: "fas fa-angle-up",
				down: "fas fa-angle-down",
				next: 'fas fa-angle-right',
				previous: 'fas fa-angle-left'
			}
		});
	}

	// Time Slot
	document.addEventListener("DOMContentLoaded", function () {
		const slots = document.querySelectorAll(".time-slot");

		slots.forEach(slot => {
			slot.addEventListener("click", function () {
				if (slot.classList.contains("disabled")) return; // prevent disabled selection

				// remove active from all
				slots.forEach(s => s.classList.remove("active"));

				// set clicked slot as active
				slot.classList.add("active");

				// get selected time
				const selectedTime = slot.textContent.trim();
				console.log("Selected Time:", selectedTime);
			});
		});
	});

	function initSelectTags(groupClass) {
		const tags = document.querySelectorAll(`.${groupClass}`);
		tags.forEach(tag => {
			tag.addEventListener("click", function () {
				tags.forEach(el => el.classList.remove("active")); // reset in this group only
				this.classList.add("active");
			});
		});
	}

	// Init for both groups
	initSelectTags("select-tag");
	initSelectTags("select-tag1");


	// Rating star
	const stars = document.querySelectorAll(".rating .fa-star");

	stars.forEach((star, index) => {
		star.addEventListener("click", () => {
			stars.forEach(s => s.classList.remove("filled"));

			for (let i = 0; i <= index; i++) {
				stars[i].classList.add("filled");
			}
		});
	});

	// CounterUp Initialization
	if ($(".counter").length > 0) {
		$(".counter").counterUp({
			delay: 10,
			time: 2000,
		});
		$(".counter").addClass("animated fadeInDownBig");
	}

	// Click like button
	document.querySelectorAll(".favourite").forEach(btn => {
		btn.addEventListener("click", function () {
			const icon = this.querySelector("i");
			if (icon.classList.contains("isax-heart")) {
				icon.classList.remove("isax-heart");
				icon.classList.add("isax-heart5");
				icon.style.color = "red"; // make it red when filled
			} else {
				icon.classList.remove("isax-heart5");
				icon.classList.add("isax-heart");
				icon.style.color = ""; // reset color
			}
		});
	});

	// Testimonial Slider
	$('.testimonial-slider-two').each(function () {
		const $slider = $(this);
		if (!$slider.hasClass('slick-initialized')) {
			$slider.slick({
				dots: false,
				infinite: true,
				rtl: true,
				speed: 2000,
				prevArrow: $('.testimonial-nav-prev'),
				nextArrow: $('.testimonial-nav-next'),
				slidesToShow: 2,
				slidesToScroll: 1,
				autoplay: false,
				arrows: true,
				responsive: [
					{
						breakpoint: 991.98,
						settings: { slidesToShow: 1, slidesToScroll: 1 }
					}
				]
			});
		}
	});

	// Sidebar
	function initSidebar() {
		$('.sidebar-menus').on('click', 'a', function (e) {
			const $link = $(this);
			const $submenuParent = $link.parent('.submenu');
			if ($submenuParent.length) {
				e.preventDefault();
				const $currentUl = $link.next('ul');
				if (!$link.hasClass('subdrop')) {
					$submenuParent.siblings().find('ul').slideUp(250);
					$submenuParent.siblings().find('a').removeClass('subdrop');
					$currentUl.slideDown(350);
					$link.addClass('subdrop');
				} else {
					// Collapse current submenu
					$link.removeClass('subdrop');
					$currentUl.slideUp(350);
				}
			}
		});
		// Auto-expand parent of active submenu
		$('.sidebar-menus .submenu a.active').parents('.submenu').children('a').addClass('subdrop').next('ul').show();
	}
	initSidebar();

	// Date Range Picker
	if ($('#reportrange').length > 0) {
		const start = moment().subtract(0, "days");
		const end = moment();
		const report_range = (start, end) => {
			$("#reportrange span").html(`${start.format("D MMM YY")} - ${end.format("D MMM YY")}`);
		};
		$("#reportrange").daterangepicker(
			{
				startDate: start,
				endDate: end,
				ranges: {
					'Today': [moment(), moment()],
					'Yesterday': [moment().subtract(1, "days"), moment().subtract(1, "days")],
					"Last 7 Days": [moment().subtract(6, "days"), moment()],
					"Last 30 Days": [moment().subtract(29, "days"), moment()],
					"This Month": [moment().startOf("month"), moment().endOf("month")],
					"Last Month": [
						moment().subtract(1, "month").startOf("month"),
						moment().subtract(1, "month").endOf("month")
					]
				}
			},
			report_range
		);
		report_range(start, end);
	}

	// Payment Options
	if ($('#payment-options').length > 0) {
		const $paymentSection = $('#payment-options');
		const $contents = $('.payment-content');
		const hideAllContents = function () {
			$contents.addClass('d-none');
		};
		const showContent = function (suffix) {
			$('#payment-content-' + suffix).removeClass('d-none');
		};
		$paymentSection.find('input[type="radio"]').on('click', function () {
			if ($(this).is(':checked')) {
				hideAllContents();
				const suffix = this.id.replace('payment-', '');
				showContent(suffix);
			}
		});
		hideAllContents();
		showContent('credit'); // Default visible section
	}

	// Quill Editor
	document.querySelectorAll(".editor").forEach((el) => {
		new Quill(el, {
			theme: "snow",
			modules: {
			toolbar: [
				["bold", "italic", "underline"],
				[{ header: [null, 1, 2, 3, 4, 5, 6] }],
				[{ list: "ordered" }, { list: "bullet" }],
				["link", "image", "video"]
			]
			}
		});
    });

	// Datetimepicker
	if($('.datetimepicker').length > 0 ){
		$('.datetimepicker').datetimepicker({
			format: 'DD-MM-YYYY',
			icons: {
				up: "isax isax-arrow-up-2",
				down: "isax isax-arrow-down-1",
				next: 'isax isax-arrow-right-3',
				previous: 'isax isax-arrow-left-2'
			}
		});
	}

	// Timepicker
	if ($('.timepicker').length > 0) {
		$('.timepicker').datetimepicker({
			format: 'HH:mm A',
			icons: {
				up: "isax isax-arrow-up-2",
				down: "isax isax-arrow-down-1",
				next: 'isax isax-arrow-right-3',
				previous: 'isax isax-arrow-left-2'
			}
		});
	}

	// Sticky Sidebar
	// if ($(window).width() > 767) {
	// 	if ($('.theiaStickySidebar').length > 0) {
	// 		$('.theiaStickySidebar').theiaStickySidebar({
	// 			additionalMarginTop: 30
	// 		});
	// 	}
	// }

	// Availability
	document.addEventListener("DOMContentLoaded", function () {
		document.querySelectorAll(".available-accordion .accordion-item").forEach(item => {
			const switchInput = item.querySelector(".form-check-input");
			const accordionBtn = item.querySelector(".accordion-button");
			const collapseEl = item.querySelector(".accordion-collapse");

			function toggleAccordionState() {
			if (switchInput.checked) {
				accordionBtn.classList.remove("disabled");
				accordionBtn.removeAttribute("disabled");
			} else {
				accordionBtn.classList.add("disabled");
				accordionBtn.setAttribute("disabled", "true");

				// auto-close if it's open
				if (collapseEl.classList.contains("show")) {
				let bsCollapse = bootstrap.Collapse.getInstance(collapseEl);
				if (!bsCollapse) {
					bsCollapse = new bootstrap.Collapse(collapseEl, { toggle: false });
				}
				bsCollapse.hide();
				}
			}
			}

			// prevent accordion toggle when disabled
			accordionBtn.addEventListener("click", function (e) {
			if (accordionBtn.classList.contains("disabled")) {
				e.stopPropagation();
				e.preventDefault();
			}
			});

			if (!switchInput) return;

			// prevent accordion toggle when clicking switch inside
			switchInput.addEventListener("click", function (e) {
			e.stopPropagation();
			});
			toggleAccordionState();

			// Watch for switch changes
			switchInput.addEventListener("change", toggleAccordionState);
		});
	});

	// Add Shop
	if ($('.add-wizard').length > 0) {
		$(document).on('click', '.form-wizard-content .next-btn', function () {
			const $fieldset = $(this).closest('.form-wizard-content');
			const $nextFieldset = $fieldset.next();
			const $progressBar = $('.wishlist-tab');

			$fieldset.hide();              // Hide current step
			$nextFieldset.fadeIn('slow');  // Show next step with fade

			// Update progress bar state
			 const $active = $progressBar.find('.nav-link.active');
			$active.removeClass('active').addClass('activated');
			$active.closest('li').next().find('.nav-link').addClass('active');
		});
		$(document).on('click', '.form-wizard-content .prev-btn', function () {
			const $fieldset = $(this).closest('.form-wizard-content');
			const $prevFieldset = $fieldset.prev();
			const $progressBar = $('.wishlist-tab');

			$fieldset.hide(); // Hide current step
			$prevFieldset.fadeIn('slow'); // Show previous step with fade

			// Update progress bar state
			const $active = $progressBar.find('.nav-link.active');
			$active.removeClass('active'); // Remove active from current
			$active.closest('li').prev().find('.nav-link').removeClass('activated').addClass('active');
		});
	}

	// Only one default checkbox
	document.addEventListener("change", function (e) {
		if (e.target.name === "default" && e.target.type === "checkbox") {
			document.querySelectorAll('input[name="default"]').forEach(cb => {
			if (cb !== e.target) cb.checked = false;
			});
		}
	});

	// Product Type Show/Hide
	$(document).on('change', 'input[name="product"]', function () {
		if ($('#single').is(':checked')) {
			$('#single-content').show();
			$('#variable-content').hide();
		} else if ($('#variable').is(':checked')) {
			$('#variable-content').show();
			$('#single-content').hide();
		}
	});

	// Show/Hide Reason Box
	if ($('#reason-select').length > 0) {
		$('#reason-select').on('change', function () {
			$('#other-reason-box').toggle($(this).val() === 'others');
		});
	};


	// Year Month Picker
	if ($('.yearmonthpicker').length > 0) {
		$('.yearmonthpicker').datetimepicker({
			format: 'MM-YY',
			icons: {
				up: "isax isax-arrow-up",
				down: "isax isax-arrow-down",
				next: "isax isax-arrow-right-1",
				previous: "isax isax-arrow-left"

			}
		});
	}

})();