$(document).ready(function() {
    $('#country').on('change', function() {
        var countryId = $(this).val();
        $('#state').html('<option value="">Select State</option>').trigger('change');
        $('#city').html('<option value="">Select City</option>').trigger('change');
        if (countryId) {
            $.ajax({
                url: '/get-states?country_id=' + countryId,
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $.each(data.states, function(key, value) {
                        $('#state').append('<option value="' + value.id + '">' + value.name + '</option>');
                    });
                }
            });
        }
    });

    $('#state').on('change', function() {
        var stateId = $(this).val();
        $('#city').html('<option value="">Select City</option>').trigger('change');
        if (stateId) {
            $.ajax({
                url: '/get-cities?state_id=' + stateId,
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $.each(data.cities, function(key, value) {
                        $('#city').append('<option value="' + value.id + '">' + value.name + '</option>');
                    });
                }
            });
        }
    });
});

