/* global window, fetch */
(function () {
    "use strict";
    window.loadTranslationFile = async function (keys = []) {
        try {
            const params = new URLSearchParams();
            keys.forEach(k => params.append("keys[]", k));

            const file = "web";

            const response = await fetch(`/user/translations?${params.toString()}`);

            if (!response.ok) throw new Error(`Failed to load ${file} translations`);

            const data = await response.json();

            window.translations = window.translations || {};
            window.translations = {
                ...window.translations,
                ...data
            };

        } catch (error) {
            console.error("Translation load failed:", error);
        }
    };

    window._l = function (key, replacements = {}) {
        let translation = window.translations?.[key] ?? key;

        // Replace placeholders :name, :count etc.
        Object.keys(replacements).forEach((placeholder) => {
            const regex = new RegExp(`:${placeholder}`, "g");
            translation = translation.replace(regex, replacements[placeholder]);
        });

        return translation;
    };

})();