document.addEventListener('DOMContentLoaded', function() {
    function handleFileInput(inputId, containerId, multiple = false) {
        const input = document.getElementById(inputId);
        const container = document.getElementById(containerId);
        
        if (!input || !container) return;

        input.addEventListener('change', function(event) {
            if (!multiple) {
                container.innerHTML = '';
            }
            
            const files = event.target.files;
            for (let i = 0; i < files.length; i++) {
                const file = files[i];
                if (file.type.startsWith('image/')) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const item = document.createElement('div');
                        item.classList.add('gallery-item');
                        
                        const img = document.createElement('img');
                        img.src = e.target.result;
                        item.appendChild(img);
                        
                        if (multiple) {
                            const removeBtn = document.createElement('button');
                            removeBtn.classList.add('remove-image');
                            removeBtn.innerHTML = '&times;';
                            removeBtn.type = 'button';
                            removeBtn.onclick = function() {
                                item.remove();
                            };
                            item.appendChild(removeBtn);
                        }
                        container.appendChild(item);
                    };
                    reader.readAsDataURL(file);
                }
            }
        });
    }

    handleFileInput('shop_logo_input', 'logo_preview_container');
    handleFileInput('gallery_input', 'gallery_preview_container', true);

    document.addEventListener('click', function(e){
        if(e.target && e.target.classList.contains('remove-existing-image')){
            const imagePath = e.target.dataset.path;
            const form = document.getElementById('shop-form');
            const hiddenInput = document.createElement('input');
            hiddenInput.type = 'hidden';
            hiddenInput.name = 'removed_gallery_images[]';
            hiddenInput.value = imagePath;
            form.appendChild(hiddenInput);
            e.target.closest('.gallery-item').remove();
        }
    });
});

