document.addEventListener('DOMContentLoaded', function () {
    const infoTab = document.getElementById('info-tab');
    const availabilityTab = document.getElementById('availability-tab');
    
    const infoContent = document.getElementById('info-content');
    const availabilityContent = document.getElementById('availability-content');

    const nextBtn = document.querySelector('.next-btn');
    const prevBtn = document.querySelector('.prev-btn');

    if (nextBtn) {
        nextBtn.addEventListener('click', function () {
            infoTab.classList.remove('active');
            availabilityTab.classList.add('active');
            
            infoContent.classList.remove('active');
            availabilityContent.classList.add('active');
        });
    }

    if (prevBtn) {
        prevBtn.addEventListener('click', function () {
            availabilityTab.classList.remove('active');
            infoTab.classList.add('active');

            availabilityContent.classList.remove('active');
            infoContent.classList.add('active');
        });
    }

    // Toggle accordion body based on switch state
    document.querySelectorAll('.day-switch').forEach(function (switchEl) {
        const accordionButton = switchEl.closest('.accordion-button');
        const accordionCollapse = document.getElementById(accordionButton.getAttribute('data-bs-target').substring(1));

        function toggleAccordion() {
            if (switchEl.checked) {
                accordionButton.classList.remove('collapsed');
                accordionButton.setAttribute('aria-expanded', 'true');
                accordionCollapse.classList.add('show');
            } else {
                accordionButton.classList.add('collapsed');
                accordionButton.setAttribute('aria-expanded', 'false');
                accordionCollapse.classList.remove('show');
            }
        }

        switchEl.addEventListener('change', toggleAccordion);
        // Initial check
        toggleAccordion();
    });
});
